/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.CommonBreakpointGutterIconRenderer;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultipleBreakpointGutterIconRenderer
extends CommonBreakpointGutterIconRenderer
implements DumbAware {
    private final List<XBreakpointProxy> breakpoints;

    MultipleBreakpointGutterIconRenderer(List<XBreakpointProxy> breakpoints) {
        this.breakpoints = breakpoints;
        assert (breakpoints.size() >= 2);
    }

    private boolean areAllDisabled() {
        return ContainerUtil.and(this.breakpoints, b -> !b.isEnabled());
    }

    @NotNull
    public Icon getIcon() {
        XDebugSessionProxy session = XDebugManagerProxy.getInstance().getCurrentSessionProxy(this.breakpoints.get(0).getProject());
        if (session != null && session.areBreakpointsMuted()) {
            Icon icon = AllIcons.Debugger.MultipleBreakpointsMuted;
            if (icon == null) {
                MultipleBreakpointGutterIconRenderer.$$$reportNull$$$0(0);
            }
            return icon;
        }
        if (this.areAllDisabled()) {
            Icon icon = AllIcons.Debugger.MultipleBreakpointsDisabled;
            if (icon == null) {
                MultipleBreakpointGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return icon;
        }
        Icon icon = AllIcons.Debugger.MultipleBreakpoints;
        if (icon == null) {
            MultipleBreakpointGutterIconRenderer.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public String getAccessibleName() {
        String string = super.getAccessibleName();
        if (string == null) {
            MultipleBreakpointGutterIconRenderer.$$$reportNull$$$0(3);
        }
        return string;
    }

    private AnAction createToggleAction() {
        return DumbAwareAction.create(e -> {
            boolean newEnabledValue = this.areAllDisabled();
            for (XBreakpointProxy b : this.breakpoints) {
                b.setEnabled(newEnabledValue);
            }
        });
    }

    private AnAction createRemoveAction() {
        return DumbAwareAction.create(e -> this.removeBreakpoints());
    }

    private void removeBreakpoints() {
        XDebuggerUtilImpl.removeBreakpointsWithConfirmation(this.breakpoints);
    }

    @Nullable
    public AnAction getClickAction() {
        if (Registry.is((String)"debugger.click.disable.breakpoints")) {
            return this.createToggleAction();
        }
        return this.createRemoveAction();
    }

    @Nullable
    public AnAction getMiddleButtonClickAction() {
        if (!Registry.is((String)"debugger.click.disable.breakpoints")) {
            return this.createToggleAction();
        }
        return this.createRemoveAction();
    }

    @Nullable
    public AnAction getRightButtonClickAction() {
        return DumbAwareAction.create(e -> {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            XBreakpointProxy initialOne = (XBreakpointProxy)this.breakpoints.stream().sorted().findFirst().get();
            BreakpointsDialogFactory.getInstance(project).showDialog(initialOne.getId());
        });
    }

    @Nullable
    public ActionGroup getPopupMenuActions() {
        return super.getPopupMenuActions();
    }

    @Nullable
    public String getTooltipText() {
        return XDebuggerBundle.message((String)"xbreakpoint.tooltip.multiple", (Object[])new Object[0]);
    }

    public GutterDraggableObject getDraggableObject() {
        return new GutterDraggableObject(){

            public boolean copy(int line, VirtualFile file2, int actionId) {
                return false;
            }

            public void remove() {
                MultipleBreakpointGutterIconRenderer.this.removeBreakpoints();
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof MultipleBreakpointGutterIconRenderer)) return false;
        MultipleBreakpointGutterIconRenderer that = (MultipleBreakpointGutterIconRenderer)((Object)obj);
        if (!this.breakpoints.equals(that.breakpoints)) return false;
        return true;
    }

    public int hashCode() {
        return this.breakpoints.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/xdebugger/impl/breakpoints/MultipleBreakpointGutterIconRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

