/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.rpc.XBreakpointId;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XLineBreakpointTypeProxy;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.XLightBreakpointPropertiesPanel;
import com.intellij.xdebugger.impl.proxy.MonolithBreakpointProxyKt;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class XBreakpointItem
extends BreakpointItem {
    private final XBreakpointProxy myBreakpointProxy;
    private final XBreakpointManagerProxy myBreakpointManagerProxy;
    private XLightBreakpointPropertiesPanel myPropertiesPanel;

    public XBreakpointItem(XBreakpointBase<?, ?, ?> breakpoint2, XBreakpointManagerProxy breakpointManagerProxy) {
        this.myBreakpointProxy = MonolithBreakpointProxyKt.asProxy(breakpoint2);
        this.myBreakpointManagerProxy = breakpointManagerProxy;
    }

    public XBreakpointItem(XBreakpointProxy breakpointProxy, XBreakpointManagerProxy breakpointManagerProxy) {
        this.myBreakpointProxy = breakpointProxy;
        this.myBreakpointManagerProxy = breakpointManagerProxy;
    }

    public void setupRenderer(ColoredListCellRenderer renderer, Project project, boolean selected) {
        this.setupGenericRenderer((SimpleColoredComponent)renderer, true);
    }

    public void setupRenderer(ColoredTreeCellRenderer renderer, Project project, boolean selected) {
        this.setupGenericRenderer((SimpleColoredComponent)renderer, false);
    }

    public void setupGenericRenderer(SimpleColoredComponent renderer, boolean plainView) {
        renderer.setIcon(this.getIcon());
        SimpleTextAttributes attributes = this.myBreakpointProxy.isEnabled() ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
        renderer.append(StringUtil.notNullize((String)this.getDisplayText()), attributes);
        String description = this.getUserDescription();
        if (!StringUtil.isEmpty((String)description)) {
            renderer.append(" (" + description + ")", SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
        }
    }

    public String getDisplayText() {
        return this.myBreakpointProxy.getDisplayText();
    }

    @Nullable
    @Nls
    private String getUserDescription() {
        return this.myBreakpointProxy.getUserDescription();
    }

    public Icon getIcon() {
        return this.myBreakpointProxy.getIcon();
    }

    public String speedSearchText() {
        XExpression logExpr = this.myBreakpointProxy.getLogExpressionObjectInt();
        XExpression condExpr = this.myBreakpointProxy.getConditionExpressionInt();
        return this.getDisplayText() + " " + StringUtil.notNullize((String)this.getUserDescription()) + " " + (logExpr != null ? logExpr.getExpression() : "") + " " + (condExpr != null ? condExpr.getExpression() : "");
    }

    @Nls
    public String footerText() {
        return null;
    }

    public void saveState() {
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.saveProperties();
        }
    }

    public void doUpdateDetailView(DetailView panel2, boolean editorOnly) {
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.dispose();
            this.myPropertiesPanel = null;
        }
        if (!editorOnly) {
            Project project = this.myBreakpointProxy.getProject();
            this.myPropertiesPanel = new XLightBreakpointPropertiesPanel(project, this.myBreakpointManagerProxy, this.myBreakpointProxy, true, false);
            panel2.setPropertiesPanel(this.myPropertiesPanel.getMainPanel());
        }
        panel2.clearEditor();
        ReadAction.nonBlocking(() -> this.myBreakpointProxy.getSourcePosition()).finishOnUiThread(ModalityState.defaultModalityState(), sourcePosition -> {
            if (sourcePosition != null && sourcePosition.getFile().isValid()) {
                this.showInEditor(panel2, sourcePosition.getFile(), sourcePosition.getLine());
            } else {
                panel2.clearEditor();
            }
        }).coalesceBy(new Object[]{panel2}).submit((Executor)AppExecutorUtil.getAppExecutorService());
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.setDetailView(panel2);
            this.myPropertiesPanel.loadProperties();
            this.myPropertiesPanel.getMainPanel().revalidate();
        }
    }

    private void showInEditor(DetailView panel2, VirtualFile virtualFile, int line) {
        Editor editor;
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.BREAKPOINT_ATTRIBUTES);
        boolean isLineBreakpoint = this.myBreakpointProxy.getType() instanceof XLineBreakpointTypeProxy;
        DetailView.PreviewEditorState state = DetailView.PreviewEditorState.create((VirtualFile)virtualFile, (int)line, (TextAttributes)(isLineBreakpoint ? null : attributes));
        if (state.equals((Object)panel2.getEditorState())) {
            return;
        }
        panel2.navigateInPreviewEditor(state);
        TextAttributes softerAttributes = attributes.clone();
        Color backgroundColor = softerAttributes.getBackgroundColor();
        if (backgroundColor != null) {
            softerAttributes.setBackgroundColor(ColorUtil.desaturate((Color)backgroundColor, (int)10));
        }
        if ((editor = panel2.getEditor()) != null) {
            MarkupModel editorModel = editor.getMarkupModel();
            MarkupModel documentModel = DocumentMarkupModel.forDocument((Document)editor.getDocument(), (Project)editor.getProject(), (boolean)false);
            for (RangeHighlighter highlighter : documentModel.getAllHighlighters()) {
                int line1;
                if (highlighter.getUserData(DebuggerColors.BREAKPOINT_HIGHLIGHTER_KEY) != Boolean.TRUE || (line1 = editor.offsetToLogicalPosition((int)highlighter.getStartOffset()).line) == line) continue;
                if (highlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE) {
                    editorModel.addLineHighlighter(line1, 2981, softerAttributes);
                    continue;
                }
                editorModel.addRangeHighlighter(highlighter.getStartOffset(), highlighter.getEndOffset(), 2981, softerAttributes, HighlighterTargetArea.EXACT_RANGE);
            }
        }
    }

    public void navigate(boolean requestFocus) {
        Navigatable navigatable = this.myBreakpointProxy.getNavigatable();
        if (navigatable != null && navigatable.canNavigate()) {
            navigatable.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.myBreakpointProxy.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myBreakpointProxy.canNavigateToSource();
    }

    public boolean allowedToRemove() {
        return !this.myBreakpointProxy.isDefaultBreakpoint();
    }

    public void removed(Project project) {
        this.myBreakpointManagerProxy.removeBreakpoint(this.myBreakpointProxy);
    }

    public XBreakpointProxy getBreakpoint() {
        return this.myBreakpointProxy;
    }

    public boolean isEnabled() {
        return this.myBreakpointProxy.isEnabled();
    }

    public void setEnabled(boolean state) {
        this.myBreakpointProxy.setEnabled(state);
    }

    public boolean isDefaultBreakpoint() {
        return this.myBreakpointProxy.isDefaultBreakpoint();
    }

    @Nullable
    public XBreakpointId getId() {
        return this.myBreakpointProxy.getId();
    }

    public int compareTo(BreakpointItem breakpointItem) {
        XBreakpointProxy otherBreakpoint = breakpointItem.getBreakpoint();
        if (otherBreakpoint == null) {
            return 1;
        }
        return this.myBreakpointProxy.compareTo((Object)otherBreakpoint);
    }

    public void dispose() {
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.dispose();
            this.myPropertiesPanel = null;
        }
    }
}

