/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XDependentBreakpointManagerProxy;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointChooser;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointNoneItem;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPropertiesSubPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class XMasterBreakpointPanel
extends XBreakpointPropertiesSubPanel {
    private JPanel myMasterBreakpointComboBoxPanel;
    private JPanel myAfterBreakpointHitPanel;
    private JRadioButton myLeaveEnabledRadioButton;
    private JPanel myContentPane;
    private JPanel myMainPanel;
    private BreakpointChooser myMasterBreakpointChooser;
    private XDependentBreakpointManagerProxy myDependentBreakpointManager;

    public XMasterBreakpointPanel() {
        this.$$$setupUI$$$();
    }

    private static List<BreakpointItem> getBreakpointItemsExceptMy(XBreakpointManagerProxy breakpointManager, XBreakpointProxy breakpoint2) {
        List items = breakpointManager.getAllBreakpointItems();
        for (BreakpointItem item : items) {
            if (!Objects.equals(item.getBreakpoint(), breakpoint2)) continue;
            items.remove(item);
            break;
        }
        Collections.sort(items);
        items.add(0, new BreakpointNoneItem());
        return items;
    }

    @Override
    public void init(Project project, @NotNull XBreakpointProxy breakpoint2) {
        if (breakpoint2 == null) {
            XMasterBreakpointPanel.$$$reportNull$$$0(0);
        }
        super.init(project, breakpoint2);
        XBreakpointManagerProxy breakpointManager = XDebugManagerProxy.getInstance().getBreakpointManagerProxy(project);
        this.myDependentBreakpointManager = breakpointManager.getDependentBreakpointManager();
        this.myMasterBreakpointChooser = new BreakpointChooser(project, new BreakpointChooser.Delegate(){

            @Override
            public void breakpointChosen(Project project, BreakpointItem breakpointItem) {
                XMasterBreakpointPanel.this.updateAfterBreakpointHitPanel();
            }
        }, null, XMasterBreakpointPanel.getBreakpointItemsExceptMy(breakpointManager, breakpoint2));
        this.myMasterBreakpointComboBoxPanel.add((Component)this.myMasterBreakpointChooser.getComponent(), "Center");
    }

    @Override
    public boolean lightVariant(boolean showAllOptions) {
        XBreakpointProxy masterBreakpoint = this.myDependentBreakpointManager.getMasterBreakpoint(this.myBreakpoint);
        if (!showAllOptions && masterBreakpoint == null) {
            this.myMainPanel.setVisible(false);
            return true;
        }
        return false;
    }

    private void updateAfterBreakpointHitPanel() {
        boolean enable = this.myMasterBreakpointChooser.getSelectedBreakpoint() != null;
        GuiUtils.enableChildren((boolean)enable, (Component[])new Component[]{this.myAfterBreakpointHitPanel});
    }

    @Override
    void loadProperties() {
        XBreakpointProxy masterBreakpoint = this.myDependentBreakpointManager.getMasterBreakpoint(this.myBreakpoint);
        if (masterBreakpoint != null) {
            this.myMasterBreakpointChooser.setSelectedBreakpoint(masterBreakpoint);
            this.myLeaveEnabledRadioButton.setSelected(this.myDependentBreakpointManager.isLeaveEnabled(this.myBreakpoint));
        }
        this.updateAfterBreakpointHitPanel();
    }

    @Override
    void saveProperties() {
        XBreakpointProxy masterBreakpoint = this.myMasterBreakpointChooser.getSelectedBreakpoint();
        if (masterBreakpoint == null) {
            this.myDependentBreakpointManager.clearMasterBreakpoint(this.myBreakpoint);
        } else {
            this.myDependentBreakpointManager.setMasterBreakpoint(this.myBreakpoint, masterBreakpoint, this.myLeaveEnabledRadioButton.isSelected());
        }
    }

    public void setDetailView(DetailView detailView) {
        if (this.myMasterBreakpointChooser != null) {
            this.myMasterBreakpointChooser.setDetailView(detailView);
        }
    }

    public void hide() {
        this.myContentPane.getParent().remove(this.myContentPane);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/ui/XMasterBreakpointPanel", "init"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myContentPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "");
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myMasterBreakpointComboBoxPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setToolTipText(DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XMasterBreakpointPanel.class).getString("xbreakpoint.master.breakpoint.description"));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null, 1));
        this.myAfterBreakpointHitPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null, 1));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XMasterBreakpointPanel.class).getString("xbreakpoint.label.after.breakpoint.was.hit"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JRadioButton jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XMasterBreakpointPanel.class).getString("xbreakpoint.radio.disable.again"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLeaveEnabledRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XMasterBreakpointPanel.class).getString("xbreakpoint.radio.leave.enabled"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        ((Component)jLabel2).setEnabled(true);
        Font font = UIManager.getFont("Label.font");
        if (font != null) {
            jLabel2.setFont(font);
        }
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XMasterBreakpointPanel.class).getString("xbreakpoint.master.breakpoint.description"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

