/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.codeinsight;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.codeinsight.ControlExceptionBreakpointSupport;
import com.intellij.xdebugger.impl.codeinsight.ControlExceptionBreakpointIntentionActionKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\bH\u0016J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J!\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001aH\u0096\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/xdebugger/impl/codeinsight/ControlExceptionBreakpointIntentionAction;", "Lcom/intellij/codeInsight/intention/BaseElementAtCaretIntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "<init>", "()V", "foundExceptionReference", "Lcom/intellij/xdebugger/codeinsight/ControlExceptionBreakpointSupport$ExceptionReference;", "shouldEnable", "", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getIcon", "Ljavax/swing/Icon;", "flags", "", "checkFile", "file", "Lcom/intellij/psi/PsiFile;", "startInWriteAction", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiElement", "Lcom/intellij/psi/PsiElement;", "invoke", "", "element", "intellij.platform.debugger.impl"})
public final class ControlExceptionBreakpointIntentionAction
extends BaseElementAtCaretIntentionAction
implements Iconable {
    @Nullable
    private ControlExceptionBreakpointSupport.ExceptionReference foundExceptionReference;
    private boolean shouldEnable;

    @NotNull
    public String getFamilyName() {
        String string = XDebuggerBundle.message((String)"xdebugger.intention.control.exception.breakpoint.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Db_exception_breakpoint");
        return icon;
    }

    protected boolean checkFile(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        for (ControlExceptionBreakpointSupport support : ControlExceptionBreakpointIntentionActionKt.access$getSupportsExtensionPoint$p().getExtensionList()) {
            ControlExceptionBreakpointSupport.ExceptionReference exceptionReference = support.findExceptionReference(project, psiElement);
            if (exceptionReference == null) continue;
            ControlExceptionBreakpointSupport.ExceptionReference exRef = exceptionReference;
            String displayName = exRef.getDisplayName();
            XBreakpoint breakpoint2 = exRef.findExistingBreakpoint(project);
            if (breakpoint2 == null) {
                Object[] objectArray = new Object[]{displayName};
                this.setText(XDebuggerBundle.message((String)"xdebugger.intention.control.exception.breakpoint.create.text", (Object[])objectArray));
                this.shouldEnable = true;
            } else if (breakpoint2.isEnabled()) {
                Object[] objectArray = new Object[]{displayName};
                this.setText(XDebuggerBundle.message((String)"xdebugger.intention.control.exception.breakpoint.disable.text", (Object[])objectArray));
                this.shouldEnable = false;
            } else {
                Object[] objectArray = new Object[]{displayName};
                this.setText(XDebuggerBundle.message((String)"xdebugger.intention.control.exception.breakpoint.enable.text", (Object[])objectArray));
                this.shouldEnable = true;
            }
            this.foundExceptionReference = exRef;
            return true;
        }
        this.foundExceptionReference = null;
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ControlExceptionBreakpointSupport.ExceptionReference exceptionReference = this.foundExceptionReference;
        if (exceptionReference == null) {
            return;
        }
        ControlExceptionBreakpointSupport.ExceptionReference exRef = exceptionReference;
        XBreakpoint breakpoint2 = exRef.findExistingBreakpoint(project);
        if (breakpoint2 == null) {
            if (this.shouldEnable) {
                exRef.createBreakpoint(project);
            }
        } else {
            breakpoint2.setEnabled(this.shouldEnable);
        }
    }
}

