/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.mixedmode;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.mixedmode.XMixedModeUtilsKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J'\u0010\u001f\u001a\u000f\u0012\u0006\u0012\u0004\u0018\u00010!0 \u00a2\u0006\u0002\b\"2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J*\u0010#\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00102\b\u0010%\u001a\u0004\u0018\u00010!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0001H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006+"}, d2={"Lcom/intellij/xdebugger/impl/mixedmode/XMixedModeDebuggersEditorProvider;", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "lowDebuggerEditorsProvider", "highDebuggerEditorsProvider", "<init>", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;)V", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "getLowDebuggerEditorsProvider", "()Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "getHighDebuggerEditorsProvider", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "createDocument", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "mode", "Lcom/intellij/xdebugger/evaluation/EvaluationMode;", "expression", "Lcom/intellij/xdebugger/XExpression;", "afterEditorCreated", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getSupportedLanguages", "", "Lcom/intellij/lang/Language;", "Lorg/jetbrains/annotations/Unmodifiable;", "createExpression", "document", "language", "getInlineDebuggerHelper", "Lcom/intellij/xdebugger/evaluation/InlineDebuggerHelper;", "isEvaluateExpressionFieldEnabled", "", "getActiveProvider", "intellij.platform.debugger.impl"})
public final class XMixedModeDebuggersEditorProvider
extends XDebuggerEditorsProvider {
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final XDebuggerEditorsProvider lowDebuggerEditorsProvider;
    @NotNull
    private final XDebuggerEditorsProvider highDebuggerEditorsProvider;

    public XMixedModeDebuggersEditorProvider(@NotNull XDebugSession session, @NotNull XDebuggerEditorsProvider lowDebuggerEditorsProvider, @NotNull XDebuggerEditorsProvider highDebuggerEditorsProvider) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lowDebuggerEditorsProvider, (String)"lowDebuggerEditorsProvider");
        Intrinsics.checkNotNullParameter((Object)highDebuggerEditorsProvider, (String)"highDebuggerEditorsProvider");
        this.session = session;
        this.lowDebuggerEditorsProvider = lowDebuggerEditorsProvider;
        this.highDebuggerEditorsProvider = highDebuggerEditorsProvider;
        boolean bl = this.session.isMixedMode();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    @NotNull
    public final XDebuggerEditorsProvider getLowDebuggerEditorsProvider() {
        return this.lowDebuggerEditorsProvider;
    }

    @NotNull
    public final XDebuggerEditorsProvider getHighDebuggerEditorsProvider() {
        return this.highDebuggerEditorsProvider;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.getActiveProvider().getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        return fileType;
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull String text, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Document document = this.getActiveProvider().createDocument(project, text, sourcePosition, mode);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        return document;
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Document document = this.getActiveProvider().createDocument(project, expression, sourcePosition, mode);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        return document;
    }

    public void afterEditorCreated(@Nullable Editor editor) {
        this.getActiveProvider().afterEditorCreated(editor);
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@NotNull Project project, @Nullable XSourcePosition sourcePosition) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Collection collection = this.getActiveProvider().getSupportedLanguages(project, sourcePosition);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSupportedLanguages(...)");
        return collection;
    }

    @NotNull
    public XExpression createExpression(@NotNull Project project, @NotNull Document document, @Nullable Language language, @NotNull EvaluationMode mode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        XExpression xExpression = this.getActiveProvider().createExpression(project, document, language, mode);
        Intrinsics.checkNotNullExpressionValue((Object)xExpression, (String)"createExpression(...)");
        return xExpression;
    }

    @NotNull
    public InlineDebuggerHelper getInlineDebuggerHelper() {
        InlineDebuggerHelper inlineDebuggerHelper = this.getActiveProvider().getInlineDebuggerHelper();
        Intrinsics.checkNotNullExpressionValue((Object)inlineDebuggerHelper, (String)"getInlineDebuggerHelper(...)");
        return inlineDebuggerHelper;
    }

    public boolean isEvaluateExpressionFieldEnabled() {
        return this.getActiveProvider().isEvaluateExpressionFieldEnabled();
    }

    private final XDebuggerEditorsProvider getActiveProvider() {
        XStackFrame xStackFrame = this.session.getCurrentStackFrame();
        if (xStackFrame == null || (xStackFrame = xStackFrame.getSourcePosition()) == null || (xStackFrame = xStackFrame.getFile()) == null) {
            return this.highDebuggerEditorsProvider;
        }
        XStackFrame file2 = xStackFrame;
        return XMixedModeUtilsKt.getLowLevelMixedModeExtensionOrThrow(XMixedModeUtilsKt.getMixedModeDebugProcessOrThrow(this.session)).belongsToMe((VirtualFile)file2) ? this.lowDebuggerEditorsProvider : this.highDebuggerEditorsProvider;
    }
}

