/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMouseHoverPopupControl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionPointHighlighter {
    private final Project myProject;
    private RangeHighlighter myRangeHighlighter;
    private Editor myEditor;
    private XSourcePosition mySourcePosition;
    private OpenFileDescriptor myOpenFileDescriptor;
    private boolean myNotTopFrame;
    private GutterIconRenderer myGutterIconRenderer;
    public static final Key<Boolean> EXECUTION_POINT_HIGHLIGHTER_TOP_FRAME_KEY = Key.create((String)"EXECUTION_POINT_HIGHLIGHTER_TOP_FRAME_KEY");
    private final AtomicBoolean updateRequested;

    public ExecutionPointHighlighter(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            ExecutionPointHighlighter.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ExecutionPointHighlighter.$$$reportNull$$$0(1);
        }
        this(project, project.getMessageBus().connect(parentDisposable));
    }

    public ExecutionPointHighlighter(@NotNull Project project, @NotNull MessageBusConnection messageBusConnection) {
        if (project == null) {
            ExecutionPointHighlighter.$$$reportNull$$$0(2);
        }
        if (messageBusConnection == null) {
            ExecutionPointHighlighter.$$$reportNull$$$0(3);
        }
        this.updateRequested = new AtomicBoolean();
        this.myProject = project;
        messageBusConnection.subscribe(EditorColorsManager.TOPIC, scheme -> this.update(false));
    }

    public void show(@NotNull XSourcePosition position, boolean notTopFrame, @Nullable GutterIconRenderer gutterIconRenderer) {
        if (position == null) {
            ExecutionPointHighlighter.$$$reportNull$$$0(4);
        }
        this.show(position, notTopFrame, gutterIconRenderer, true);
    }

    public void show(@NotNull XSourcePosition position, boolean notTopFrame, @Nullable GutterIconRenderer gutterIconRenderer, boolean navigate) {
        if (position == null) {
            ExecutionPointHighlighter.$$$reportNull$$$0(5);
        }
        this.updateRequested.set(false);
        ((AppUIExecutor)AppUIExecutor.onWriteThread((ModalityState)ModalityState.nonModal()).expireWith((Disposable)this.myProject)).submit(() -> {
            this.updateRequested.set(false);
            this.mySourcePosition = position;
            this.clearDescriptor();
            this.myOpenFileDescriptor = ExecutionPointHighlighter.createOpenFileDescriptor(this.myProject, position);
            this.myOpenFileDescriptor.setUsePreviewTab(true);
            if (!XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isScrollToCenter()) {
                this.myOpenFileDescriptor.setScrollType(notTopFrame ? ScrollType.CENTER : ScrollType.MAKE_VISIBLE);
            }
            this.myGutterIconRenderer = gutterIconRenderer;
            this.myNotTopFrame = notTopFrame;
        }).thenAsync(ignored -> ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.myProject)).submit(() -> this.doShow(navigate)));
    }

    public void hide() {
        AppUIUtil.invokeOnEdt(() -> {
            this.updateRequested.set(false);
            this.removeHighlighter();
            this.clearDescriptor();
            this.myEditor = null;
            this.myGutterIconRenderer = null;
        });
    }

    private void clearDescriptor() {
        if (this.myOpenFileDescriptor != null) {
            this.myOpenFileDescriptor.dispose();
            this.myOpenFileDescriptor = null;
        }
    }

    public void navigateTo() {
        if (this.myOpenFileDescriptor != null && this.myOpenFileDescriptor.getFile().isValid()) {
            this.myOpenFileDescriptor.navigateInEditor(this.myProject, true);
        }
    }

    @Nullable
    public VirtualFile getCurrentFile() {
        return this.myOpenFileDescriptor != null ? this.myOpenFileDescriptor.getFile() : null;
    }

    public void update(boolean navigate) {
        if (this.updateRequested.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.updateRequested.compareAndSet(true, false)) {
                    this.doShow(navigate);
                }
            }, this.myProject.getDisposed());
        }
    }

    public void updateGutterIcon(@Nullable GutterIconRenderer renderer) {
        AppUIUtil.invokeOnEdt(() -> {
            if (this.myRangeHighlighter != null && this.myGutterIconRenderer != null) {
                this.myRangeHighlighter.setGutterIconRenderer(renderer);
            }
        });
    }

    private void doShow(boolean navigate) {
        ThreadingAssertions.assertEventDispatchThread();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.removeHighlighter();
        this.myEditor = null;
        if (this.myOpenFileDescriptor != null) {
            if (!navigate) {
                FileEditor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(this.myOpenFileDescriptor.getFile());
                if (editor instanceof TextEditor) {
                    TextEditor te = (TextEditor)editor;
                    this.myEditor = te.getEditor();
                }
            } else {
                this.myEditor = XDebuggerUtil.getInstance().openTextEditor(this.myOpenFileDescriptor);
            }
        }
        if (this.myEditor != null) {
            this.addHighlighter();
        }
    }

    private void removeHighlighter() {
        if (this.myEditor != null) {
            ExecutionPointHighlighter.disableMouseHoverPopups(this.myEditor, false);
        }
        if (this.myRangeHighlighter != null) {
            this.myRangeHighlighter.dispose();
            this.myRangeHighlighter = null;
        }
    }

    private void addHighlighter() {
        HighlighterProvider highlighterProvider;
        TextRange range;
        ExecutionPointHighlighter.disableMouseHoverPopups(this.myEditor, true);
        int line = this.mySourcePosition.getLine();
        Document document = this.myEditor.getDocument();
        if (line < 0 || line >= document.getLineCount()) {
            return;
        }
        if (this.myRangeHighlighter != null) {
            return;
        }
        TextAttributesKey attributesKey = this.myNotTopFrame ? DebuggerColors.NOT_TOP_FRAME_ATTRIBUTES : DebuggerColors.EXECUTIONPOINT_ATTRIBUTES;
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document, (Project)this.myProject, (boolean)true);
        XSourcePosition xSourcePosition = this.mySourcePosition;
        if (xSourcePosition instanceof HighlighterProvider && (range = (highlighterProvider = (HighlighterProvider)xSourcePosition).getHighlightRange()) != null) {
            this.myRangeHighlighter = markupModel.addRangeHighlighter(attributesKey, range.getStartOffset(), range.getEndOffset(), 5998, HighlighterTargetArea.EXACT_RANGE);
        }
        if (this.myRangeHighlighter == null) {
            this.myRangeHighlighter = markupModel.addLineHighlighter(attributesKey, line, 5998);
        }
        this.myRangeHighlighter.putUserData(EXECUTION_POINT_HIGHLIGHTER_TOP_FRAME_KEY, (Object)(!this.myNotTopFrame ? 1 : 0));
        this.myRangeHighlighter.setEditorFilter(editor -> editor.getEditorKind() == EditorKind.MAIN_EDITOR);
        this.myRangeHighlighter.setGutterIconRenderer(this.myGutterIconRenderer);
    }

    public boolean isFullLineHighlighter() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.myRangeHighlighter != null && this.myRangeHighlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE;
    }

    private static void disableMouseHoverPopups(@NotNull Editor editor, boolean disable) {
        if (editor == null) {
            ExecutionPointHighlighter.$$$reportNull$$$0(6);
        }
        Project project = editor.getProject();
        if (ApplicationManager.getApplication().isUnitTestMode() || project == null) {
            return;
        }
        if (Registry.is((String)"debugger.valueTooltipAutoShow")) {
            SwingUtilities.invokeLater(() -> {
                if (disable) {
                    EditorMouseHoverPopupControl.disablePopups((Project)project);
                } else {
                    EditorMouseHoverPopupControl.enablePopups((Project)project);
                }
            });
        }
    }

    @NotNull
    private static OpenFileDescriptor createOpenFileDescriptor(@NotNull Project project, @NotNull XSourcePosition position) {
        Navigatable navigatable;
        if (project == null) {
            ExecutionPointHighlighter.$$$reportNull$$$0(7);
        }
        if (position == null) {
            ExecutionPointHighlighter.$$$reportNull$$$0(8);
        }
        if ((navigatable = position.createNavigatable(project)) instanceof OpenFileDescriptor) {
            OpenFileDescriptor openFileDescriptor = (OpenFileDescriptor)navigatable;
            if (openFileDescriptor == null) {
                ExecutionPointHighlighter.$$$reportNull$$$0(9);
            }
            return openFileDescriptor;
        }
        OpenFileDescriptor openFileDescriptor = XDebuggerUtilImpl.createOpenFileDescriptor(project, position);
        if (openFileDescriptor == null) {
            ExecutionPointHighlighter.$$$reportNull$$$0(10);
        }
        return openFileDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBusConnection";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpenFileDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "disableMouseHoverPopups";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createOpenFileDescriptor";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }

    public static interface HighlighterProvider {
        @Nullable
        public TextRange getHighlightRange();
    }
}

