/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.xdebugger.impl.ui.InplaceEditor;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public abstract class TreeInplaceEditor
extends InplaceEditor {
    protected abstract TreePath getNodePath();

    protected abstract JTree getTree();

    @Override
    protected JComponent getHostComponent() {
        return this.getTree();
    }

    @Override
    protected void beforeShow() {
        this.getTree().scrollPathToVisible(this.getNodePath());
    }

    @Override
    @Nullable
    protected Rectangle getEditorBounds() {
        JTree tree = this.getTree();
        Rectangle bounds = tree.getVisibleRect();
        Rectangle nodeBounds = tree.getPathBounds(this.getNodePath());
        if (bounds == null || nodeBounds == null) {
            return null;
        }
        if (bounds.y > nodeBounds.y || bounds.y + bounds.height < nodeBounds.y + nodeBounds.height) {
            return null;
        }
        bounds.y = nodeBounds.y;
        bounds.height = nodeBounds.height;
        if (nodeBounds.x > bounds.x) {
            bounds.width = bounds.width - nodeBounds.x + bounds.x;
            bounds.x = nodeBounds.x;
        }
        return bounds;
    }
}

