/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model.action.generate;

import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.ide.actions.newclass.CreateWithTemplatesDialogPanel;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.model.action.generate.NonBlockingPopupBuilderImpl;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J,\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\rH\u0016J\u0012\u0010!\u001a\u00020\u00012\b\u0010\"\u001a\u0004\u0018\u00010\u0011H\u0016J9\u0010#\u001a\u0004\u0018\u0001H$\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010&\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u00072\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H$0)H\u0016\u00a2\u0006\u0002\u0010*JD\u0010#\u001a\u00020+\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010&\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u00072\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H$0)2\u0010\u0010-\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u0001H$0.H\u0016J\u0016\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u000100H\u0016J*\u00101\u001a\u00020+2 \u00102\u001a\u001c\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\u0006\b\u0000\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u0013H\u0016J\u001a\u00103\u001a\u0004\u0018\u00010%2\u0006\u00104\u001a\u00020\u00072\u0006\u0010(\u001a\u000205H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0012\u001a\u001c\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\u0006\b\u0000\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/spring/mvc/model/action/generate/NonBlockingPopupBuilderImpl;", "Lcom/intellij/ide/actions/CreateFileFromTemplateDialog$Builder;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myTitle", "", "myDefaultText", "myTemplatesList", "", "Lcom/intellij/ide/actions/newclass/CreateWithTemplatesDialogPanel$TemplatePresentation;", "myInputValidator", "Lcom/intellij/openapi/ui/InputValidator;", "myExtraValidators", "", "dialogOwner", "Ljava/awt/Component;", "myKindSelector", "Ljava/util/function/BiFunction;", "", "setTitle", "title", "setDefaultText", "text", "addKind", "kind", "icon", "Ljavax/swing/Icon;", "templateName", "extraValidator", "setValidator", "validator", "setDialogOwner", "owner", "show", "T", "Lcom/intellij/psi/PsiElement;", "errorTitle", "selectedItem", "creator", "Lcom/intellij/ide/actions/CreateFileFromTemplateDialog$FileCreator;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ide/actions/CreateFileFromTemplateDialog$FileCreator;)Lcom/intellij/psi/PsiElement;", "", "fileCreator", "elementConsumer", "Lcom/intellij/util/Consumer;", "getCustomProperties", "", "setKindSelector", "templateMatcher", "createElement", "newElementName", "Lcom/intellij/ide/actions/ElementCreator;", "intellij.spring.mvc.impl"})
final class NonBlockingPopupBuilderImpl
implements CreateFileFromTemplateDialog.Builder {
    @NotNull
    private final Project myProject;
    @NlsSafe
    @NotNull
    private String myTitle;
    @Nullable
    private String myDefaultText;
    @NotNull
    private final List<CreateWithTemplatesDialogPanel.TemplatePresentation> myTemplatesList;
    @Nullable
    private InputValidator myInputValidator;
    @NotNull
    private final Map<String, InputValidator> myExtraValidators;
    @Nullable
    private Component dialogOwner;
    @Nullable
    private BiFunction<? super String, ? super CreateWithTemplatesDialogPanel.TemplatePresentation, Boolean> myKindSelector;

    public NonBlockingPopupBuilderImpl(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        String string = LangBundle.message((String)"popup.title.default.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.myTitle = string;
        this.myTemplatesList = new ArrayList();
        this.myExtraValidators = new LinkedHashMap();
    }

    @NotNull
    public CreateFileFromTemplateDialog.Builder setTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.myTitle = title;
        return this;
    }

    @NotNull
    public CreateFileFromTemplateDialog.Builder setDefaultText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.myDefaultText = text;
        return this;
    }

    @NotNull
    public CreateFileFromTemplateDialog.Builder addKind(@NotNull String kind, @Nullable Icon icon, @NotNull String templateName, @Nullable InputValidator extraValidator) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        this.myTemplatesList.add(new CreateWithTemplatesDialogPanel.TemplatePresentation(kind, icon, templateName));
        if (extraValidator != null) {
            this.myExtraValidators.put(templateName, extraValidator);
        }
        return this;
    }

    @NotNull
    public CreateFileFromTemplateDialog.Builder setValidator(@NotNull InputValidator validator) {
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        this.myInputValidator = validator;
        return this;
    }

    @NotNull
    public CreateFileFromTemplateDialog.Builder setDialogOwner(@Nullable Component owner) {
        this.dialogOwner = owner;
        return this;
    }

    @Nullable
    public <T extends PsiElement> T show(@NotNull String errorTitle, @Nullable String selectedItem, @NotNull CreateFileFromTemplateDialog.FileCreator<T> creator) {
        Intrinsics.checkNotNullParameter((Object)errorTitle, (String)"errorTitle");
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        throw new UnsupportedOperationException("Modal dialog is not supported by this builder");
    }

    public <T extends PsiElement> void show(@NotNull String errorTitle, @Nullable String selectedItem, @NotNull CreateFileFromTemplateDialog.FileCreator<T> fileCreator, @NotNull Consumer<? super T> elementConsumer) {
        Intrinsics.checkNotNullParameter((Object)errorTitle, (String)"errorTitle");
        Intrinsics.checkNotNullParameter(fileCreator, (String)"fileCreator");
        Intrinsics.checkNotNullParameter(elementConsumer, (String)"elementConsumer");
        CreateWithTemplatesDialogPanel contentPanel = new CreateWithTemplatesDialogPanel(selectedItem, this.myTemplatesList);
        JTextField jTextField = contentPanel.getNameField();
        Intrinsics.checkNotNull((Object)jTextField, (String)"null cannot be cast to non-null type com.intellij.ui.components.fields.ExtendableTextField");
        ExtendableTextField nameField = (ExtendableTextField)jTextField;
        nameField.getEmptyText().setText(SpringMvcBundle.message("action.Spring.Create.Endpoint.text.empty", new Object[0]));
        if (this.myKindSelector != null) {
            BiFunction<? super String, ? super CreateWithTemplatesDialogPanel.TemplatePresentation, Boolean> biFunction = this.myKindSelector;
            Intrinsics.checkNotNull(biFunction);
            contentPanel.setTemplateSelectorMatcher(biFunction);
        }
        Project project = this.myProject;
        ElementCreator elementCreator2 = new ElementCreator(errorTitle, fileCreator, contentPanel, project){
            final /* synthetic */ CreateFileFromTemplateDialog.FileCreator<T> $fileCreator;
            final /* synthetic */ CreateWithTemplatesDialogPanel $contentPanel;
            {
                this.$fileCreator = $fileCreator;
                this.$contentPanel = $contentPanel;
                super($super_call_param$1, $errorTitle);
            }

            protected PsiElement[] create(String newName) {
                PsiElement[] psiElementArray;
                Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
                PsiElement element = (PsiElement)this.$fileCreator.createFile(this.$contentPanel.getEnteredName(), this.$contentPanel.getSelectedTemplate());
                if (element != null) {
                    PsiElement[] psiElementArray2 = new PsiElement[]{element};
                    psiElementArray = psiElementArray2;
                } else {
                    psiElementArray = PsiElement.EMPTY_ARRAY;
                    Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                }
                return psiElementArray;
            }

            public boolean startInWriteAction() {
                return this.$fileCreator.startInWriteAction();
            }

            protected String getActionName(String newName) {
                Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
                String string = this.$fileCreator.getActionName(newName, this.$contentPanel.getSelectedTemplate());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getActionName(...)");
                return string;
            }
        };
        JBPopup popup = NewItemPopupUtil.createNewItemPopup((String)this.myTitle, (JComponent)((JComponent)contentPanel), (JComponent)contentPanel.getNameField());
        if (this.myDefaultText != null) {
            JTextField textField = contentPanel.getTextField();
            textField.setText(this.myDefaultText);
            textField.selectAll();
        }
        contentPanel.setApplyAction(arg_0 -> NonBlockingPopupBuilderImpl.show$lambda$1(arg_0 -> NonBlockingPopupBuilderImpl.show$lambda$0(contentPanel, this, popup, elementCreator2, elementConsumer, arg_0), arg_0));
        Disposer.register((Disposable)((Disposable)popup), (Disposable)((Disposable)contentPanel));
        if (this.dialogOwner == null) {
            popup.showCenteredInCurrentWindow(this.myProject);
        } else {
            Component component = this.dialogOwner;
            Intrinsics.checkNotNull((Object)component);
            popup.showInCenterOf(component);
        }
    }

    @Nullable
    public Map<String, String> getCustomProperties() {
        return null;
    }

    public void setKindSelector(@Nullable BiFunction<? super String, ? super CreateWithTemplatesDialogPanel.TemplatePresentation, Boolean> templateMatcher) {
        this.myKindSelector = templateMatcher;
    }

    private final PsiElement createElement(String newElementName, ElementCreator creator) {
        PsiElement[] psiElementArray = creator.tryCreate(newElementName);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"tryCreate(...)");
        return (PsiElement)ArraysKt.firstOrNull((Object[])psiElementArray);
    }

    private static final Unit show$lambda$0(CreateWithTemplatesDialogPanel $contentPanel, NonBlockingPopupBuilderImpl this$0, JBPopup $popup, show.elementCreator.1 $elementCreator, Consumer $elementConsumer, InputEvent e) {
        boolean isExtraValid;
        InputValidator extraValidator;
        String string = $contentPanel.getEnteredName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEnteredName(...)");
        String newElementName = string;
        if (StringsKt.isBlank((CharSequence)newElementName)) {
            return Unit.INSTANCE;
        }
        InputValidator inputValidator = this$0.myInputValidator;
        boolean isValid = inputValidator != null ? inputValidator.canClose(newElementName) : true;
        InputValidator inputValidator2 = extraValidator = this$0.myExtraValidators.get($contentPanel.getSelectedTemplate());
        boolean bl = isExtraValid = inputValidator2 != null ? inputValidator2.canClose(newElementName) : true;
        if (isValid && isExtraValid) {
            $popup.closeOk(e);
            PsiElement createdElement = this$0.createElement(newElementName, $elementCreator);
            if (createdElement != null) {
                $elementConsumer.consume((Object)createdElement);
            }
        } else {
            String string2;
            InputValidatorEx inputValidatorEx;
            Object object = !isValid ? this$0.myInputValidator : extraValidator;
            InputValidatorEx inputValidatorEx2 = inputValidatorEx = object instanceof InputValidatorEx ? (InputValidatorEx)object : null;
            if (inputValidatorEx != null && (object = inputValidatorEx.getErrorText(newElementName)) != null) {
                string2 = object;
            } else {
                String string3 = LangBundle.message((String)"incorrect.name", (Object[])new Object[0]);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            }
            String errorMessage = string2;
            $contentPanel.setError(errorMessage);
        }
        return Unit.INSTANCE;
    }

    private static final void show$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

