/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.template;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.actions.generate.SpringComponentGenerator;
import com.intellij.spring.mvc.template.ControllerTemplateSettings;
import com.intellij.spring.templates.TemplateHandler;
import com.intellij.spring.templates.TemplateHandlerContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\b0\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spring/mvc/template/SpringWebTemplateHandler;", "Lcom/intellij/spring/templates/TemplateHandler;", "isRestTemplate", "", "<init>", "(Z)V", "()Z", "handle", "", "context", "Lcom/intellij/spring/templates/TemplateHandlerContext;", "handleResult", "Lkotlin/Function1;", "Lorg/jetbrains/uast/UClass;", "intellij.spring.mvc.impl"})
public final class SpringWebTemplateHandler
implements TemplateHandler {
    private final boolean isRestTemplate;

    public SpringWebTemplateHandler(boolean isRestTemplate) {
        this.isRestTemplate = isRestTemplate;
    }

    public final boolean isRestTemplate() {
        return this.isRestTemplate;
    }

    public void handle(@NotNull TemplateHandlerContext context, @NotNull Function1<? super UClass, Unit> handleResult) {
        UElement result;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(handleResult, (String)"handleResult");
        PsiDirectory dir = context.getDir();
        Project project = dir.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ControllerTemplateSettings.Companion.getInstance(project).setDefaultRestController(this.isRestTemplate);
        String templateName = context.getTemplateName();
        String className = context.getClassName();
        Project project2 = dir.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        SpringComponentGenerator generator = new SpringComponentGenerator(project2, templateName);
        UElement uElement = result = UastContextKt.toUElement((PsiElement)SpringComponentGenerator.generate$default((SpringComponentGenerator)generator, (String)className, (PsiDirectory)dir, null, (int)4, null));
        UClass createdClass = uElement instanceof UFile ? (UClass)CollectionsKt.firstOrNull((List)((UFile)result).getClasses()) : (uElement instanceof UClass ? (UClass)result : null);
        handleResult.invoke((Object)createdClass);
    }
}

