/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.quic;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.split.connection.network.quic.Quiche;
import com.intellij.platform.split.connection.network.quic.QuicheCommon;
import com.intellij.platform.split.connection.network.quic.QuicheConnection;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\b\u001a\u00020\tH\u0096\u0080\u0004J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\r\u001a\u00020\u000eH\u0096\u0080\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0015J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bJ\u001f\u0010\u001d\u001a\u00020\u00102\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u001f\"\u00020\t\u00a2\u0006\u0002\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicheConfig;", "", "<init>", "()V", "pointer", "Lcom/sun/jna/ptr/PointerByReference;", "getPointer", "()Lcom/sun/jna/ptr/PointerByReference;", "toString", "", "equals", "", "other", "hashCode", "", "setCommonSensibleOptions", "", "maxIdleTimeout", "Ljava/time/Duration;", "pathAsUTF8Ptr", "Lcom/sun/jna/Pointer;", "Ljava/io/File;", "loadCertChainFromPemFile", "file", "loadPrivateKeyFromPemFile", "loadPrivateKeyFromPemBytes", "bytes", "", "loadCertChainFromPemBytes", "setSupportedProtocols", "protocol", "", "([Ljava/lang/String;)V", "intellij.platform.split.connection"})
public final class QuicheConfig {
    @NotNull
    private final PointerByReference pointer;

    public QuicheConfig() {
        PointerByReference pointerByReference = Quiche.INSTANCE.getLibrary().quiche_config_new(1);
        Intrinsics.checkNotNull((Object)pointerByReference);
        this.pointer = pointerByReference;
    }

    @NotNull
    public final PointerByReference getPointer() {
        return this.pointer;
    }

    @NotNull
    public String toString() {
        return "CONFIG:" + this.pointer;
    }

    public boolean equals(@Nullable Object other) {
        QuicheConnection quicheConnection = (QuicheConnection)other;
        return Intrinsics.areEqual((Object)(quicheConnection != null ? quicheConnection.getPointer() : null), (Object)this.pointer);
    }

    public int hashCode() {
        return this.pointer.hashCode();
    }

    public final void setCommonSensibleOptions(@NotNull Duration maxIdleTimeout) {
        Intrinsics.checkNotNullParameter((Object)maxIdleTimeout, (String)"maxIdleTimeout");
        Quiche.INSTANCE.getLibrary().quiche_config_set_max_idle_timeout(this.pointer, maxIdleTimeout.toMillis());
        Quiche.INSTANCE.getLibrary().quiche_config_set_max_send_udp_payload_size(this.pointer, QuicheCommon.INSTANCE.toNativeSize(1200));
        Quiche.INSTANCE.getLibrary().quiche_config_set_initial_max_data(this.pointer, 10000000L);
        Quiche.INSTANCE.getLibrary().quiche_config_set_initial_max_stream_data_bidi_local(this.pointer, 1000000L);
        Quiche.INSTANCE.getLibrary().quiche_config_set_initial_max_stream_data_bidi_remote(this.pointer, 1000000L);
        Quiche.INSTANCE.getLibrary().quiche_config_set_initial_max_stream_data_uni(this.pointer, 1000000L);
        Quiche.INSTANCE.getLibrary().quiche_config_set_initial_max_streams_bidi(this.pointer, 100L);
        Quiche.INSTANCE.getLibrary().quiche_config_set_initial_max_streams_uni(this.pointer, 100L);
        Quiche.INSTANCE.getLibrary().quiche_config_set_disable_active_migration(this.pointer, QuicheCommon.INSTANCE.toByte(true));
    }

    public static /* synthetic */ void setCommonSensibleOptions$default(QuicheConfig quicheConfig, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration2 = Duration.ofSeconds(15L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        quicheConfig.setCommonSensibleOptions(duration);
    }

    private final Pointer pathAsUTF8Ptr(File $this$pathAsUTF8Ptr) {
        String string = $this$pathAsUTF8Ptr.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] utf8path = byArray;
        Memory pointer = new Memory((long)utf8path.length + 1L);
        pointer.write(0L, utf8path, 0, utf8path.length);
        pointer.setByte((long)utf8path.length, (byte)0);
        return (Pointer)pointer;
    }

    public final void loadCertChainFromPemFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        QuicheCommon.INSTANCE.assertQuicheError("quiche_config_load_cert_chain_from_pem_file", Quiche.INSTANCE.getLibrary().quiche_config_load_cert_chain_from_pem_file(this.pointer, this.pathAsUTF8Ptr(file)));
    }

    private final void loadPrivateKeyFromPemFile(File file) {
        QuicheCommon.INSTANCE.assertQuicheError("quiche_config_load_priv_key_from_pem_file", Quiche.INSTANCE.getLibrary().quiche_config_load_priv_key_from_pem_file(this.pointer, this.pathAsUTF8Ptr(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadPrivateKeyFromPemBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        File file = FileUtil.createTempFile((String)"quiche-private-key", (String)".pem");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File file2 = file;
        try {
            FilesKt.writeBytes((File)file2, (byte[])bytes);
            this.loadPrivateKeyFromPemFile(file2);
        }
        finally {
            file2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadCertChainFromPemBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        File file = FileUtil.createTempFile((String)"quiche-cert-chain", (String)".crt");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File file2 = file;
        try {
            FilesKt.writeBytes((File)file2, (byte[])bytes);
            this.loadCertChainFromPemFile(file2);
        }
        finally {
            file2.delete();
        }
    }

    public final void setSupportedProtocols(String ... protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        ByteArrayOutputStream memory = new ByteArrayOutputStream();
        for (String proto : protocol) {
            byte[] stringByteArray;
            String string;
            int n = proto.length();
            if (!(1 <= n ? n < 128 : false)) {
                string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            memory.write(proto.length());
            string = proto;
            Intrinsics.checkNotNullExpressionValue((Object)string.getBytes(Charsets.UTF_8), (String)"getBytes(...)");
            memory.write(stringByteArray, 0, stringByteArray.length);
        }
        byte[] arr = memory.toByteArray();
        Quiche.INSTANCE.getLibrary().quiche_config_set_application_protos(this.pointer, arr, QuicheCommon.INSTANCE.toNativeSize(arr.length));
    }
}

