/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.turn.channel;

import com.intellij.openapi.diagnostic.Logger;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/split/connection/network/turn/channel/TurnChannelPacketUtils;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "DATA_NUMBER_LENGTH", "", "DATA_LENGTH_LENGTH", "DATA_PREFIX_LENGTH", "formatPacket", "", "channelNumber", "", "data", "getChannelNumberFromPacket", "packetBytes", "getDataFromPacket", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nTurnChannelPacketUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TurnChannelPacketUtils.kt\ncom/intellij/platform/split/connection/network/turn/channel/TurnChannelPacketUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,66:1\n1#2:67\n13#3:68\n13#4:69\n*S KotlinDebug\n*F\n+ 1 TurnChannelPacketUtils.kt\ncom/intellij/platform/split/connection/network/turn/channel/TurnChannelPacketUtils\n*L\n9#1:68\n9#1:69\n*E\n"})
public final class TurnChannelPacketUtils {
    @NotNull
    public static final TurnChannelPacketUtils INSTANCE = new TurnChannelPacketUtils();
    @NotNull
    private static final Logger logger;
    private static final int DATA_NUMBER_LENGTH = 2;
    private static final int DATA_LENGTH_LENGTH = 2;
    private static final int DATA_PREFIX_LENGTH = 4;

    private TurnChannelPacketUtils() {
    }

    @NotNull
    public final byte[] formatPacket(char channelNumber, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        short packageLength = data.length;
        short maxLength = Short.MAX_VALUE;
        if (!(packageLength <= maxLength)) {
            boolean $i$a$-require-TurnChannelPacketUtils$formatPacket$22 = false;
            String $i$a$-require-TurnChannelPacketUtils$formatPacket$22 = "Package data size exceeded the max available length size of " + maxLength + " bytes";
            throw new IllegalArgumentException($i$a$-require-TurnChannelPacketUtils$formatPacket$22.toString());
        }
        int channelDataLength = 4 + packageLength;
        byte[] channelData = new byte[channelDataLength];
        ByteBuffer channelPrefixBuffer = ByteBuffer.wrap(channelData);
        channelPrefixBuffer.putChar(channelNumber);
        channelPrefixBuffer.putShort(packageLength);
        System.arraycopy(data, 0, channelData, 4, packageLength);
        return channelData;
    }

    public final char getChannelNumberFromPacket(@NotNull byte[] packetBytes) {
        Intrinsics.checkNotNullParameter((Object)packetBytes, (String)"packetBytes");
        ByteBuffer channelNumberBuffer = ByteBuffer.wrap(packetBytes);
        return channelNumberBuffer.getChar(0);
    }

    @NotNull
    public final byte[] getDataFromPacket(@NotNull byte[] packetBytes) {
        Intrinsics.checkNotNullParameter((Object)packetBytes, (String)"packetBytes");
        byte[] data = new byte[packetBytes.length - 4];
        System.arraycopy(packetBytes, 4, data, 0, data.length);
        return data;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TurnChannelPacketUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TurnChannelPacketUtils.logger = logger;
    }
}

