/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.turn.data;

import com.intellij.openapi.diagnostic.Logger;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\n\u0010\u0011\u001a\u00020\u0012H\u0096\u0080\u0004J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u000eH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/split/connection/network/turn/data/PermissionInfo;", "", "peerAddress", "Ljava/net/InetSocketAddress;", "<init>", "(Ljava/net/InetSocketAddress;)V", "getPeerAddress", "()Ljava/net/InetSocketAddress;", "expiration", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/time/Instant;", "updatePermissionLifetimeFromNow", "", "lifetimeSeconds", "", "isRefreshRequired", "", "toString", "", "component1", "copy", "equals", "other", "hashCode", "Companion", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nPermissionInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionInfo.kt\ncom/intellij/platform/split/connection/network/turn/data/PermissionInfo\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,58:1\n13#2:59\n13#3:60\n*S KotlinDebug\n*F\n+ 1 PermissionInfo.kt\ncom/intellij/platform/split/connection/network/turn/data/PermissionInfo\n*L\n17#1:59\n17#1:60\n*E\n"})
public final class PermissionInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InetSocketAddress peerAddress;
    @NotNull
    private final AtomicReference<Instant> expiration;
    @NotNull
    private static final Logger logger;
    private static final int defaultPermissionLifetimeSeconds = 300;
    private static final DateTimeFormatter dateFormatter;

    public PermissionInfo(@NotNull InetSocketAddress peerAddress) {
        Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
        this.peerAddress = peerAddress;
        this.expiration = new AtomicReference<Instant>(Instant.now());
        PermissionInfo.updatePermissionLifetimeFromNow$default(this, 0, 1, null);
    }

    @NotNull
    public final InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    private final void updatePermissionLifetimeFromNow(int lifetimeSeconds) {
        long lifetimeEpochSeconds = Instant.now().getEpochSecond() + (long)lifetimeSeconds;
        this.expiration.set(Instant.ofEpochSecond(lifetimeEpochSeconds));
        Instant permissionExpirationValue = this.expiration.get();
        logger.info("Updated permission lifetime to '" + dateFormatter.format(permissionExpirationValue) + "' (+" + lifetimeSeconds + " sec, epoch: " + permissionExpirationValue.getEpochSecond() + " sec)");
    }

    static /* synthetic */ void updatePermissionLifetimeFromNow$default(PermissionInfo permissionInfo, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 300;
        }
        permissionInfo.updatePermissionLifetimeFromNow(n);
    }

    public final boolean isRefreshRequired() {
        long nowEpochSeconds = Instant.now().getEpochSecond();
        return nowEpochSeconds >= this.expiration.get().getEpochSecond() - Duration.ofMinutes(1L).toSeconds();
    }

    @NotNull
    public String toString() {
        return "TURN permission (peer address: " + this.peerAddress + ")";
    }

    @NotNull
    public final InetSocketAddress component1() {
        return this.peerAddress;
    }

    @NotNull
    public final PermissionInfo copy(@NotNull InetSocketAddress peerAddress) {
        Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
        return new PermissionInfo(peerAddress);
    }

    public static /* synthetic */ PermissionInfo copy$default(PermissionInfo permissionInfo, InetSocketAddress inetSocketAddress, int n, Object object) {
        if ((n & 1) != 0) {
            inetSocketAddress = permissionInfo.peerAddress;
        }
        return permissionInfo.copy(inetSocketAddress);
    }

    public int hashCode() {
        return this.peerAddress.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PermissionInfo)) {
            return false;
        }
        PermissionInfo permissionInfo = (PermissionInfo)other;
        return Intrinsics.areEqual((Object)this.peerAddress, (Object)permissionInfo.peerAddress);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PermissionInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PermissionInfo.logger = logger;
        dateFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.systemDefault());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/split/connection/network/turn/data/PermissionInfo$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "defaultPermissionLifetimeSeconds", "", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

