/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.channel;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.protocol.channel.FramedByteChannel;
import com.intellij.platform.split.connection.protocol.channel.FramedByteChannelImpl;
import com.intellij.platform.split.connection.protocol.channel.frame.Frame;
import com.intellij.platform.split.connection.protocol.channel.frame.FrameFactory;
import com.intellij.platform.split.connection.protocol.channel.frame.PingFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.SystemFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.UnexpectedFrameException;
import com.intellij.platform.split.connection.protocol.transport.NamedTransportEntity;
import com.jetbrains.rd.platform.util.ByteChannelExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ClosedReceiveChannelException;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tlschannel.NeedsReadException;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 92\u00020\u00012\u00020\u0002:\u0003789B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J8\u0010 \u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00190\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e0\"H\u0016J$\u0010$\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001e0\"H\u0016J\b\u0010%\u001a\u00020\u001eH\u0016J\u000e\u0010&\u001a\u00020'H\u0096@\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u001eH\u0016J\n\u0010*\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u0010+\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0082@\u00a2\u0006\u0002\u0010,J\u0016\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u0010/J*\u00100\u001a\u00020\u001e\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H10\u00122\u0006\u00103\u001a\u0002H1H\u0082@\u00a2\u0006\u0002\u00104JN\u00105\u001a\u00020\u001e\"\u0004\b\u0000\u001012\u0006\u0010\u0003\u001a\u00020\u00042\f\u00106\u001a\b\u0012\u0004\u0012\u0002H10\u000f2\u0014\b\u0002\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H1\u0012\u0004\u0012\u00020\u00190\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H1\u0012\u0004\u0012\u00020\u001e0\"H\u0002J*\u0010%\u001a\u00020\u001e\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H10\u00122\f\u00106\u001a\b\u0012\u0004\u0012\u0002H10\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006:"}, d2={"Lcom/intellij/platform/split/connection/protocol/channel/FramedByteChannelImpl;", "Lcom/intellij/platform/split/connection/protocol/channel/FramedByteChannel;", "Lcom/intellij/platform/split/connection/protocol/transport/NamedTransportEntity;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "id", "", "underlyingChannel", "Ljava/nio/channels/ByteChannel;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;Ljava/nio/channels/ByteChannel;)V", "name", "getName", "()Ljava/lang/String;", "frameReceived", "Lcom/intellij/platform/split/connection/protocol/channel/FramedByteChannelImpl$NamedSharedFlow;", "Lcom/intellij/platform/split/connection/protocol/channel/frame/Frame;", "receivedFramesChannel", "Lcom/intellij/platform/split/connection/protocol/channel/FramedByteChannelImpl$NamedChannel;", "errorReceived", "", "receivedErrorsChannel", "myIsProcessingCollectedEntriesStarted", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isProcessingCollectedEntriesStarted", "", "()Z", "myIsReadFromByteChannelStarted", "isReadFromByteChannelStarted", "send", "", "frame", "onFrameReceived", "filter", "Lkotlin/Function1;", "handler", "onErrorReceived", "startProcessingCollectedEntries", "receiveSingleSystemFrame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/SystemFrame;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startReceivingFromByteChannel", "readNextFrameFromByteChannel", "addFrameToChannel", "(Lcom/intellij/platform/split/connection/protocol/channel/frame/Frame;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addErrorToChannel", "t", "(Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addToChannel", "T", "channel", "entry", "(Lcom/intellij/platform/split/connection/protocol/channel/FramedByteChannelImpl$NamedChannel;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "subscribeOnNewChannelEntry", "flow", "NamedChannel", "NamedSharedFlow", "Companion", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nFramedByteChannelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FramedByteChannelImpl.kt\ncom/intellij/platform/split/connection/protocol/channel/FramedByteChannelImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,399:1\n67#2,4:400\n67#2,4:405\n60#2,5:409\n67#2,4:414\n60#2,5:418\n67#2,4:423\n67#2,4:427\n60#2,5:431\n60#2,5:436\n60#2,5:441\n13#2:447\n1#3:404\n13#4:446\n*S KotlinDebug\n*F\n+ 1 FramedByteChannelImpl.kt\ncom/intellij/platform/split/connection/protocol/channel/FramedByteChannelImpl\n*L\n106#1:400,4\n124#1:405,4\n185#1:409,5\n190#1:414,4\n203#1:418,5\n349#1:423,4\n363#1:427,4\n369#1:431,5\n87#1:436,5\n91#1:441,5\n53#1:447\n53#1:446\n*E\n"})
public final class FramedByteChannelImpl
implements FramedByteChannel,
NamedTransportEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ByteChannel underlyingChannel;
    @NotNull
    private final String name;
    @NotNull
    private final NamedSharedFlow<Frame> frameReceived;
    @NotNull
    private final NamedChannel<Frame> receivedFramesChannel;
    @NotNull
    private final NamedSharedFlow<Throwable> errorReceived;
    @NotNull
    private final NamedChannel<Throwable> receivedErrorsChannel;
    @NotNull
    private final AtomicBoolean myIsProcessingCollectedEntriesStarted;
    @NotNull
    private final AtomicBoolean myIsReadFromByteChannelStarted;
    @NotNull
    private static final Logger logger;
    private static final int REUSED_BUFFER_SIZE = 65536;
    private static final int MESSAGE_LENGTH_BUFFER_SIZE = 4;
    private static final int FRAME_LENGTH_MIN = 0;
    private static final int FRAME_LENGTH_MAX = 300000000;
    private static final ThreadLocal<ByteBuffer> threadLocalReadBuffer;
    private static final ThreadLocal<ByteBuffer> threadLocalWriteBuffer;

    public FramedByteChannelImpl(@NotNull Lifetime lifetime, @NotNull String id, @NotNull ByteChannel underlyingChannel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)underlyingChannel, (String)"underlyingChannel");
        this.lifetime = lifetime;
        this.underlyingChannel = underlyingChannel;
        this.name = "Framed Channel (id: " + id + ")";
        this.frameReceived = new NamedSharedFlow("ReceivedFrame", SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null));
        this.receivedFramesChannel = new NamedChannel("FramesChannel", ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null));
        this.errorReceived = new NamedSharedFlow("ReceivedError", SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null));
        this.receivedErrorsChannel = new NamedChannel("ErrorsChannel", ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null));
        this.myIsProcessingCollectedEntriesStarted = new AtomicBoolean(false);
        this.myIsReadFromByteChannelStarted = new AtomicBoolean(false);
        this.receivedFramesChannel.getChannel().invokeOnClose(arg_0 -> FramedByteChannelImpl._init_$lambda$0(this, arg_0));
        this.receivedErrorsChannel.getChannel().invokeOnClose(arg_0 -> FramedByteChannelImpl._init_$lambda$1(this, arg_0));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    private final boolean isProcessingCollectedEntriesStarted() {
        return this.myIsProcessingCollectedEntriesStarted.get();
    }

    private final boolean isReadFromByteChannelStarted() {
        return this.myIsReadFromByteChannelStarted.get();
    }

    @Override
    public void send(@NotNull Frame frame) {
        ByteBuffer byteBuffer;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        ByteBuffer buffer = frame.compose();
        buffer.rewind();
        int len = buffer.remaining();
        int messageLength = 4 + len;
        Logger $this$trace$iv = FramedByteChannelImpl.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Sending " + len + " bytes");
        }
        if (messageLength <= 65536) {
            ByteBuffer it = $i$f$trace = threadLocalWriteBuffer.get().slice();
            boolean bl = false;
            it.limit(messageLength);
            byteBuffer = $i$f$trace;
        } else {
            byteBuffer = ByteBuffer.allocate(messageLength);
        }
        ByteBuffer messageBuffer = byteBuffer;
        messageBuffer.putInt(len);
        messageBuffer.put(buffer);
        messageBuffer.rewind();
        if (!this.underlyingChannel.isOpen()) {
            Logger $this$trace$iv2 = FramedByteChannelImpl.logger;
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace(this.getName() + " Underlying channel is closed. Unable to send message. Skip.");
            }
            return;
        }
        Intrinsics.checkNotNull((Object)messageBuffer);
        boolean writeSucceeded = ByteChannelExKt.writeAll((ByteChannel)this.underlyingChannel, (ByteBuffer)messageBuffer);
        if (!writeSucceeded) {
            throw new IllegalStateException(this.getName() + " Channel EOF");
        }
    }

    @Override
    public void onFrameReceived(@NotNull Lifetime lifetime, @NotNull Function1<? super Frame, Boolean> filter2, @NotNull Function1<? super Frame, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.subscribeOnNewChannelEntry(lifetime, this.frameReceived, filter2, handler);
    }

    @Override
    public void onErrorReceived(@NotNull Lifetime lifetime, @NotNull Function1<? super Throwable, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        FramedByteChannelImpl.subscribeOnNewChannelEntry$default(this, lifetime, this.errorReceived, null, handler, 4, null);
    }

    @Override
    public void startProcessingCollectedEntries() {
        if (!this.myIsProcessingCollectedEntriesStarted.compareAndSet(false, true)) {
            logger.warn(this.getName() + " Processing collected entries has already been started earlier. Warning!");
            return;
        }
        this.startProcessingCollectedEntries(this.receivedFramesChannel, this.frameReceived);
        this.startProcessingCollectedEntries(this.receivedErrorsChannel, this.errorReceived);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object receiveSingleSystemFrame(@NotNull Continuation<? super SystemFrame> $completion) throws UnexpectedFrameException {
        if (!($completion instanceof receiveSingleSystemFrame.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ FramedByteChannelImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.receiveSingleSystemFrame((Continuation<? super SystemFrame>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.isReadFromByteChannelStarted()) {
                    $i$a$-check-FramedByteChannelImpl$receiveSingleSystemFrame$2 = false;
                    $i$a$-check-FramedByteChannelImpl$receiveSingleSystemFrame$2 = "Please make sure you start reading from an underlying byte channel before try to receive a single frame from an internal channel";
                    throw new IllegalStateException($i$a$-check-FramedByteChannelImpl$receiveSingleSystemFrame$2.toString());
                }
                if (!(this.isProcessingCollectedEntriesStarted() == false)) {
                    $i$a$-check-FramedByteChannelImpl$receiveSingleSystemFrame$3 = false;
                    $i$a$-check-FramedByteChannelImpl$receiveSingleSystemFrame$3 = "Unable to read a single frame from a received Frames channel when processing is started. Please make sure you whether subscribe on processing collected Frames via onFrameReceived() or call receiveSingleSystemFrame() method before processing Frames process is started.";
                    throw new IllegalStateException($i$a$-check-FramedByteChannelImpl$receiveSingleSystemFrame$3.toString());
                }
                $continuation.label = 1;
                v0 = this.receivedFramesChannel.getChannel().receive((Continuation)$continuation);
                ** if (v0 != var12_4) goto lbl27
lbl26:
                // 1 sources

                return var12_4;
lbl27:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    $i$a$-check-FramedByteChannelImpl$receiveSingleSystemFrame$3 = (Frame)v0;
                }
                catch (ClosedReceiveChannelException e) {
                    $this$debug_u24default$iv = FramedByteChannelImpl.logger;
                    t$iv = null;
                    $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        var9_16 = $this$debug_u24default$iv;
                        $i$a$-debug$default-FramedByteChannelImpl$receiveSingleSystemFrame$frame$1 = false;
                        var9_16.debug(this.getName() + " Received a ClosedReceiveChannelException from a queue: " + e, t$iv);
                    }
                    throw new ClosedChannelException();
                }
                frame = $i$a$-check-FramedByteChannelImpl$receiveSingleSystemFrame$3;
                if (frame instanceof SystemFrame) {
                    $this$trace$iv = FramedByteChannelImpl.logger;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var9_17 = $this$trace$iv;
                        $i$a$-trace-FramedByteChannelImpl$receiveSingleSystemFrame$4 = false;
                        var9_17.trace(this.getName() + " Received a System Frame from a queue: " + frame);
                    }
                    return frame;
                }
                if (!(frame instanceof PingFrame)) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)frame);
                $continuation.label = 2;
                v1 = this.receiveSingleSystemFrame((Continuation<? super SystemFrame>)$continuation);
                if (v1 == var12_4) {
                    return var12_4;
                }
                ** GOTO lbl66
            }
            case 2: {
                frame = (Frame)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl66:
                // 2 sources

                return v1;
            }
        }
        throw new UnexpectedFrameException(SystemFrame.class, frame);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void startReceivingFromByteChannel() {
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(this.getName() + " Start reading byte channel stream", t$iv);
        }
        if (!this.underlyingChannel.isOpen()) {
            boolean bl = false;
            String string = this.getName() + " Unable to start reading from a byte channel, because underlying channel is closed (hash: " + this.underlyingChannel + ")";
            throw new IllegalStateException(string.toString());
        }
        if (!this.myIsReadFromByteChannelStarted.compareAndSet(false, true)) {
            logger.info(this.getName() + " Warning! Read from underlying byte channel has already been started. Skip.");
            return;
        }
        LifetimeCoroutineUtilKt.launch$default((Lifetime)this.lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FramedByteChannelImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var7_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        FramedByteChannelImpl.access$getLogger$cp().info(this.this$0.getName() + " Read thread: Start reading incoming frames");
                        try {
                        }
                        catch (CancellationException <unused var>) {
                            FramedByteChannelImpl.access$getLogger$cp().info(this.this$0.getName() + " Read byte channel job was cancelled");
                            ** GOTO lbl62
                        }
                        catch (ClosedByInterruptException <unused var>) {
                            FramedByteChannelImpl.access$getLogger$cp().info(this.this$0.getName() + " ClosedByInterruptException");
                            ** GOTO lbl62
                        }
                        catch (InterruptedException <unused var>) {
                            FramedByteChannelImpl.access$getLogger$cp().info(this.this$0.getName() + " InterruptedException");
                            ** GOTO lbl62
                        }
                        catch (ClosedChannelException <unused var>) {
                            FramedByteChannelImpl.access$getLogger$cp().info(this.this$0.getName() + " ClosedChannelException");
                            ** GOTO lbl62
                        }
                        catch (NeedsReadException <unused var>) {
                            FramedByteChannelImpl.access$getLogger$cp().info(this.this$0.getName() + " NeedsReadException");
                            ** GOTO lbl62
                        }
                        catch (Throwable t) {
                            FramedByteChannelImpl.access$getLogger$cp().info(this.this$0.getName() + " General exception: " + t.getMessage());
                            v0 = t.getMessage();
                            v1 = v0 != null ? !StringsKt.contains$default((CharSequence)v0, (CharSequence)"Output closed", (boolean)false, (int)2, null) : false;
                            if (v1) {
                                if (!(t instanceof IOException)) {
                                    FramedByteChannelImpl.access$getLogger$cp().error(this.this$0.getName() + " Error while reading protocol frames: " + t.getMessage(), t);
                                }
                                FramedByteChannelImpl.access$getLogger$cp().info(this.this$0.getName() + " Got unexpected exception: " + t.getMessage());
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)t);
                                this.label = 2;
                                v2 = FramedByteChannelImpl.access$addErrorToChannel(this.this$0, t, (Continuation)this);
                                if (v2 == var7_3) {
                                    return var7_3;
                                }
                            }
                            ** GOTO lbl62
                        }
lbl40:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch) && FramedByteChannelImpl.access$getUnderlyingChannel$p(this.this$0).isOpen()) {
                            nextFrame = FramedByteChannelImpl.access$readNextFrameFromByteChannel(this.this$0);
                            if (nextFrame != null) ** GOTO lbl45
                            FramedByteChannelImpl.access$getLogger$cp().info(this.this$0.getName() + " Read operation. Read returns <NULL> result. Stop reading from underlying byte channel.");
                            ** GOTO lbl62
lbl45:
                            // 1 sources

                            this.L$0 = $this$launch;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)nextFrame);
                            this.label = 1;
                            v3 = FramedByteChannelImpl.access$addFrameToChannel(this.this$0, nextFrame, (Continuation)this);
                            if (v3 != var7_3) continue;
                            return var7_3;
                        }
                        ** GOTO lbl62
                    }
                    case 1: {
                        nextFrame = (Frame)this.L$1;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                            ** GOTO lbl40
                        }
                    }
                    case 2: {
                        t = (Throwable)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl62:
                        // 9 sources

                        var3_4 = this.this$0;
                        $i$f$catchAndDrop = false;
                        try {
                            $i$a$-catchAndDrop-FramedByteChannelImpl$startReceivingFromByteChannel$3$6 = false;
                            FramedByteChannelImpl.access$getLogger$cp().info(var3_4.getName() + " Read thread is terminated. Closing underlying channel (hash: " + FramedByteChannelImpl.access$getUnderlyingChannel$p(var3_4).hashCode() + ", isOpen: " + FramedByteChannelImpl.access$getUnderlyingChannel$p(var3_4).isOpen() + ")");
                            FramedByteChannelImpl.access$getUnderlyingChannel$p(var3_4).close();
                        }
                        catch (Throwable var6_13) {
                        }
                        var3_4 = this.this$0;
                        $i$f$catchAndDrop = false;
                        try {
                            $i$a$-catchAndDrop-FramedByteChannelImpl$startReceivingFromByteChannel$3$7 = false;
                            FramedByteChannelImpl.access$getLogger$cp().info(var3_4.getName() + " Read thread is terminated. Closing frames channels");
                            SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)FramedByteChannelImpl.access$getReceivedFramesChannel$p(var3_4).getChannel()), null, (int)1, null);
                        }
                        catch (Throwable var6_14) {
                        }
                        var3_4 = this.this$0;
                        $i$f$catchAndDrop = false;
                        try {
                            $i$a$-catchAndDrop-FramedByteChannelImpl$startReceivingFromByteChannel$3$8 = false;
                            FramedByteChannelImpl.access$getLogger$cp().info(var3_4.getName() + " Read thread is terminated. Closing errors channels");
                            SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)FramedByteChannelImpl.access$getReceivedErrorsChannel$p(var3_4).getChannel()), null, (int)1, null);
                            return Unit.INSTANCE;
                        }
                        catch (Throwable var6_15) {
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Frame readNextFrameFromByteChannel() {
        void it;
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2;
        ByteBuffer byteBuffer3;
        ByteBuffer reusedBuffer = threadLocalReadBuffer.get();
        reusedBuffer.rewind();
        ByteBuffer it2 = byteBuffer3 = reusedBuffer.slice();
        boolean bl = false;
        it2.limit(4);
        ByteBuffer frameLengthBuffer = byteBuffer3;
        if (!this.underlyingChannel.isOpen()) {
            logger.warn(this.getName() + " Unable to read next message. Channel is closed.");
            return null;
        }
        Intrinsics.checkNotNull((Object)frameLengthBuffer);
        boolean frameLengthReadSucceeded = ByteChannelExKt.readAll((ByteChannel)this.underlyingChannel, (ByteBuffer)frameLengthBuffer);
        if (!frameLengthReadSucceeded) {
            logger.warn(this.getName() + " Failed to read next message LENGTH value.");
            return null;
        }
        reusedBuffer.rewind();
        int frameLength = reusedBuffer.getInt();
        if (frameLength < 0) {
            throw new IllegalStateException(this.getName() + " Receive frame with unexpected length less then: 0. Length: " + frameLength);
        }
        if (frameLength > 300000000) {
            throw new IllegalStateException(this.getName() + " Read frame length that is too big. Expected size to be less then or equal: 300000000, but got: " + frameLength + ". Possibly broken frame.");
        }
        if (frameLength <= 65536) {
            reusedBuffer.rewind();
            byteBuffer2 = reusedBuffer;
        } else {
            byteBuffer2 = ByteBuffer.allocate(frameLength);
        }
        ByteBuffer frameBuffer = byteBuffer2;
        ByteBuffer byteBuffer4 = byteBuffer = frameBuffer.slice();
        ByteChannel byteChannel = this.underlyingChannel;
        boolean bl2 = false;
        it.limit(frameLength);
        ByteBuffer byteBuffer5 = byteBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer5, (String)"also(...)");
        boolean isReadSucceeded = ByteChannelExKt.readAll((ByteChannel)byteChannel, (ByteBuffer)byteBuffer5);
        if (!isReadSucceeded) {
            boolean $i$a$-check-FramedByteChannelImpl$readNextFrameFromByteChannel$22 = false;
            String $i$a$-check-FramedByteChannelImpl$readNextFrameFromByteChannel$22 = this.getName() + " Got EOF while reading a frame. Length: " + frameLength;
            throw new IllegalStateException($i$a$-check-FramedByteChannelImpl$readNextFrameFromByteChannel$22.toString());
        }
        frameBuffer.rewind();
        ByteBuffer messageNewBuffer = frameBuffer.slice();
        messageNewBuffer.limit(frameLength);
        Intrinsics.checkNotNull((Object)messageNewBuffer);
        Frame frame = FrameFactory.INSTANCE.toFrame(messageNewBuffer);
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            byteChannel = $this$trace$iv;
            boolean bl3 = false;
            byteChannel.trace(this.getName() + " Received a frame from a byte channel. Frame: <" + frame + ">");
        }
        return frame;
    }

    private final Object addFrameToChannel(Frame frame, Continuation<? super Unit> $completion) {
        Object object = this.addToChannel(this.receivedFramesChannel, frame, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object addErrorToChannel(Throwable t, Continuation<? super Unit> $completion) {
        Object object = this.addToChannel(this.receivedErrorsChannel, t, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final <T> Object addToChannel(NamedChannel<T> channel, T entry, Continuation<? super Unit> $completion) {
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Add a new entry to the channel: " + channel.getName() + ", entry: " + entry);
        }
        Object object = channel.getChannel().send(entry, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final <T> void subscribeOnNewChannelEntry(Lifetime lifetime, NamedSharedFlow<T> flow, Function1<? super T, Boolean> filter2, Function1<? super T, Unit> handler) {
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Add handler for flow: " + flow.getName(), t$iv);
        }
        if (this.isProcessingCollectedEntriesStarted()) {
            logger.warn(this.getName() + " Processing collected entries has already been started. Please note that some messages might be lost! Consider subscribe earlier before [startProcessingCollectedEntries] call.");
        }
        LifetimeCoroutineUtilKt.launch$default((Lifetime)lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(flow, filter2, handler, null){
            int label;
            final /* synthetic */ NamedSharedFlow<T> $flow;
            final /* synthetic */ Function1<T, Boolean> $filter;
            final /* synthetic */ Function1<T, Unit> $handler;
            {
                this.$flow = $flow;
                this.$filter = $filter;
                this.$handler = $handler;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$flow.getFlow().collect(new FlowCollector(this.$filter, this.$handler){
                            final /* synthetic */ Function1<T, Boolean> $filter;
                            final /* synthetic */ Function1<T, Unit> $handler;
                            {
                                this.$filter = $filter;
                                this.$handler = $handler;
                            }

                            public final Object emit(T entry, Continuation<? super Unit> $completion) {
                                if (((Boolean)this.$filter.invoke(entry)).booleanValue()) {
                                    this.$handler.invoke(entry);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    static /* synthetic */ void subscribeOnNewChannelEntry$default(FramedByteChannelImpl framedByteChannelImpl, Lifetime lifetime, NamedSharedFlow namedSharedFlow, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = FramedByteChannelImpl::subscribeOnNewChannelEntry$lambda$0;
        }
        framedByteChannelImpl.subscribeOnNewChannelEntry(lifetime, namedSharedFlow, function1, function12);
    }

    private final <T> void startProcessingCollectedEntries(NamedChannel<T> channel, NamedSharedFlow<T> flow) {
        LifetimeCoroutineUtilKt.launch$default((Lifetime)this.lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(channel, flow, this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int label;
            final /* synthetic */ NamedChannel<T> $channel;
            final /* synthetic */ NamedSharedFlow<T> $flow;
            final /* synthetic */ FramedByteChannelImpl this$0;
            {
                this.$channel = $channel;
                this.$flow = $flow;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private static final Unit _init_$lambda$0(FramedByteChannelImpl this$0, Throwable cause) {
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(this$0.getName() + " Receive frames channel is closed. Cause: " + cause, t$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(FramedByteChannelImpl this$0, Throwable cause) {
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(this$0.getName() + " Receive errors channel is closed. Cause: " + cause, t$iv);
        }
        return Unit.INSTANCE;
    }

    private static final boolean subscribeOnNewChannelEntry$lambda$0(Object it) {
        return true;
    }

    private static final ByteBuffer threadLocalReadBuffer$lambda$0() {
        return ByteBuffer.allocate(65536);
    }

    private static final ByteBuffer threadLocalWriteBuffer$lambda$0() {
        return ByteBuffer.allocate(65536);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ ByteChannel access$getUnderlyingChannel$p(FramedByteChannelImpl $this) {
        return $this.underlyingChannel;
    }

    public static final /* synthetic */ Frame access$readNextFrameFromByteChannel(FramedByteChannelImpl $this) {
        return $this.readNextFrameFromByteChannel();
    }

    public static final /* synthetic */ Object access$addFrameToChannel(FramedByteChannelImpl $this, Frame frame, Continuation $completion) {
        return $this.addFrameToChannel(frame, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$addErrorToChannel(FramedByteChannelImpl $this, Throwable t, Continuation $completion) {
        return $this.addErrorToChannel(t, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ NamedChannel access$getReceivedFramesChannel$p(FramedByteChannelImpl $this) {
        return $this.receivedFramesChannel;
    }

    public static final /* synthetic */ NamedChannel access$getReceivedErrorsChannel$p(FramedByteChannelImpl $this) {
        return $this.receivedErrorsChannel;
    }

    public static final /* synthetic */ Object access$addToChannel(FramedByteChannelImpl $this, NamedChannel channel, Object entry, Continuation $completion) {
        return $this.addToChannel(channel, entry, (Continuation<? super Unit>)$completion);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FramedByteChannelImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FramedByteChannelImpl.logger = logger;
        threadLocalReadBuffer = ThreadLocal.withInitial(FramedByteChannelImpl::threadLocalReadBuffer$lambda$0);
        threadLocalWriteBuffer = ThreadLocal.withInitial(FramedByteChannelImpl::threadLocalWriteBuffer$lambda$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/split/connection/protocol/channel/FramedByteChannelImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "REUSED_BUFFER_SIZE", "", "MESSAGE_LENGTH_BUFFER_SIZE", "FRAME_LENGTH_MIN", "FRAME_LENGTH_MAX", "threadLocalReadBuffer", "Ljava/lang/ThreadLocal;", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "threadLocalWriteBuffer", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003J)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0004H\u00d6\u0081\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/split/connection/protocol/channel/FramedByteChannelImpl$NamedChannel;", "T", "", "name", "", "channel", "Lkotlinx/coroutines/channels/Channel;", "<init>", "(Ljava/lang/String;Lkotlinx/coroutines/channels/Channel;)V", "getName", "()Ljava/lang/String;", "getChannel", "()Lkotlinx/coroutines/channels/Channel;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.split.connection"})
    private static final class NamedChannel<T> {
        @NotNull
        private final String name;
        @NotNull
        private final Channel<T> channel;

        public NamedChannel(@NotNull String name, @NotNull Channel<T> channel) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(channel, (String)"channel");
            this.name = name;
            this.channel = channel;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Channel<T> getChannel() {
            return this.channel;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Channel<T> component2() {
            return this.channel;
        }

        @NotNull
        public final NamedChannel<T> copy(@NotNull String name, @NotNull Channel<T> channel) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(channel, (String)"channel");
            return new NamedChannel<T>(name, channel);
        }

        public static /* synthetic */ NamedChannel copy$default(NamedChannel namedChannel, String string, Channel channel, int n, Object object) {
            if ((n & 1) != 0) {
                string = namedChannel.name;
            }
            if ((n & 2) != 0) {
                channel = namedChannel.channel;
            }
            return namedChannel.copy(string, channel);
        }

        @NotNull
        public String toString() {
            return "NamedChannel(name=" + this.name + ", channel=" + this.channel + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.channel.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NamedChannel)) {
                return false;
            }
            NamedChannel namedChannel = (NamedChannel)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)namedChannel.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.channel, namedChannel.channel);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003J)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0004H\u00d6\u0081\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/split/connection/protocol/channel/FramedByteChannelImpl$NamedSharedFlow;", "T", "", "name", "", "flow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "<init>", "(Ljava/lang/String;Lkotlinx/coroutines/flow/MutableSharedFlow;)V", "getName", "()Ljava/lang/String;", "getFlow", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.split.connection"})
    private static final class NamedSharedFlow<T> {
        @NotNull
        private final String name;
        @NotNull
        private final MutableSharedFlow<T> flow;

        public NamedSharedFlow(@NotNull String name, @NotNull MutableSharedFlow<T> flow) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(flow, (String)"flow");
            this.name = name;
            this.flow = flow;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final MutableSharedFlow<T> getFlow() {
            return this.flow;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final MutableSharedFlow<T> component2() {
            return this.flow;
        }

        @NotNull
        public final NamedSharedFlow<T> copy(@NotNull String name, @NotNull MutableSharedFlow<T> flow) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(flow, (String)"flow");
            return new NamedSharedFlow<T>(name, flow);
        }

        public static /* synthetic */ NamedSharedFlow copy$default(NamedSharedFlow namedSharedFlow, String string, MutableSharedFlow mutableSharedFlow, int n, Object object) {
            if ((n & 1) != 0) {
                string = namedSharedFlow.name;
            }
            if ((n & 2) != 0) {
                mutableSharedFlow = namedSharedFlow.flow;
            }
            return namedSharedFlow.copy(string, mutableSharedFlow);
        }

        @NotNull
        public String toString() {
            return "NamedSharedFlow(name=" + this.name + ", flow=" + this.flow + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.flow.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NamedSharedFlow)) {
                return false;
            }
            NamedSharedFlow namedSharedFlow = (NamedSharedFlow)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)namedSharedFlow.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.flow, namedSharedFlow.flow);
        }
    }
}

