/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.channel;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.controlCenterTab.ConnectionConfigurationWidgetService;
import com.intellij.platform.split.connection.protocol.channel.FramedByteChannel;
import com.intellij.platform.split.connection.protocol.channel.InternalConnectionProxyChannel;
import com.intellij.platform.split.connection.protocol.channel.InternalConnectionProxyModelImpl;
import com.intellij.platform.split.connection.protocol.channel.InternalDelayableChannelProcessor;
import com.intellij.platform.split.connection.protocol.channel.frame.Frame;
import com.intellij.platform.split.connection.protocol.channel.frame.SystemFrame;
import com.intellij.platform.split.connection.protocol.transport.NamedTransportEntity;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J8\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001d0\u001c2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150\u001cH\u0016J$\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00150\u001cH\u0016J\b\u0010!\u001a\u00020\u0015H\u0016J\b\u0010\"\u001a\u00020\u0015H\u0016J\u000e\u0010#\u001a\u00020$H\u0096@\u00a2\u0006\u0002\u0010%J\u0017\u0010&\u001a\u00020\u00152\b\u0010'\u001a\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0002\b)J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u001dH\u0016J\b\u0010,\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/platform/split/connection/protocol/channel/InternalConnectionProxyChannelImpl;", "Lcom/intellij/platform/split/connection/protocol/channel/InternalConnectionProxyChannel;", "Lcom/intellij/platform/split/connection/protocol/transport/NamedTransportEntity;", "id", "", "underlyingChannel", "Lcom/intellij/platform/split/connection/protocol/channel/FramedByteChannel;", "<init>", "(Ljava/lang/String;Lcom/intellij/platform/split/connection/protocol/channel/FramedByteChannel;)V", "name", "getName", "()Ljava/lang/String;", "myDelayableChannelProcessor", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/platform/split/connection/protocol/channel/InternalDelayableChannelProcessor;", "delayableChannelProcessorOrNull", "getDelayableChannelProcessorOrNull", "()Lcom/intellij/platform/split/connection/protocol/channel/InternalDelayableChannelProcessor;", "model", "Lcom/intellij/platform/split/connection/protocol/channel/InternalConnectionProxyModelImpl;", "send", "", "frame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/Frame;", "onFrameReceived", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "filter", "Lkotlin/Function1;", "", "handler", "onErrorReceived", "", "startReceivingFromByteChannel", "startProcessingCollectedEntries", "receiveSingleSystemFrame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/SystemFrame;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setDelay", "delay", "Lkotlin/time/Duration;", "setDelay-BwNAW2A", "enableConnectionProxy", "state", "initDelayableChannelProcessor", "Companion", "intellij.platform.split.connection"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInternalConnectionProxyChannelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalConnectionProxyChannelImpl.kt\ncom/intellij/platform/split/connection/protocol/channel/InternalConnectionProxyChannelImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,140:1\n1#2:141\n42#3,3:142\n13#4:145\n13#5:146\n*S KotlinDebug\n*F\n+ 1 InternalConnectionProxyChannelImpl.kt\ncom/intellij/platform/split/connection/protocol/channel/InternalConnectionProxyChannelImpl\n*L\n132#1:142,3\n26#1:145\n26#1:146\n*E\n"})
public final class InternalConnectionProxyChannelImpl
implements InternalConnectionProxyChannel,
NamedTransportEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final FramedByteChannel underlyingChannel;
    @NotNull
    private final String name;
    @NotNull
    private final AtomicReference<InternalDelayableChannelProcessor> myDelayableChannelProcessor;
    @NotNull
    private final InternalConnectionProxyModelImpl model;
    @NotNull
    private static final Logger logger;

    public InternalConnectionProxyChannelImpl(@NotNull String id, @NotNull FramedByteChannel underlyingChannel) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)underlyingChannel, (String)"underlyingChannel");
        this.id = id;
        this.underlyingChannel = underlyingChannel;
        this.name = "Connection Internal Proxy (id: " + this.id + ")";
        this.myDelayableChannelProcessor = new AtomicReference<Object>(null);
        this.model = new InternalConnectionProxyModelImpl();
        this.initDelayableChannelProcessor();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    private final InternalDelayableChannelProcessor getDelayableChannelProcessorOrNull() {
        return this.myDelayableChannelProcessor.get();
    }

    @Override
    public void send(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        InternalDelayableChannelProcessor channelProcessor = this.getDelayableChannelProcessorOrNull();
        if (channelProcessor != null) {
            if (channelProcessor.sendToSendChannel(frame)) {
                return;
            }
            channelProcessor.join();
        }
        this.underlyingChannel.send(frame);
    }

    @Override
    public void onFrameReceived(@NotNull Lifetime lifetime, @NotNull Function1<? super Frame, Boolean> filter2, @NotNull Function1<? super Frame, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.underlyingChannel.onFrameReceived(lifetime, filter2, (Function1<? super Frame, Unit>)((Function1)arg_0 -> InternalConnectionProxyChannelImpl.onFrameReceived$lambda$0(this, handler, arg_0)));
    }

    @Override
    public void onErrorReceived(@NotNull Lifetime lifetime, @NotNull Function1<? super Throwable, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.underlyingChannel.onErrorReceived(lifetime, (Function1<? super Throwable, Unit>)((Function1)arg_0 -> InternalConnectionProxyChannelImpl.onErrorReceived$lambda$0(handler, arg_0)));
    }

    @Override
    public void startReceivingFromByteChannel() {
        this.underlyingChannel.startReceivingFromByteChannel();
    }

    @Override
    public void startProcessingCollectedEntries() {
        this.underlyingChannel.startProcessingCollectedEntries();
    }

    @Override
    @Nullable
    public Object receiveSingleSystemFrame(@NotNull Continuation<? super SystemFrame> $completion) {
        return this.underlyingChannel.receiveSingleSystemFrame($completion);
    }

    @Override
    public void setDelay-BwNAW2A(@Nullable Duration delay) {
        block1: {
            InternalDelayableChannelProcessor channelProcessor = this.getDelayableChannelProcessorOrNull();
            if (channelProcessor == null) {
                logger.warn("Unable to set delay. Delayable channel is not defined");
                return;
            }
            Duration duration = delay;
            if (duration == null) break block1;
            long it = duration.unbox-impl();
            boolean bl = false;
            this.model.setTransportDelay-LRDsOJo(it);
        }
    }

    @Override
    public void enableConnectionProxy(boolean state) {
        boolean bl = state;
        if (bl) {
            InternalDelayableChannelProcessor delayableChannel = this.getDelayableChannelProcessorOrNull();
            if (delayableChannel != null) {
                logger.warn("Delayable channel is set when it should not be. Return");
                return;
            }
            this.myDelayableChannelProcessor.set(new InternalDelayableChannelProcessor(this.id, this.underlyingChannel, this.model));
        } else if (!bl) {
            InternalDelayableChannelProcessor channelProcessor = this.getDelayableChannelProcessorOrNull();
            if (channelProcessor == null) {
                logger.warn("Expected to get delayable channel active, but received null. Return");
                return;
            }
            channelProcessor.terminateState();
            channelProcessor.join();
            this.myDelayableChannelProcessor.set(null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void initDelayableChannelProcessor() {
        boolean $i$f$service = false;
        Class<ConnectionConfigurationWidgetService> serviceClass$iv = ConnectionConfigurationWidgetService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        if (((ConnectionConfigurationWidgetService)((Object)object)).isEnabled()) {
            this.myDelayableChannelProcessor.set(new InternalDelayableChannelProcessor(this.id, this.underlyingChannel, this.model));
        }
    }

    private static final Unit onFrameReceived$lambda$0(InternalConnectionProxyChannelImpl this$0, Function1 $handler, Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        InternalDelayableChannelProcessor channelProcessor = this$0.getDelayableChannelProcessorOrNull();
        if (channelProcessor != null) {
            if (channelProcessor.sendToReceiveChannel(frame, (Function1<? super Frame, Unit>)$handler)) {
                return Unit.INSTANCE;
            }
            channelProcessor.join();
        }
        $handler.invoke((Object)frame);
        return Unit.INSTANCE;
    }

    private static final Unit onErrorReceived$lambda$0(Function1 $handler, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        $handler.invoke((Object)throwable);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(InternalConnectionProxyChannelImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        InternalConnectionProxyChannelImpl.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/split/connection/protocol/channel/InternalConnectionProxyChannelImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

