/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.channel.certificate;

import com.intellij.platform.split.connection.protocol.channel.certificate.RemoteTrustManagerKt;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H&J\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/split/connection/protocol/channel/certificate/RemoteTrustManager;", "Ljavax/net/ssl/X509TrustManager;", "<init>", "()V", "myTrustedChain", "Ljava/util/concurrent/CompletableFuture;", "", "Ljava/security/cert/X509Certificate;", "checkHandshakeTrusted", "", "certificates", "getAcceptedIssuers", "", "()[Ljava/security/cert/X509Certificate;", "checkTrusted", "getCertificates", "intellij.platform.split.connection"})
public abstract class RemoteTrustManager
implements X509TrustManager {
    @NotNull
    private final CompletableFuture<List<X509Certificate>> myTrustedChain = new CompletableFuture();

    public abstract void checkHandshakeTrusted(@NotNull List<? extends X509Certificate> var1);

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    public final void checkTrusted(@NotNull List<? extends X509Certificate> certificates) {
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        try {
            this.checkHandshakeTrusted(certificates);
            this.myTrustedChain.complete(certificates);
        }
        catch (Throwable t) {
            this.myTrustedChain.completeExceptionally(t);
            throw t;
        }
    }

    @NotNull
    public final List<X509Certificate> getCertificates() {
        try {
            List<X509Certificate> chainResult = this.myTrustedChain.get(2L, TimeUnit.SECONDS);
            RemoteTrustManagerKt.access$getLogger$p().info("Trust Manager. Received " + chainResult.size() + " certificates");
            Intrinsics.checkNotNull(chainResult);
            return chainResult;
        }
        catch (Throwable t) {
            RemoteTrustManagerKt.access$getLogger$p().warn("Unable to get certificates due to error: " + t.getMessage() + ". Please make sure TLS handshake had happened.", t);
            throw t;
        }
    }
}

