/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.transport;

import com.intellij.platform.split.connection.protocol.ConnectionState;
import com.intellij.platform.split.connection.protocol.ConnectionStateProperty;
import com.intellij.platform.split.connection.protocol.transport.StreamTransport;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.Maybe;
import com.jetbrains.rd.util.RdDefaultErrorLoggerHolder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.nio.channels.ByteChannel;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006#"}, d2={"Lcom/intellij/platform/split/connection/protocol/transport/RetryingConnectStreamTransport;", "Lcom/intellij/platform/split/connection/protocol/transport/StreamTransport;", "id", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "moniker", "streamTransportFactory", "Lkotlin/Function1;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getStreamTransportFactory", "()Lkotlin/jvm/functions/Function1;", "name", "getName", "()Ljava/lang/String;", "myUnderlyingTransport", "Ljava/util/concurrent/atomic/AtomicReference;", "currentConnectionState", "Lcom/intellij/platform/split/connection/protocol/ConnectionStateProperty;", "transportSequentialLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "initialConnect", "", "byteChannel", "Ljava/nio/channels/ByteChannel;", "getByteChannel", "()Ljava/nio/channels/ByteChannel;", "connected", "getConnected", "()Lcom/intellij/platform/split/connection/protocol/ConnectionStateProperty;", "checkInitialConnectionState", "", "retry", "Companion", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nRetryingConnectStreamTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetryingConnectStreamTransport.kt\ncom/intellij/platform/split/connection/protocol/transport/RetryingConnectStreamTransport\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,124:1\n137#2:125\n135#2:126\n117#2,7:127\n136#2:134\n135#2:135\n117#2,7:136\n136#2:143\n1#3:144\n23#4:145\n*S KotlinDebug\n*F\n+ 1 RetryingConnectStreamTransport.kt\ncom/intellij/platform/split/connection/protocol/transport/RetryingConnectStreamTransport\n*L\n78#1:125\n78#1:126\n78#1:127,7\n78#1:134\n105#1:135\n105#1:136,7\n105#1:143\n23#1:145\n*E\n"})
public final class RetryingConnectStreamTransport
implements StreamTransport {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String moniker;
    @NotNull
    private final Function1<Lifetime, StreamTransport> streamTransportFactory;
    @NotNull
    private final String name;
    @NotNull
    private final AtomicReference<StreamTransport> myUnderlyingTransport;
    @NotNull
    private final ConnectionStateProperty currentConnectionState;
    @NotNull
    private final SequentialLifetimes transportSequentialLifetimes;
    private boolean initialConnect;
    @NotNull
    private static final com.intellij.openapi.diagnostic.Logger LOG;
    private static final long RETRY_INTERVAL_MS = 500L;

    public RetryingConnectStreamTransport(@NotNull String id, @NotNull Lifetime lifetime, @NotNull String moniker, @NotNull Function1<? super Lifetime, ? extends StreamTransport> streamTransportFactory) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)moniker, (String)"moniker");
        Intrinsics.checkNotNullParameter(streamTransportFactory, (String)"streamTransportFactory");
        this.moniker = moniker;
        this.streamTransportFactory = streamTransportFactory;
        this.name = "Retry Transport (id: " + id + ")";
        this.myUnderlyingTransport = new AtomicReference<Object>(null);
        this.currentConnectionState = new ConnectionStateProperty();
        this.transportSequentialLifetimes = new SequentialLifetimes(lifetime);
        this.initialConnect = true;
        SourceExKt.adviseWithPrev((ISource)((ISource)this.currentConnectionState), (Lifetime)lifetime, (arg_0, arg_1) -> RetryingConnectStreamTransport._init_$lambda$0(this, arg_0, arg_1));
        this.retry();
    }

    @NotNull
    public final Function1<Lifetime, StreamTransport> getStreamTransportFactory() {
        return this.streamTransportFactory;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ByteChannel getByteChannel() {
        StreamTransport streamTransport = this.myUnderlyingTransport.get();
        if (streamTransport == null) {
            boolean bl = false;
            String string = "Underlying transport is undefined. Make sure init is completed";
            throw new IllegalStateException(string.toString());
        }
        StreamTransport underlyingChannel = streamTransport;
        return underlyingChannel.getByteChannel();
    }

    @NotNull
    public ConnectionStateProperty getConnected() {
        return this.currentConnectionState;
    }

    private final void checkInitialConnectionState() {
        ConnectionState currentState = this.currentConnectionState.getValue();
        if (!Intrinsics.areEqual((Object)currentState, (Object)ConnectionState.NOT_CONNECTED.INSTANCE)) {
            throw new IllegalStateException(this.getName() + " Retry failed. Expected connection status: <" + ConnectionState.NOT_CONNECTED.INSTANCE + ">, but got: <" + currentState + ">");
        }
    }

    private final void retry() {
        StreamTransport streamTransport;
        this.checkInitialConnectionState();
        LifetimeDefinition transportLifetime = this.transportSequentialLifetimes.next();
        try {
            streamTransport = (StreamTransport)this.streamTransportFactory.invoke((Object)transportLifetime);
        }
        catch (Throwable t) {
            boolean $i$f$catch = false;
            Object comment$iv$iv = null;
            boolean $i$f$catch2 = false;
            Logger $this$catch$iv$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
            boolean $i$f$catch3 = false;
            try {
                boolean bl = false;
                this.transportSequentialLifetimes.terminateCurrent();
            }
            catch (Throwable e$iv$iv$iv) {
                String sfx$iv$iv$iv = e$iv$iv$iv.getClass().getName() + " " + e$iv$iv$iv.getMessage() + "";
                LoggerKt.error((Logger)$this$catch$iv$iv$iv, (String)("Catch " + sfx$iv$iv$iv), (Throwable)e$iv$iv$iv);
            }
            this.currentConnectionState.set(new ConnectionState.FAULTED(new IllegalStateException("Unable to create stream transport", t)));
            return;
        }
        StreamTransport transport = streamTransport;
        this.myUnderlyingTransport.set(transport);
        transport.getConnected().advise((Lifetime)transportLifetime, arg_0 -> RetryingConnectStreamTransport.retry$lambda$1(this, arg_0));
    }

    private static final Unit _init_$lambda$0(RetryingConnectStreamTransport this$0, Maybe previous, ConnectionState current) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        LOG.info(this$0.connectionStateChangedToString((ConnectionState)previous.getAsNullable(), current));
        return Unit.INSTANCE;
    }

    private static final void retry$lambda$1$0(RetryingConnectStreamTransport this$0) {
        String comment$iv = "Retrying connection to " + this$0.moniker;
        boolean $i$f$catch = false;
        Logger $this$catch$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
        boolean $i$f$catch2 = false;
        try {
            boolean bl = false;
            Thread.sleep(500L);
            this$0.retry();
        }
        catch (Throwable e$iv$iv) {
            CharSequence charSequence = comment$iv;
            String sfx$iv$iv = e$iv$iv.getClass().getName() + " " + e$iv$iv.getMessage() + (String)(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "" : " (" + comment$iv + ")");
            LoggerKt.error((Logger)$this$catch$iv$iv, (String)("Catch " + sfx$iv$iv), (Throwable)e$iv$iv);
        }
    }

    private static final Unit retry$lambda$1(RetryingConnectStreamTransport this$0, ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ConnectionState connectionState = state;
        if (!Intrinsics.areEqual((Object)connectionState, (Object)ConnectionState.NOT_CONNECTED.INSTANCE)) {
            if (Intrinsics.areEqual((Object)connectionState, (Object)ConnectionState.CONNECTED.INSTANCE) || Intrinsics.areEqual((Object)connectionState, (Object)ConnectionState.CLOSED.INSTANCE) || connectionState instanceof ConnectionState.DECLINED) {
                this$0.currentConnectionState.set(state);
                this$0.initialConnect = false;
            } else if (connectionState instanceof ConnectionState.FAULTED) {
                if (this$0.initialConnect) {
                    LOG.info(this$0.getName() + " Connect to " + this$0.moniker + " failed, retrying in 500 ms: " + ((ConnectionState.FAULTED)state).getThrowable().getMessage(), ((ConnectionState.FAULTED)state).getThrowable());
                    AppExecutorUtil.getAppExecutorService().execute(() -> RetryingConnectStreamTransport.retry$lambda$1$0(this$0));
                } else {
                    this$0.currentConnectionState.set(state);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        Unit it = Unit.INSTANCE;
        boolean bl = false;
        return Unit.INSTANCE;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/split/connection/protocol/transport/RetryingConnectStreamTransport$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "RETRY_INTERVAL_MS", "", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

