/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.wire.storage;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.Formats;
import com.intellij.platform.split.connection.impl.config.ConnectionConfiguration;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportInfo;
import com.intellij.platform.split.connection.protocol.wire.WireInfo;
import com.intellij.platform.split.connection.protocol.wire.storage.WireStorage;
import com.intellij.platform.split.connection.protocol.wire.storage.WireStorageEntry;
import com.intellij.platform.split.connection.protocol.wire.storage.WireStorageKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.time.TimeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 G2\u00020\u0001:\u0001GBG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0011J\u000e\u0010!\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0011J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00122\u0006\u0010 \u001a\u00020\u0011J&\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120$2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00050&J\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010 \u001a\u00020\u0011J\u001c\u0010)\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00112\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120$J\u0016\u0010-\u001a\u00020.2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u0012J\u000e\u00100\u001a\u00020.2\u0006\u0010 \u001a\u00020\u0011J\u0010\u00100\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0012H\u0002J\u000e\u00101\u001a\u00020.2\u0006\u0010 \u001a\u00020\u0011J\u000e\u00102\u001a\u00020.2\u0006\u0010 \u001a\u00020\u0011J\u000e\u00102\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0012J\u0010\u00103\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0012H\u0002J\u0010\u00104\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0012H\u0002J\u0006\u00105\u001a\u00020.J\b\u00106\u001a\u00020.H\u0002J\u000e\u00107\u001a\u00020.2\u0006\u0010 \u001a\u00020\u0011J\u000e\u00107\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0012J\u0010\u00108\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0011H\u0007J\u0010\u00109\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0011H\u0002J\u0010\u00109\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0012H\u0002J \u0010:\u001a\u00020.2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010;\u001a\u00020\bH\u0082@\u00a2\u0006\u0002\u0010<J \u0010=\u001a\u00020.2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010;\u001a\u00020\bH\u0082@\u00a2\u0006\u0002\u0010<J4\u0010>\u001a\u00020.2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\b2\u0006\u0010?\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020.0+H\u0082@\u00a2\u0006\u0002\u0010BJ\u0010\u0010C\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020\u000bH\u0002J\u0010\u0010E\u001a\u00020@2\u0006\u0010F\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006H"}, d2={"Lcom/intellij/platform/split/connection/protocol/wire/storage/WireStorage;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "scheduleWireBufferSizeCheck", "", "scheduleWireExpirationCheck", "wireSuspendedAfter", "Ljava/time/Duration;", "processWiresInterval", "unconfirmedMessagesBufferSizeLimitBytes", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;ZZLjava/time/Duration;Ljava/time/Duration;Ljava/lang/Long;)V", "Ljava/lang/Long;", "myClientToWireMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/codeWithMe/ClientId;", "Lcom/intellij/platform/split/connection/protocol/wire/storage/WireStorageEntry;", "myWireSuspendedAfter", "getMyWireSuspendedAfter", "()Ljava/time/Duration;", "myProcessWiresInterval", "getMyProcessWiresInterval", "myUnconfirmedMessagesBufferSizeLimitBytes", "getMyUnconfirmedMessagesBufferSizeLimitBytes", "()J", "wiresCount", "", "getWiresCount", "()I", "containsWire", "clientId", "getWire", "getWireOrNull", "filterWires", "", "filter", "Lkotlin/Function2;", "getTransportOrNull", "Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;", "getOrCreate", "creator", "Lkotlin/Function0;", "getAllWires", "addWire", "", "wireEntry", "terminateWire", "terminateWireIfExists", "suspendWire", "processSuspendedWire", "processWireBufferSize", "processAllSuspendedWires", "processAllWiresBufferSize", "resetWireSuspend", "getIsWireExpired", "isWireExpired", "launchWireExpirationCheck", "delay", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/time/Duration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "launchWireBufferSizeCheck", "launchWireCheck", "moniker", "", "action", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/time/Duration;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "bytesToMb", "bytes", "bufferSizePrettyPrint", "bytesSize", "Companion", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nWireStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WireStorage.kt\ncom/intellij/platform/split/connection/protocol/wire/storage/WireStorage\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,558:1\n60#2,3:559\n64#2:563\n60#2,5:585\n60#2,5:590\n60#2,5:595\n60#2,5:600\n60#2,5:605\n60#2,5:610\n60#2,5:617\n60#2,5:624\n60#2,5:629\n60#2,5:634\n1#3:562\n1#3:582\n540#4:564\n525#4,6:565\n139#5,10:571\n221#5:581\n222#5:583\n149#5:584\n1915#6,2:615\n1915#6,2:622\n*S KotlinDebug\n*F\n+ 1 WireStorage.kt\ncom/intellij/platform/split/connection/protocol/wire/storage/WireStorage\n*L\n98#1:559,3\n98#1:563\n359#1:585,5\n364#1:590,5\n378#1:595,5\n381#1:600,5\n388#1:605,5\n409#1:610,5\n416#1:617,5\n477#1:624,5\n480#1:629,5\n497#1:634,5\n177#1:582\n175#1:564\n175#1:565,6\n177#1:571,10\n177#1:581\n177#1:583\n177#1:584\n410#1:615,2\n417#1:622,2\n*E\n"})
public final class WireStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    private final boolean scheduleWireBufferSizeCheck;
    private final boolean scheduleWireExpirationCheck;
    @Nullable
    private final java.time.Duration wireSuspendedAfter;
    @Nullable
    private final java.time.Duration processWiresInterval;
    @Nullable
    private final Long unconfirmedMessagesBufferSizeLimitBytes;
    @NotNull
    private final ConcurrentHashMap<ClientId, WireStorageEntry> myClientToWireMap;
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public WireStorage(@NotNull Lifetime lifetime, boolean scheduleWireBufferSizeCheck, boolean scheduleWireExpirationCheck, @Nullable java.time.Duration wireSuspendedAfter, @Nullable java.time.Duration processWiresInterval, @Nullable Long unconfirmedMessagesBufferSizeLimitBytes) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.scheduleWireBufferSizeCheck = scheduleWireBufferSizeCheck;
        this.scheduleWireExpirationCheck = scheduleWireExpirationCheck;
        this.wireSuspendedAfter = wireSuspendedAfter;
        this.processWiresInterval = processWiresInterval;
        this.unconfirmedMessagesBufferSizeLimitBytes = unconfirmedMessagesBufferSizeLimitBytes;
        this.myClientToWireMap = new ConcurrentHashMap();
        Logger $this$debug_u24default$iv = WireStorageKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            String string;
            String string2;
            String string3;
            java.time.Duration it;
            boolean bl;
            boolean bl2;
            Logger logger = $this$debug_u24default$iv;
            boolean bl3 = false;
            boolean bl4 = this.scheduleWireBufferSizeCheck;
            boolean bl5 = this.scheduleWireExpirationCheck;
            java.time.Duration duration = this.wireSuspendedAfter;
            if (duration != null) {
                java.time.Duration duration2 = duration;
                bl2 = bl5;
                bl = bl4;
                boolean bl6 = false;
                string3 = Formats.formatDuration((java.time.Duration)it);
                bl4 = bl;
                bl5 = bl2;
                string2 = string3;
            } else {
                string2 = null;
            }
            java.time.Duration duration3 = this.processWiresInterval;
            if (duration3 != null) {
                it = duration3;
                string3 = string2;
                bl2 = bl5;
                bl = bl4;
                boolean bl7 = false;
                String string4 = Formats.formatDuration((java.time.Duration)it);
                bl4 = bl;
                bl5 = bl2;
                string2 = string3;
                string = string4;
            } else {
                string = null;
            }
            logger.debug("Init Wire Storage with parameters:\n* scheduleWireBufferSizeCheck: " + bl4 + "\n* scheduleWireExpirationCheck: " + bl5 + "\n* wireSuspendedAfter: " + string2 + "\n* processWiresInterval: " + string + "\n* unconfirmedMessagesBufferSizeLimitBytes: " + this.unconfirmedMessagesBufferSizeLimitBytes, t$iv);
        }
        this.lifetime.onTermination(WireStorage::_init_$lambda$1);
        if (this.scheduleWireExpirationCheck) {
            this.getMyWireSuspendedAfter();
            LifetimeCoroutineUtilKt.launch$default((Lifetime)this.lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ WireStorage this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.launchWireExpirationCheck(this.this$0.lifetime, this.this$0.getMyProcessWiresInterval(), (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        if (this.scheduleWireBufferSizeCheck) {
            LifetimeCoroutineUtilKt.launch$default((Lifetime)this.lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ WireStorage this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.launchWireBufferSizeCheck(this.this$0.lifetime, this.this$0.getMyProcessWiresInterval(), (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public /* synthetic */ WireStorage(Lifetime lifetime, boolean bl, boolean bl2, java.time.Duration duration, java.time.Duration duration2, Long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            duration = null;
        }
        if ((n & 0x10) != 0) {
            duration2 = null;
        }
        if ((n & 0x20) != 0) {
            l = null;
        }
        this(lifetime, bl, bl2, duration, duration2, l);
    }

    private final java.time.Duration getMyWireSuspendedAfter() {
        java.time.Duration duration = this.wireSuspendedAfter;
        if (duration == null) {
            boolean bl = false;
            String string = "Wire suspend after value is not set. Please provide wireSuspendAfter parameter for WireStorage when enable wire expiration check";
            throw new IllegalStateException(string.toString());
        }
        return duration;
    }

    private final java.time.Duration getMyProcessWiresInterval() {
        java.time.Duration duration = this.processWiresInterval;
        if (duration == null) {
            long l = ((Duration)ConnectionConfiguration.INSTANCE.getUnconfirmedMessagesBufferOverflowCheckDelay().getValue()).unbox-impl();
            int n = Duration.getNanosecondsComponent-impl((long)l);
            long l2 = Duration.getInWholeSeconds-impl((long)l);
            java.time.Duration duration2 = java.time.Duration.ofSeconds(l2, n);
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"toComponents-impl(...)");
        }
        return duration;
    }

    private final long getMyUnconfirmedMessagesBufferSizeLimitBytes() {
        Long l = this.unconfirmedMessagesBufferSizeLimitBytes;
        return l != null ? l.longValue() : ((Number)ConnectionConfiguration.INSTANCE.getUnconfirmedMessagesBufferSizeLimitBytes().getValue()).longValue();
    }

    public final int getWiresCount() {
        return this.myClientToWireMap.size();
    }

    public final boolean containsWire(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        boolean exists = this.myClientToWireMap.containsKey(clientId);
        WireStorageKt.access$getLogger$p().info("Wire for client (id: " + clientId.getValue() + ") exists in storage: " + exists);
        return exists;
    }

    @NotNull
    public final WireStorageEntry getWire(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        WireStorageEntry wire = this.getWireOrNull(clientId);
        if (wire == null) {
            throw new IllegalStateException("Wire for client (id: " + clientId.getValue() + ") does not exist in wire storage. Please make sure you provide a valid Client ID.");
        }
        return wire;
    }

    @Nullable
    public final WireStorageEntry getWireOrNull(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        WireStorageEntry wireEntry = this.myClientToWireMap.get(clientId);
        WireStorageKt.access$getLogger$p().info("Got wire for client (id: " + clientId.getValue() + ") from wire storage: " + wireEntry);
        return wireEntry;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WireStorageEntry> filterWires(@NotNull Function2<? super ClientId, ? super WireStorageEntry, Boolean> filter2) {
        void $this$mapNotNullTo$iv$iv;
        Map $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Map $this$filter$iv = this.myClientToWireMap;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((Boolean)filter2.invoke(entry.getKey(), entry.getValue())).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$mapNotNull$iv = destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            WireStorageEntry it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            if ((WireStorageEntry)it.getValue() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final TransportInfo getTransportOrNull(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        WireStorageKt.access$getLogger$p().info("Get active transport for client (id: " + clientId.getValue() + ")");
        WireStorageEntry wireEntry = this.getWireOrNull(clientId);
        if (wireEntry == null) {
            WireStorageKt.access$getLogger$p().info("Unable to find transport for client (id: " + clientId.getValue() + "). No wire entry found.");
            return null;
        }
        TransportInfo transportInfo = wireEntry.getWireInfo().getWire().getTransportInfo();
        if (transportInfo == null) {
            WireStorageKt.access$getLogger$p().info("Active transport is not found for wire (id: " + wireEntry.getWireInfo().getWire().getName() + ")");
            return null;
        }
        WireStorageKt.access$getLogger$p().info("Found active transport for client (id: " + clientId.getValue() + ")");
        return transportInfo;
    }

    @NotNull
    public final WireStorageEntry getOrCreate(@NotNull ClientId clientId, @NotNull Function0<WireStorageEntry> creator) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        WireStorageEntry wireEntry = this.getWireOrNull(clientId);
        if (wireEntry != null) {
            return wireEntry;
        }
        WireStorageEntry newWireEntry = (WireStorageEntry)creator.invoke();
        this.addWire(clientId, newWireEntry);
        return newWireEntry;
    }

    @NotNull
    public final List<WireStorageEntry> getAllWires() {
        Collection<WireStorageEntry> collection = this.myClientToWireMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    public final void addWire(@NotNull ClientId clientId, @NotNull WireStorageEntry wireEntry) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)wireEntry, (String)"wireEntry");
        String wireId = wireEntry.getWireInfo().getWire().getId();
        WireStorageKt.access$getLogger$p().info("Try to add a new wire (id: " + wireId + ") for client (id: '" + clientId.getValue() + ") to wire storage.");
        wireEntry.getWireInfo().getWireLifetimeDef().getLifetime().bracketIfAlive(() -> WireStorage.addWire$lambda$0(this, clientId, wireEntry), () -> WireStorage.addWire$lambda$1(this, clientId));
        WireStorageKt.access$getLogger$p().info("Wire (id: " + wireId + ") for client (id: '" + clientId.getValue() + ") was successfully added into wire storage.");
    }

    public final void terminateWire(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        WireStorageKt.access$getLogger$p().info("Terminate wire for client (id: " + clientId.getValue() + ")");
        WireStorageEntry wireEntry = this.getWire(clientId);
        this.terminateWire(wireEntry);
    }

    private final void terminateWire(WireStorageEntry wireEntry) {
        WireInfo wireInfo = wireEntry.getWireInfo();
        WireStorageEntry currentWireEntry = this.myClientToWireMap.remove(wireInfo.getWire().getClientId());
        WireStorageKt.access$getLogger$p().info("Terminate wire (id: " + wireInfo.getWire().getId() + ") for client (id: " + wireEntry.getWireInfo().getWire().getClientId().getValue() + ")");
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        LifetimeCoroutineUtilKt.launch$default((Lifetime)this.lifetime, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(wireInfo, currentWireEntry, null){
            int label;
            final /* synthetic */ WireInfo $wireInfo;
            final /* synthetic */ WireStorageEntry $currentWireEntry;
            {
                this.$wireInfo = $wireInfo;
                this.$currentWireEntry = $currentWireEntry;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        WireStorageKt.access$getLogger$p().info("Terminate wire immediately (id: " + this.$wireInfo.getWire().getId() + ")");
                        this.label = 1;
                        Object object2 = CoroutinesKt.writeIntentReadAction(() -> terminateWire.1.invokeSuspend$lambda$0(this.$currentWireEntry), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(WireStorageEntry $currentWireEntry) {
                block0: {
                    Object object = $currentWireEntry;
                    if (object == null || (object = ((WireStorageEntry)object).getWireInfo()) == null || (object = ((WireInfo)object).getWireLifetimeDef()) == null) break block0;
                    LifetimeDefinition.terminate$default((LifetimeDefinition)object, (boolean)false, (int)1, null);
                }
                return Unit.INSTANCE;
            }
        }), (int)2, null);
    }

    public final void terminateWireIfExists(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        WireStorageKt.access$getLogger$p().info("Terminate wire if exists for client (id: " + clientId.getValue() + ")");
        WireStorageEntry wireEntry = this.getWireOrNull(clientId);
        WireStorageKt.access$getLogger$p().info("Wire for client (id: " + clientId.getValue() + ") exists: " + (wireEntry != null));
        if (wireEntry == null) {
            return;
        }
        this.terminateWire(wireEntry);
    }

    public final void suspendWire(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        WireStorageKt.access$getLogger$p().info("Suspend Wire for client (id: " + clientId.getValue() + ") in the Storage.");
        WireStorageEntry wireEntry = this.getWireOrNull(clientId);
        if (wireEntry == null) {
            WireStorageKt.access$getLogger$p().info("Wire for client (id: " + clientId.getValue() + ") does not exist in the Storage");
            return;
        }
        this.suspendWire(wireEntry);
    }

    public final void suspendWire(@NotNull WireStorageEntry wireEntry) {
        Intrinsics.checkNotNullParameter((Object)wireEntry, (String)"wireEntry");
        long now = System.currentTimeMillis();
        WireStorageKt.access$getLogger$p().info("Set suspend time for wire (id: " + wireEntry.getWireInfo().getWire().getId() + ") entry to value: " + dateFormatter.withZone(ZoneId.systemDefault()).format(Instant.ofEpochMilli(now)) + " (Epoch: " + now + ")");
        wireEntry.setSuspendStartTimeEpochMs(now);
    }

    private final void processSuspendedWire(WireStorageEntry wireEntry) {
        Logger logger;
        String wireId = wireEntry.getWireInfo().getWire().getId();
        Logger $this$debug_u24default$iv = WireStorageKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Check wire '" + wireId + "' for suspended state.", t$iv);
        }
        boolean isExpired = this.isWireExpired(wireEntry);
        if (!isExpired) {
            Logger $this$debug_u24default$iv2 = WireStorageKt.access$getLogger$p();
            Throwable t$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("Wire (id: " + wireId + ") is not expired.", t$iv2);
            }
            return;
        }
        WireStorageKt.access$getLogger$p().info("Wire (id: " + wireId + ") stays suspended more then " + Formats.formatDuration((java.time.Duration)this.getMyWireSuspendedAfter()) + ". Terminate wire lifetime and remove from wire storage.");
        this.terminateWire(wireEntry);
    }

    private final void processWireBufferSize(WireStorageEntry wireEntry) {
        Logger logger;
        String wireId = wireEntry.getWireInfo().getWire().getId();
        Logger $this$debug_u24default$iv = WireStorageKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Wire (id: " + wireId + ") Check wire buffer size.", t$iv);
        }
        if (wireEntry.getSuspendStartTimeEpochMs() == null) {
            $this$debug_u24default$iv = WireStorageKt.access$getLogger$p();
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Wire (id: " + wireId + ") Skip check for buffer size wire is not suspended ", t$iv);
            }
            return;
        }
        long currentBufferSize = wireEntry.getWireInfo().getWire().getUnconfirmedMessagesBufferSize();
        if (currentBufferSize <= this.getMyUnconfirmedMessagesBufferSizeLimitBytes()) {
            Logger $this$debug_u24default$iv2 = WireStorageKt.access$getLogger$p();
            Throwable t$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("Wire (id: " + wireId + ") is not exceeded size limit. Current buffer size: " + this.bufferSizePrettyPrint(currentBufferSize) + ". Limit: " + this.bufferSizePrettyPrint(this.getMyUnconfirmedMessagesBufferSizeLimitBytes()), t$iv2);
            }
            return;
        }
        WireStorageKt.access$getLogger$p().info("Wire (id: " + wireId + ") exceeded buffer size limit. Current buffer size: " + this.bufferSizePrettyPrint(currentBufferSize) + ". Limit: " + this.bufferSizePrettyPrint(this.getMyUnconfirmedMessagesBufferSizeLimitBytes()));
        this.terminateWire(wireEntry);
    }

    public final void processAllSuspendedWires() {
        Logger $this$debug_u24default$iv = WireStorageKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Check wires suspended state (wires: " + this.myClientToWireMap.size() + ")", t$iv);
        }
        Collection<WireStorageEntry> collection = this.myClientToWireMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WireStorageEntry wireEntry = (WireStorageEntry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)wireEntry);
            this.processSuspendedWire(wireEntry);
        }
    }

    private final void processAllWiresBufferSize() {
        Logger $this$debug_u24default$iv = WireStorageKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Check wires buffer size (wires: " + this.myClientToWireMap.size() + ")", t$iv);
        }
        Collection<WireStorageEntry> collection = this.myClientToWireMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WireStorageEntry wireEntry = (WireStorageEntry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)wireEntry);
            this.processWireBufferSize(wireEntry);
        }
    }

    public final void resetWireSuspend(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        WireStorageEntry wireStorageEntry = this.getWireOrNull(clientId);
        if (wireStorageEntry == null) {
            return;
        }
        WireStorageEntry wireEntry = wireStorageEntry;
        this.resetWireSuspend(wireEntry);
    }

    public final void resetWireSuspend(@NotNull WireStorageEntry wireEntry) {
        Intrinsics.checkNotNullParameter((Object)wireEntry, (String)"wireEntry");
        WireStorageKt.access$getLogger$p().info("Wire (id: " + wireEntry.getWireInfo().getWire().getId() + ") reset suspended state.");
        wireEntry.setSuspendStartTimeEpochMs(null);
    }

    @TestOnly
    public final boolean getIsWireExpired(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        return this.isWireExpired(clientId);
    }

    private final boolean isWireExpired(ClientId clientId) {
        WireStorageEntry wireEntry = this.getWire(clientId);
        return this.isWireExpired(wireEntry);
    }

    private final boolean isWireExpired(WireStorageEntry wireEntry) {
        Logger logger;
        String wireId = wireEntry.getWireInfo().getWire().getId();
        Logger $this$debug_u24default$iv = WireStorageKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Wire (id: " + wireId + ") Check if wire expired.", t$iv);
        }
        if (this.wireSuspendedAfter == null) {
            $this$debug_u24default$iv = WireStorageKt.access$getLogger$p();
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Wire (id: " + wireId + ") Wire Suspend timeout is not set. Wire cannot expire.", t$iv);
            }
            return false;
        }
        Long wireSuspendStartTimeEpochMs = wireEntry.getSuspendStartTimeEpochMs();
        if (wireSuspendStartTimeEpochMs == null) {
            WireStorageKt.access$getLogger$p().info("Wire (id: " + wireId + ") is active. Suspend time is not set.");
            return false;
        }
        long expirationTimeEpochMs = wireSuspendStartTimeEpochMs + this.getMyWireSuspendedAfter().toMillis();
        long now = System.currentTimeMillis();
        if (now < expirationTimeEpochMs) {
            long leftMs = expirationTimeEpochMs - now;
            long leftS = leftMs / (long)1000;
            long leftMin = leftS / (long)60;
            Logger $this$debug_u24default$iv2 = WireStorageKt.access$getLogger$p();
            Throwable t$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("Wire (id: " + wireId + ") is not expired: " + leftS + " sec (" + leftMin + " min) left", t$iv2);
            }
            return false;
        }
        WireStorageKt.access$getLogger$p().info("Wire (id: " + wireId + ") has already expired: " + wireEntry);
        return true;
    }

    private final Object launchWireExpirationCheck(Lifetime lifetime, java.time.Duration delay, Continuation<? super Unit> $completion) {
        Object object = this.launchWireCheck(lifetime, delay, "Check Wire Expiration", (Function0<Unit>)((Function0)() -> WireStorage.launchWireExpirationCheck$lambda$0(this)), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    static /* synthetic */ Object launchWireExpirationCheck$default(WireStorage wireStorage, Lifetime lifetime, java.time.Duration duration, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            duration = wireStorage.getMyProcessWiresInterval();
        }
        return wireStorage.launchWireExpirationCheck(lifetime, duration, (Continuation<? super Unit>)continuation);
    }

    private final Object launchWireBufferSizeCheck(Lifetime lifetime, java.time.Duration delay, Continuation<? super Unit> $completion) {
        Object object = this.launchWireCheck(lifetime, delay, "Check Wire Buffer Size", (Function0<Unit>)((Function0)() -> WireStorage.launchWireBufferSizeCheck$lambda$0(this)), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    static /* synthetic */ Object launchWireBufferSizeCheck$default(WireStorage wireStorage, Lifetime lifetime, java.time.Duration duration, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            duration = wireStorage.getMyProcessWiresInterval();
        }
        return wireStorage.launchWireBufferSizeCheck(lifetime, duration, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object launchWireCheck(Lifetime lifetime, java.time.Duration delay, String moniker, Function0<Unit> action, Continuation<? super Unit> $completion) {
        if (!($completion instanceof launchWireCheck.1)) ** GOTO lbl-1000
        var8_6 = $completion;
        if ((var8_6.label & -2147483648) != 0) {
            var8_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ WireStorage this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WireStorage.access$launchWireCheck(this.this$0, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                WireStorageKt.access$getLogger$p().info("Start Wire Storage check: " + moniker + ", delay: " + delay);
lbl13:
                // 4 sources

                while (RLifetimeKt.isAlive((Lifetime)lifetime) && JobKt.isActive((CoroutineContext)$continuation.getContext())) {
                    action.invoke();
                    $continuation.L$0 = lifetime;
                    $continuation.L$1 = delay;
                    $continuation.L$2 = moniker;
                    $continuation.L$3 = action;
                    $continuation.label = 1;
                    v0 = TimeKt.delay((java.time.Duration)delay, (Continuation)$continuation);
                    if (v0 != var9_8) continue;
                    return var9_8;
                }
                break;
            }
            case 1: {
                action = (Function0)$continuation.L$3;
                moniker = (String)$continuation.L$2;
                delay = (java.time.Duration)$continuation.L$1;
                lifetime = (Lifetime)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl13
                }
                catch (CancellationException t) {
                    throw t;
                }
                catch (Throwable t) {
                    WireStorageKt.access$getLogger$p().error("Error in Wire Storage processing wire check: " + moniker + ". Error: " + t.getMessage(), t);
                    ** GOTO lbl13
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    private final String bufferSizePrettyPrint(long bytesSize) {
        return bytesSize + " bytes (" + this.bytesToMb(bytesSize) + " MB)";
    }

    private static final Unit _init_$lambda$1() {
        WireStorageKt.access$getLogger$p().info("Terminate Wire Storage lifetime");
        return Unit.INSTANCE;
    }

    private static final Unit addWire$lambda$0(WireStorage this$0, ClientId $clientId, WireStorageEntry $wireEntry) {
        WireStorageEntry existingWire = this$0.myClientToWireMap.putIfAbsent($clientId, $wireEntry);
        if (existingWire != null) {
            throw new IllegalStateException("Unable to add wire. Client (id: " + $clientId.getValue() + ") already have wire registered (id: " + existingWire.getWireInfo().getWire().getId() + ").");
        }
        return Unit.INSTANCE;
    }

    private static final Unit addWire$lambda$1(WireStorage this$0, ClientId $clientId) {
        this$0.myClientToWireMap.remove($clientId);
        WireStorageKt.access$getLogger$p().info("Wire for client (id: " + $clientId.getValue() + ") was successfully removed");
        return Unit.INSTANCE;
    }

    private static final Unit launchWireExpirationCheck$lambda$0(WireStorage this$0) {
        this$0.processAllSuspendedWires();
        return Unit.INSTANCE;
    }

    private static final Unit launchWireBufferSizeCheck$lambda$0(WireStorage this$0) {
        this$0.processAllWiresBufferSize();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$launchWireCheck(WireStorage $this, Lifetime lifetime, java.time.Duration delay, String moniker, Function0 action, Continuation $completion) {
        return $this.launchWireCheck(lifetime, delay, moniker, (Function0<Unit>)action, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/split/connection/protocol/wire/storage/WireStorage$Companion;", "", "<init>", "()V", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDateFormatter$intellij_platform_split_connection", "()Ljava/time/format/DateTimeFormatter;", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        public final DateTimeFormatter getDateFormatter$intellij_platform_split_connection() {
            return dateFormatter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

