/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.widget;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.platform.split.connection.protocol.ICodeWithMeWire;
import com.intellij.platform.split.connection.widget.WireStatsPresentationUtil;
import com.intellij.platform.split.connection.widget.WireStatsRegistryService;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ConcurrentList;
import com.jetbrains.rd.swing.RdSwingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\u0016\u0010\u001d\u001a\u00020\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0003J\b\u0010!\u001a\u00020\u0019H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\b\u001a\u00060\tR\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/platform/split/connection/widget/WireStatsStatusBarWidget;", "Lcom/intellij/openapi/wm/CustomStatusBarWidget;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myLifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "myComponent", "Lcom/intellij/platform/split/connection/widget/WireStatsStatusBarWidget$WireStatsTextPanel;", "getMyComponent", "()Lcom/intellij/platform/split/connection/widget/WireStatsStatusBarWidget$WireStatsTextPanel;", "myComponent$delegate", "Lkotlin/Lazy;", "future", "Ljava/util/concurrent/Future;", "ID", "", "getComponent", "Ljavax/swing/JComponent;", "wireStatsService", "Lcom/intellij/platform/split/connection/widget/WireStatsRegistryService;", "getWireStatsService", "()Lcom/intellij/platform/split/connection/widget/WireStatsRegistryService;", "install", "", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "update", "getWidgetText", "wires", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/platform/split/connection/protocol/ICodeWithMeWire;", "dispose", "WireStatsTextPanel", "intellij.platform.split.connection"})
public final class WireStatsStatusBarWidget
implements CustomStatusBarWidget {
    @NotNull
    private final LifetimeDefinition myLifetimeDef;
    @NotNull
    private final Lazy myComponent$delegate;
    @Nullable
    private Future<?> future;

    public WireStatsStatusBarWidget(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.myLifetimeDef = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)).createNested();
        this.myComponent$delegate = LazyKt.lazy(() -> WireStatsStatusBarWidget.myComponent_delegate$lambda$0(this));
    }

    private final WireStatsTextPanel getMyComponent() {
        Lazy lazy = this.myComponent$delegate;
        return (WireStatsTextPanel)((Object)lazy.getValue());
    }

    @NotNull
    public String ID() {
        return "CwmWireStatsWidgetFactory";
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)((Object)this.getMyComponent());
    }

    private final WireStatsRegistryService getWireStatsService() {
        return WireStatsRegistryService.Companion.getInstance();
    }

    public void install(@NotNull StatusBar statusBar) {
        Intrinsics.checkNotNullParameter((Object)statusBar, (String)"statusBar");
        this.future = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(this::update, 1L, 1L, TimeUnit.SECONDS);
        RdSwingKt.mouseClicked((JComponent)((JComponent)((Object)this.getMyComponent()))).advise((Lifetime)this.myLifetimeDef, arg_0 -> WireStatsStatusBarWidget.install$lambda$0(this, arg_0));
    }

    private final void update() {
        ConcurrentList<ICodeWithMeWire> wires = this.getWireStatsService().getRegisteredWires();
        this.getMyComponent().setVisible(!((Collection)wires).isEmpty());
        this.getMyComponent().setText(this.getWidgetText(wires));
    }

    @NlsSafe
    private final String getWidgetText(ConcurrentList<ICodeWithMeWire> wires) {
        return WireStatsPresentationUtil.INSTANCE.getWireStatsPresentableText(wires);
    }

    public void dispose() {
        block0: {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.myLifetimeDef, (boolean)false, (int)1, null);
            Future<?> future = this.future;
            if (future == null) break block0;
            future.cancel(true);
        }
    }

    private static final WireStatsTextPanel myComponent_delegate$lambda$0(WireStatsStatusBarWidget this$0) {
        return this$0.new WireStatsTextPanel();
    }

    private static final Unit install$lambda$0(WireStatsStatusBarWidget this$0, MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this$0.getWireStatsService().showUi();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/split/connection/widget/WireStatsStatusBarWidget$WireStatsTextPanel;", "Lcom/intellij/openapi/wm/impl/status/TextPanel;", "<init>", "(Lcom/intellij/platform/split/connection/widget/WireStatsStatusBarWidget;)V", "textForPreferredSize", "", "getTextForPreferredSize", "()Ljava/lang/String;", "intellij.platform.split.connection"})
    private final class WireStatsTextPanel
    extends TextPanel {
        public WireStatsTextPanel() {
            super(null, 1, null);
            this.setTextAlignment(1.0f);
        }

        @NotNull
        protected String getTextForPreferredSize() {
            return switch (WireStatsStatusBarWidget.this.getWireStatsService().getRegisteredWires().size()) {
                case 0 -> "";
                case 1 -> "(D) \u2191999.99 MB/s / \u2193999.99 MB/s";
                default -> "(9) \u2191999.99 MB/s / \u2193999.99 MB/s";
            };
        }
    }
}

