/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.backend.flat;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.microservices.endpoints.EndpointsDocumentationProvider;
import com.intellij.microservices.endpoints.EndpointsElementItem;
import com.intellij.microservices.endpoints.EndpointsModuleEntity;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.presentation.EndpointMethodPresentation;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiElement;
import java.awt.Color;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004BE\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n\u0012\u0006\u0010\u000b\u001a\u00028\u0000\u0012\u0006\u0010\f\u001a\u00028\u0001\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010C\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010=H\u0016J\u000e\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GJ\u0018\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020\u00022\u0006\u0010K\u001a\u00020LJ=\u0010H\u001a\u0004\u0018\u00010I\"\b\b\u0002\u0010M*\u00020\u00022\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010J\u001a\u0002HM2\u0006\u0010K\u001a\u00020LH\u0002\u00a2\u0006\u0002\u0010NJ\b\u0010O\u001a\u0004\u0018\u00010PJ\b\u0010Q\u001a\u0004\u0018\u00010\u0002J\b\u0010R\u001a\u0004\u0018\u00010PJ\b\u0010S\u001a\u0004\u0018\u00010TJ\u0010\u0010U\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\n\u0010V\u001a\u00020#H\u0096\u0080\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u000b\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\f\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020#0'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0015\u0010*\u001a\u0004\u0018\u00010+\u00a2\u0006\n\n\u0002\u0010.\u001a\u0004\b,\u0010-R\u0011\u0010/\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010%R\u0011\u00101\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010%R\u0013\u00103\u001a\u0004\u0018\u000104\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u001dR\u0013\u00108\u001a\u0004\u0018\u000109\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R#\u0010<\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010=8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u0010B\u001a\u0004\b?\u0010@\u00a8\u0006W"}, d2={"Lcom/intellij/microservices/backend/flat/FlatEndpointItem;", "G", "", "E", "Lcom/intellij/microservices/endpoints/EndpointsElementItem;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;", "provider", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "group", "endpoint", "presentation", "Lcom/intellij/navigation/ItemPresentation;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;Lcom/intellij/microservices/endpoints/EndpointsProvider;Ljava/lang/Object;Ljava/lang/Object;Lcom/intellij/navigation/ItemPresentation;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getModule", "()Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;", "getProvider", "()Lcom/intellij/microservices/endpoints/EndpointsProvider;", "getGroup", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getEndpoint", "isValid", "", "()Z", "frameworkPresentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getFrameworkPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "methodPresentation", "", "getMethodPresentation", "()Ljava/lang/String;", "methods", "", "getMethods", "()Ljava/util/List;", "methodOrder", "", "getMethodOrder", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "presentableText", "getPresentableText", "locationString", "getLocationString", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "isDeprecated", "fileBgColor", "Ljava/awt/Color;", "getFileBgColor", "()Ljava/awt/Color;", "urlTargetInfo", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "getUrlTargetInfo", "()Ljava/lang/Iterable;", "urlTargetInfo$delegate", "Lkotlin/Lazy;", "getUrlTargetInfos", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getEndpointDocumentation", "Ljavax/swing/JComponent;", "request", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "D", "(Lcom/intellij/microservices/endpoints/EndpointsProvider;Ljava/lang/Object;Lcom/intellij/openapi/Disposable;)Ljavax/swing/JComponent;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "prepareDocumentationRequest", "getNavigationElement", "getContainingFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasDeprecatedAttributes", "toString", "intellij.microservices.backend"})
@SourceDebugExtension(value={"SMAP\nEndpointsListItems.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndpointsListItems.kt\ncom/intellij/microservices/backend/flat/FlatEndpointItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,103:1\n1#2:104\n18#3:105\n*S KotlinDebug\n*F\n+ 1 EndpointsListItems.kt\ncom/intellij/microservices/backend/flat/FlatEndpointItem\n*L\n95#1:105\n*E\n"})
public final class FlatEndpointItem<G, E>
implements EndpointsElementItem<G, E> {
    @NotNull
    private final Project project;
    @Nullable
    private final EndpointsModuleEntity module;
    @NotNull
    private final EndpointsProvider<G, E> provider;
    @NotNull
    private final G group;
    @NotNull
    private final E endpoint;
    @Nullable
    private final String methodPresentation;
    @NotNull
    private final List<String> methods;
    @Nullable
    private final Integer methodOrder;
    @NotNull
    private final String presentableText;
    @NotNull
    private final String locationString;
    @Nullable
    private final Icon icon;
    private final boolean isDeprecated;
    @Nullable
    private final Color fileBgColor;
    @NotNull
    private final Lazy urlTargetInfo$delegate;

    /*
     * WARNING - void declaration
     */
    public FlatEndpointItem(@NotNull Project project, @Nullable EndpointsModuleEntity module, @NotNull EndpointsProvider<G, E> provider, @NotNull G group, @NotNull E endpoint, @NotNull ItemPresentation presentation) {
        Color color;
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        this.project = project;
        this.module = module;
        this.provider = provider;
        this.group = group;
        this.endpoint = endpoint;
        EndpointMethodPresentation endpointMethodPresentation = presentation instanceof EndpointMethodPresentation ? (EndpointMethodPresentation)presentation : null;
        this.methodPresentation = endpointMethodPresentation != null ? endpointMethodPresentation.getEndpointMethodPresentation() : null;
        Object object = presentation instanceof EndpointMethodPresentation ? (EndpointMethodPresentation)presentation : null;
        if (object == null || (object = object.getEndpointMethods()) == null) {
            object = CollectionsKt.emptyList();
        }
        this.methods = object;
        EndpointMethodPresentation endpointMethodPresentation2 = presentation instanceof EndpointMethodPresentation ? (EndpointMethodPresentation)presentation : null;
        this.methodOrder = endpointMethodPresentation2 != null ? Integer.valueOf(endpointMethodPresentation2.getEndpointMethodOrder()) : null;
        String string2 = presentation.getPresentableText();
        if (string2 == null) {
            string2 = this.presentableText = " ";
        }
        if ((string = presentation.getLocationString()) == null) {
            string = "";
        }
        this.locationString = string;
        this.icon = presentation.getIcon(false);
        this.isDeprecated = this.hasDeprecatedAttributes(presentation);
        FlatEndpointItem flatEndpointItem = this;
        VirtualFile virtualFile = this.getContainingFile();
        if (virtualFile != null) {
            void it;
            VirtualFile virtualFile2 = virtualFile;
            FlatEndpointItem flatEndpointItem2 = flatEndpointItem;
            boolean bl = false;
            color = VfsPresentationUtil.getFileBackgroundColor((Project)this.project, (VirtualFile)it);
            flatEndpointItem = flatEndpointItem2;
        } else {
            color = null;
        }
        flatEndpointItem.fileBgColor = color;
        this.urlTargetInfo$delegate = LazyKt.lazy(() -> FlatEndpointItem.urlTargetInfo_delegate$lambda$0(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public EndpointsModuleEntity getModule() {
        return this.module;
    }

    @NotNull
    public EndpointsProvider<G, E> getProvider() {
        return this.provider;
    }

    @NotNull
    public G getGroup() {
        return this.group;
    }

    @NotNull
    public E getEndpoint() {
        return this.endpoint;
    }

    public boolean isValid() {
        return this.getProvider().isValidEndpoint(this.getGroup(), this.getEndpoint());
    }

    @NotNull
    public final FrameworkPresentation getFrameworkPresentation() {
        return this.getProvider().getPresentation();
    }

    @Nullable
    public final String getMethodPresentation() {
        return this.methodPresentation;
    }

    @NotNull
    public final List<String> getMethods() {
        return this.methods;
    }

    @Nullable
    public final Integer getMethodOrder() {
        return this.methodOrder;
    }

    @NotNull
    public final String getPresentableText() {
        return this.presentableText;
    }

    @NotNull
    public final String getLocationString() {
        return this.locationString;
    }

    @Nullable
    public final Icon getIcon() {
        return this.icon;
    }

    public final boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Nullable
    public final Color getFileBgColor() {
        return this.fileBgColor;
    }

    @Nullable
    public final Iterable<UrlTargetInfo> getUrlTargetInfo() {
        Lazy lazy = this.urlTargetInfo$delegate;
        return (Iterable)lazy.getValue();
    }

    @Nullable
    public Iterable<UrlTargetInfo> getUrlTargetInfos() {
        return this.getUrlTargetInfo();
    }

    public final void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.lazy(EndpointsProvider.URL_TARGET_INFO, () -> FlatEndpointItem.uiDataSnapshot$lambda$0(this));
        this.getProvider().uiDataSnapshot(sink, this.getGroup(), this.getEndpoint());
    }

    @Nullable
    public final JComponent getEndpointDocumentation(@NotNull Object request2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        return this.getEndpointDocumentation(this.getProvider(), request2, parentDisposable);
    }

    private final <D> JComponent getEndpointDocumentation(EndpointsProvider<G, E> provider, D request2, Disposable parentDisposable) {
        EndpointsDocumentationProvider endpointsDocumentationProvider = provider instanceof EndpointsDocumentationProvider ? (EndpointsDocumentationProvider)provider : null;
        return endpointsDocumentationProvider != null ? endpointsDocumentationProvider.getEndpointDocumentation(request2, parentDisposable) : null;
    }

    @Nullable
    public final PsiElement getDocumentationElement() {
        return this.getProvider().getDocumentationElement(this.getGroup(), this.getEndpoint());
    }

    @Nullable
    public final Object prepareDocumentationRequest() {
        if (this.getProvider() instanceof EndpointsDocumentationProvider) {
            return ((EndpointsDocumentationProvider)this.getProvider()).prepareDocumentationRequest(this.getGroup(), this.getEndpoint());
        }
        return null;
    }

    @Nullable
    public final PsiElement getNavigationElement() {
        if (!this.isValid()) {
            return null;
        }
        return this.getProvider().getNavigationElement(this.getGroup(), this.getEndpoint());
    }

    @Nullable
    public final VirtualFile getContainingFile() {
        PsiElement navigationElement = this.getNavigationElement();
        PsiElement psiElement = navigationElement;
        return psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : null;
    }

    private final boolean hasDeprecatedAttributes(ItemPresentation presentation) {
        PresentationData presentationData;
        ItemPresentation $this$asSafely$iv = presentation;
        boolean $i$f$asSafely = false;
        ItemPresentation itemPresentation = $this$asSafely$iv;
        if (!(itemPresentation instanceof PresentationData)) {
            itemPresentation = null;
        }
        TextAttributesKey textAttributesKey = (presentationData = (PresentationData)itemPresentation) != null ? presentationData.getTextAttributesKey() : null;
        Object object = CodeInsightColors.DEPRECATED_ATTRIBUTES;
        if (object == null) {
            object = false;
        }
        return Intrinsics.areEqual((Object)textAttributesKey, (Object)object);
    }

    @NotNull
    public String toString() {
        return this.presentableText + " " + this.methodPresentation;
    }

    private static final Iterable urlTargetInfo_delegate$lambda$0(FlatEndpointItem this$0) {
        if (!this$0.isValid()) {
            return null;
        }
        EndpointsProvider endpointsProvider = this$0.getProvider();
        EndpointsUrlTargetProvider endpointsUrlTargetProvider = endpointsProvider instanceof EndpointsUrlTargetProvider ? (EndpointsUrlTargetProvider)endpointsProvider : null;
        return endpointsUrlTargetProvider != null ? endpointsUrlTargetProvider.getUrlTargetInfo(this$0.getGroup(), this$0.getEndpoint()) : null;
    }

    private static final Iterable uiDataSnapshot$lambda$0(FlatEndpointItem this$0) {
        return this$0.getUrlTargetInfo();
    }
}

