/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.library;

import com.intellij.javascript.library.JSLibraryVersions$isTS6OrGreater$;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.languageService.TypeScriptServiceProvider;
import com.intellij.lang.typescript.lsp.TypeScriptGoLspService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.SemVer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0007J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0003J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0003J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/library/JSLibraryVersions;", "", "<init>", "()V", "TYPE_SCRIPT_VERSION_6_0", "Lcom/intellij/util/text/SemVer;", "getLibraryVersion", "context", "Lcom/intellij/psi/PsiElement;", "libraryName", "", "isTS6OrGreater", "", "project", "Lcom/intellij/openapi/project/Project;", "configFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "contextFile", "getTypeScriptVersion", "getLibraryVersionNoCache", "virtualFile", "findVersionInNodeModules", "intellij.javascript.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJSLibraryVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLibraryVersions.kt\ncom/intellij/javascript/library/JSLibraryVersions\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n479#2:121\n1#3:122\n*S KotlinDebug\n*F\n+ 1 JSLibraryVersions.kt\ncom/intellij/javascript/library/JSLibraryVersions\n*L\n46#1:121\n*E\n"})
public final class JSLibraryVersions {
    @NotNull
    public static final JSLibraryVersions INSTANCE = new JSLibraryVersions();
    @NotNull
    private static final SemVer TYPE_SCRIPT_VERSION_6_0 = new SemVer("6", 6, 0, 0);

    private JSLibraryVersions() {
    }

    @JvmStatic
    @Nullable
    public static final SemVer getLibraryVersion(@NotNull PsiElement context2, @NotNull String libraryName) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        return (SemVer)CachedValuesManager.getCachedValue((PsiElement)context2, () -> JSLibraryVersions.getLibraryVersion$lambda$0(context2, libraryName));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean isTS6OrGreater(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull VirtualFile contextFile) {
        SemVer versionFromService;
        JSLanguageService tsService;
        block3: {
            JSLanguageService jSLanguageService;
            void $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
            Sequence sequence = CollectionsKt.asSequence((Iterable)JSLanguageServiceProvider.Companion.getProviders(project));
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)isTS6OrGreater$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            for (TypeScriptServiceProvider it : sequence2) {
                boolean bl = false;
                TypeScriptService typeScriptService = it.getService(contextFile);
                if (typeScriptService == null) continue;
                jSLanguageService = typeScriptService;
                break block3;
            }
            jSLanguageService = tsService = null;
        }
        if (tsService instanceof TypeScriptGoLspService) {
            return true;
        }
        JSLanguageService jSLanguageService = tsService;
        Object object = versionFromService = jSLanguageService != null ? jSLanguageService.getServiceVersion() : null;
        if (versionFromService != null) {
            return versionFromService.isGreaterOrEqualThan(TYPE_SCRIPT_VERSION_6_0);
        }
        SemVer semVer = INSTANCE.getTypeScriptVersion(project, configFile, contextFile);
        return semVer != null ? semVer.isGreaterOrEqualThan(TYPE_SCRIPT_VERSION_6_0) : false;
    }

    private final SemVer getTypeScriptVersion(Project project, VirtualFile configFile, VirtualFile contextFile) {
        ConcurrentHashMap cache = (ConcurrentHashMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> JSLibraryVersions.getTypeScriptVersion$lambda$0(project));
        SemVer cachedVersion = (SemVer)cache.get(configFile);
        if (cachedVersion != null) {
            return cachedVersion;
        }
        SemVer semVer = JSLibraryVersions.getLibraryVersionNoCache(project, contextFile, "typescript");
        if (semVer == null) {
            return null;
        }
        SemVer versionNoCache = semVer;
        Intrinsics.checkNotNull((Object)cache);
        ((Map)cache).put(configFile, versionNoCache);
        return versionNoCache;
    }

    @JvmStatic
    private static final SemVer getLibraryVersionNoCache(Project project, VirtualFile virtualFile, String libraryName) {
        VirtualFile virtualFile2 = PackageJsonUtil.findUpPackageJson(virtualFile);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile packageJson = virtualFile2;
        SemVer version2 = INSTANCE.findVersionInNodeModules(project, packageJson, libraryName);
        if (version2 != null) {
            return version2;
        }
        PackageJsonData.PackageJsonDependencyEntry packageJsonDependencyEntry = PackageJsonData.getOrCreate(packageJson).getAllDependencyEntries().get(libraryName);
        return packageJsonDependencyEntry != null ? packageJsonDependencyEntry.parseVersion() : null;
    }

    @JvmStatic
    private static final SemVer getLibraryVersionNoCache(PsiElement context2, String libraryName) {
        VirtualFile virtualFile;
        Project project;
        block3: {
            block2: {
                Project project2 = context2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                project = project2;
                PsiFile psiFile = JSResolveUtil.getOriginalFile((PsiElement)context2);
                if (psiFile == null) break block2;
                PsiFile it = psiFile;
                boolean bl = false;
                virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)it));
                if (virtualFile != null) break block3;
            }
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return JSLibraryVersions.getLibraryVersionNoCache(project, virtualFile2, libraryName);
    }

    private final SemVer findVersionInNodeModules(Project project, VirtualFile virtualFile, String libraryName) {
        InstalledPackageVersion installedPackageVersion = new NodeInstalledPackageFinder(project, virtualFile).findInstalledPackage(libraryName);
        return installedPackageVersion != null ? installedPackageVersion.getVersion() : null;
    }

    private static final CachedValueProvider.Result getLibraryVersion$lambda$0(PsiElement $context, String $libraryName) {
        Object[] objectArray = new Object[]{PackageJsonFileManager.getInstance($context.getProject()).getModificationTracker(), NodeModulesDirectoryManager.getInstance($context.getProject()).getNodeModulesDirChangeTracker()};
        return CachedValueProvider.Result.create((Object)JSLibraryVersions.getLibraryVersionNoCache($context, $libraryName), (Object[])objectArray);
    }

    private static final CachedValueProvider.Result getTypeScriptVersion$lambda$0(Project $project) {
        Object[] objectArray = new Object[]{TypeScriptCompilerSettings.Companion.getSettings($project), PackageJsonFileManager.getInstance($project).getModificationTracker(), NodeModulesDirectoryManager.getInstance($project).getNodeModulesDirChangeTracker()};
        return CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])objectArray);
    }
}

