/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.typescript.modules.TypeScriptNodeSearchProcessor;
import com.intellij.lang.typescript.modules.TypeScriptTypingsMapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleDirectorySearchProcessor
implements JSDirectorySearchProcessor {
    public static final NodeModuleDirectorySearchProcessor PROCESSOR = new NodeModuleDirectorySearchProcessor();
    public static final String INDEX_NAME = "index";
    private final String[] myExtensionsWithDot;

    public NodeModuleDirectorySearchProcessor() {
        this(NodeModuleSearchUtil.FILE_EXTENSIONS_IN_ORDER);
    }

    public NodeModuleDirectorySearchProcessor(String @NotNull [] extensionsWithDot) {
        if (extensionsWithDot == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(0);
        }
        this.myExtensionsWithDot = extensionsWithDot;
    }

    @NotNull
    public static NodeModuleDirectorySearchProcessor forElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(1);
        }
        NodeModuleDirectorySearchProcessor nodeModuleDirectorySearchProcessor = DialectDetector.isTypeScript((PsiElement)element2) ? TypeScriptNodeSearchProcessor.TS_PROCESSOR : PROCESSOR;
        if (nodeModuleDirectorySearchProcessor == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(2);
        }
        return nodeModuleDirectorySearchProcessor;
    }

    @NotNull
    public static NodeModuleDirectorySearchProcessor forElement(@NotNull PsiElement element2, String @NotNull [] extensionsWithDot) {
        if (element2 == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(3);
        }
        if (extensionsWithDot == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(4);
        }
        return DialectDetector.isTypeScript((PsiElement)element2) ? new TypeScriptNodeSearchProcessor(extensionsWithDot) : new NodeModuleDirectorySearchProcessor(extensionsWithDot);
    }

    @Nullable
    public ResolvedModuleInfo doResolveModule(@Nullable VirtualFile moduleSourceRoot, @NotNull ModuleType type2, @NotNull VirtualFile baseDir, @NotNull String requiredModuleName, boolean resolveDirectory, boolean respectPackageJson) {
        String[] extensions;
        String childNamePrefix;
        VirtualFile parentDir;
        int lastSlashInd;
        if (type2 == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(5);
        }
        if (baseDir == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(6);
        }
        if (requiredModuleName == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(7);
        }
        if ((lastSlashInd = (requiredModuleName = FileUtil.toSystemIndependentName((String)requiredModuleName)).lastIndexOf(47)) == -1) {
            parentDir = baseDir;
            childNamePrefix = requiredModuleName;
        } else {
            if (lastSlashInd == 0 || lastSlashInd == requiredModuleName.length() - 1) {
                return null;
            }
            parentDir = baseDir.findFileByRelativePath(requiredModuleName.substring(0, lastSlashInd));
            if (parentDir == null) {
                return null;
            }
            childNamePrefix = requiredModuleName.substring(lastSlashInd + 1);
        }
        boolean directory = false;
        VirtualFile fileOrDir = null;
        if (resolveDirectory && (fileOrDir = childNamePrefix.equals("..") ? parentDir.getParent() : (childNamePrefix.equals(".") ? parentDir : parentDir.findChild(childNamePrefix))) != null && fileOrDir.isValid()) {
            if (fileOrDir.isDirectory()) {
                directory = true;
            } else {
                if (moduleSourceRoot != null) {
                    return new ResolvedModuleInfo(moduleSourceRoot, fileOrDir, type2);
                }
                return new ResolvedModuleInfo(fileOrDir, type2);
            }
        }
        for (String ext : extensions = this.getExtensions()) {
            VirtualFile childFile = parentDir.findChild(childNamePrefix + ext);
            if (childFile == null || !NodeModuleSearchUtil.isFile(childFile)) continue;
            if (moduleSourceRoot != null) {
                return new ResolvedModuleInfo(moduleSourceRoot, childFile, type2);
            }
            return new ResolvedModuleInfo(childFile, type2);
        }
        if (directory) {
            return this.loadDirectory(moduleSourceRoot, fileOrDir, type2, respectPackageJson);
        }
        return null;
    }

    protected String[] getExtensions() {
        return this.myExtensionsWithDot;
    }

    @Nullable
    public VirtualFile loadDirectory(@NotNull VirtualFile directory) {
        ResolvedModuleInfo info;
        if (directory == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(8);
        }
        return (info = this.loadDirectory(null, directory, ModuleType.NODE_MODULES_DIR, true)) != null ? info.getModuleMainFile() : null;
    }

    @Nullable
    public ResolvedModuleInfo loadDirectory(@Nullable VirtualFile moduleSourceRoot, @NotNull VirtualFile dir, @NotNull ModuleType type2, boolean respectPackageJson) {
        PackageJsonData data2;
        String main;
        VirtualFile packageJson;
        if (dir == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(9);
        }
        if (type2 == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(10);
        }
        if (moduleSourceRoot == null) {
            moduleSourceRoot = dir;
        }
        if (respectPackageJson && (packageJson = PackageJsonUtil.findChildPackageJsonFile(dir)) != null && (main = this.findPathInPackageJson(data2 = PackageJsonData.getOrCreate(packageJson), packageJson)) != null) {
            ResolvedModuleInfo resolvedMain;
            String subPath = StringUtil.trimEnd((String)main, (char)'/');
            boolean resolveDirectory = INDEX_NAME.equals(subPath);
            ResolvedModuleInfo info = this.doResolveModule(moduleSourceRoot, type2, dir, INDEX_NAME, resolveDirectory, false);
            if (!data2.hasTypingsProperty() && info != null && "index.d.ts".equals(info.getModuleMainFile().getName())) {
                return info;
            }
            if (!INDEX_NAME.equals(subPath) && (resolvedMain = this.doResolveModule(moduleSourceRoot, type2, dir, subPath, true, false)) != null) {
                return resolvedMain;
            }
            return info;
        }
        return this.doResolveModule(moduleSourceRoot, type2, dir, INDEX_NAME, false, false);
    }

    protected String findPathInPackageJson(@NotNull PackageJsonData data2, @NotNull VirtualFile packageJson) {
        if (data2 == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(11);
        }
        if (packageJson == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(12);
        }
        String defaultMain = data2.getDefaultMain();
        if (data2.hasTypings()) {
            return TypeScriptTypingsMapper.substituteTypings(defaultMain, packageJson, data2, false);
        }
        return defaultMain;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionsWithDot";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredModuleName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
            case 2: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doResolveModule";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadDirectory";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findPathInPackageJson";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

