/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.highlighting.HighlightReporterKt;
import com.intellij.lang.javascript.highlighting.JSHighlightVisitorBase;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingVisitor;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSSemanticHighlightVisitor;", "Lcom/intellij/lang/javascript/highlighting/JSHighlightVisitorBase;", "<init>", "()V", "suitableForFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "createElementVisitor", "Lcom/intellij/lang/javascript/psi/JSElementVisitor;", "owner", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "clone", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "Companion", "intellij.javascript.analysis.impl"})
public final class JSSemanticHighlightVisitor
extends JSHighlightVisitorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean suitableForFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return Registry.Companion.is("javascript.semantic.highlighting.as.visitor") && super.suitableForFile(psiFile);
    }

    @Override
    @NotNull
    public JSElementVisitor createElementVisitor(@NotNull PsiElement owner, @NotNull HighlightInfoHolder holder) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        JSHighlighter highlighter = Companion.getHighlighterForElement(owner);
        return new JSSemanticHighlightingVisitor(highlighter, HighlightReporterKt.createHighlightReporter(holder));
    }

    @NotNull
    public HighlightVisitor clone() {
        return new JSSemanticHighlightVisitor();
    }

    @JvmStatic
    @NotNull
    public static final JSHighlighter getHighlighterForElement(@NotNull PsiElement element2) {
        return Companion.getHighlighterForElement(element2);
    }

    @JvmStatic
    @NotNull
    public static final JSHighlighter getHighlighterForLanguage(@NotNull Language language) {
        return Companion.getHighlighterForLanguage(language);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSSemanticHighlightVisitor$Companion;", "", "<init>", "()V", "getHighlighterForElement", "Lcom/intellij/lang/javascript/highlighting/JSHighlighter;", "element", "Lcom/intellij/psi/PsiElement;", "getHighlighterForLanguage", "language", "Lcom/intellij/lang/Language;", "intellij.javascript.analysis.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JSHighlighter getHighlighterForElement(@NotNull PsiElement element2) {
            JSHighlighter jSHighlighter;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Language dialect = DialectDetector.languageOfElement((PsiElement)element2);
            if (dialect instanceof JSLanguageDialect) {
                SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, null, null);
                Intrinsics.checkNotNull((Object)syntaxHighlighter, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.highlighting.JSHighlighter");
                jSHighlighter = (JSHighlighter)syntaxHighlighter;
            } else {
                jSHighlighter = new JSHighlighter(JavascriptLanguage.INSTANCE.getOptionHolder());
            }
            return jSHighlighter;
        }

        @JvmStatic
        @NotNull
        public final JSHighlighter getHighlighterForLanguage(@NotNull Language language) {
            JSHighlighter jSHighlighter;
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            if (language instanceof JSLanguageDialect) {
                SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, null, null);
                Intrinsics.checkNotNull((Object)syntaxHighlighter, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.highlighting.JSHighlighter");
                jSHighlighter = (JSHighlighter)syntaxHighlighter;
            } else {
                jSHighlighter = new JSHighlighter(JavascriptLanguage.INSTANCE.getOptionHolder());
            }
            return jSHighlighter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

