/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J5\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J1\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010\u0016\u001a\u00020\t*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/refactoring/JSExportSpecifierAliasRenameProcessor;", "Lcom/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor;", "<init>", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "renameElement", "", "newName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "filterUsages", "quote", "", "([Lcom/intellij/usageView/UsageInfo;Ljava/lang/String;C)[Lcom/intellij/usageView/UsageInfo;", "convertToAliased", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportSpecifier;", "aliasName", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSExportSpecifierAliasRenameProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSExportSpecifierAliasRenameProcessor.kt\ncom/intellij/lang/javascript/refactoring/JSExportSpecifierAliasRenameProcessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,102:1\n3938#2:103\n4474#2,2:104\n37#3,2:106\n*S KotlinDebug\n*F\n+ 1 JSExportSpecifierAliasRenameProcessor.kt\ncom/intellij/lang/javascript/refactoring/JSExportSpecifierAliasRenameProcessor\n*L\n52#1:103\n52#1:104,2\n63#1:106,2\n*E\n"})
public final class JSExportSpecifierAliasRenameProcessor
extends JSDefaultRenameProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return super.canProcessElement(element2) && element2 instanceof ES6ExportSpecifierAlias;
    }

    @Override
    public void renameElement(@NotNull PsiElement element2, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) {
        UsageInfo[] usageInfoArray;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        if (!BasicJavascriptNamesValidator.isIdentifierName((CharSequence)newName)) {
            PsiElement psiElement = ((ES6ExportSpecifierAlias)element2).getNameIdentifier();
            char quote = psiElement != null ? psiElement.getText().charAt(0) : JSCodeStyleSettings.getQuoteChar((PsiElement)element2);
            usageInfoArray = this.filterUsages(usages, newName, quote);
        } else {
            usageInfoArray = usages;
        }
        UsageInfo[] usages2 = usageInfoArray;
        super.renameElement(element2, newName, usages2, listener2);
    }

    /*
     * WARNING - void declaration
     */
    private final UsageInfo[] filterUsages(UsageInfo[] usages, String newName, char quote) {
        void $this$toTypedArray$iv;
        void $this$filterTo$iv$iv;
        Object $this$filter$iv = usages;
        boolean $i$f$filter = false;
        UsageInfo[] usageInfoArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            PsiElement element2;
            void element$iv$iv;
            void usage = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl2 = false;
            PsiReference psiReference = usage.getReference();
            Object object = element2 = psiReference != null ? psiReference.getElement() : null;
            if (!(element2 instanceof ES6ImportExportSpecifier)) {
                bl = false;
            } else if (((ES6ImportExportSpecifier)element2).isNameCanBeString()) {
                bl = true;
            } else {
                this.convertToAliased((ES6ImportExportSpecifier)element2, newName, quote);
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    private final void convertToAliased(ES6ImportExportSpecifier $this$convertToAliased, String aliasName, char quote) {
        ASTNode aSTNode;
        ES6ImportExportDeclaration eS6ImportExportDeclaration = $this$convertToAliased.getDeclaration();
        if (eS6ImportExportDeclaration == null) {
            return;
        }
        ES6ImportExportDeclaration declaration = eS6ImportExportDeclaration;
        ES6FromClause eS6FromClause = declaration.getFromClause();
        String importExportSuffix = "{" + quote + aliasName + quote + " as " + $this$convertToAliased.getName() + "} from " + (eS6FromClause != null ? eS6FromClause.getText() : null);
        ES6ImportExportSpecifier eS6ImportExportSpecifier = $this$convertToAliased;
        if (eS6ImportExportSpecifier instanceof ES6ImportSpecifier) {
            ASTNode aSTNode2 = JSChangeUtil.createStatementFromTextWithContext((String)("import " + importExportSuffix), (PsiElement)declaration.getParent());
            if (aSTNode2 == null) {
                throw new IllegalStateException("Failed to create new import node".toString());
            }
            ASTNode importNode = aSTNode2;
            ASTNode aSTNode3 = importNode.findChildByType(JSElementTypes.NAMED_IMPORTS);
            if (aSTNode3 == null) {
                throw new IllegalStateException("Failed to find named imports node".toString());
            }
            ASTNode namedPart = aSTNode3;
            aSTNode = namedPart.findChildByType(JSElementTypes.IMPORT_SPECIFIER);
            if (aSTNode == null) {
                throw new IllegalStateException("Failed to find import specifier node".toString());
            }
        } else if (eS6ImportExportSpecifier instanceof ES6ExportSpecifier) {
            ASTNode aSTNode4 = JSChangeUtil.createStatementFromTextWithContext((String)("export " + importExportSuffix), (PsiElement)declaration.getParent());
            if (aSTNode4 == null) {
                throw new IllegalStateException("Failed to create new export node".toString());
            }
            ASTNode exportNode = aSTNode4;
            aSTNode = exportNode.findChildByType(JSElementTypes.EXPORT_SPECIFIER);
            if (aSTNode == null) {
                throw new IllegalStateException("Failed to find export specifier node".toString());
            }
        } else {
            throw new IllegalStateException(("Unexpected ES6ImportExportSpecifier subtype: " + $this$convertToAliased.getClass().getName()).toString());
        }
        ASTNode newImportExportSpecifierNode = aSTNode;
        $this$convertToAliased.replace(newImportExportSpecifierNode.getPsi());
    }
}

