/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptIDEGetProjectsInfoResponse;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003\u0010\u0011\u0012B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\fH\u0016R&\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0007R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/typescript/compiler/ui/TypeScriptServiceStructure;", "Lcom/intellij/ui/treeStructure/SimpleTreeStructure;", "structures", "", "", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptIDEGetProjectsInfoResponse$IDEGetProjectsInfo;", "<init>", "(Ljava/util/Map;)V", "getStructures", "()Ljava/util/Map;", "setStructures", "rootNode", "Lcom/intellij/ui/treeStructure/SimpleNode;", "getRootNode", "()Lcom/intellij/ui/treeStructure/SimpleNode;", "getRootElement", "NamedNode", "ProjectNode", "FileNode", "intellij.javascript.backend"})
public final class TypeScriptServiceStructure
extends SimpleTreeStructure {
    @NotNull
    private Map<String, ? extends TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsInfo> structures;
    @NotNull
    private final SimpleNode rootNode;

    public TypeScriptServiceStructure(@NotNull Map<String, ? extends TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsInfo> structures) {
        Intrinsics.checkNotNullParameter(structures, (String)"structures");
        this.structures = structures;
        this.rootNode = new SimpleNode(this){
            final /* synthetic */ TypeScriptServiceStructure this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public SimpleNode[] getChildren() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.this$0.getStructures().keySet();
                TypeScriptServiceStructure typeScriptServiceStructure = this.this$0;
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(typeScriptServiceStructure.new ProjectNode((String)it));
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new SimpleNode[0]);
            }
        };
    }

    @NotNull
    public final Map<String, TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsInfo> getStructures() {
        return this.structures;
    }

    public final void setStructures(@NotNull Map<String, ? extends TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsInfo> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.structures = map;
    }

    @NotNull
    public final SimpleNode getRootNode() {
        return this.rootNode;
    }

    @NotNull
    public SimpleNode getRootElement() {
        return this.rootNode;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/typescript/compiler/ui/TypeScriptServiceStructure$FileNode;", "Lcom/intellij/ui/treeStructure/SimpleNode;", "fileInfo", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptIDEGetProjectsInfoResponse$IDEGetProjectsFileInfo;", "<init>", "(Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptIDEGetProjectsInfoResponse$IDEGetProjectsFileInfo;)V", "getFileInfo", "()Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptIDEGetProjectsInfoResponse$IDEGetProjectsFileInfo;", "getChildren", "", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "getEqualityObjects", "", "()[Ljava/lang/Object;", "getName", "", "intellij.javascript.backend"})
    public static final class FileNode
    extends SimpleNode {
        @NotNull
        private final TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsFileInfo fileInfo;

        public FileNode(@NotNull TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsFileInfo fileInfo) {
            Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
            this.fileInfo = fileInfo;
        }

        @NotNull
        public final TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsFileInfo getFileInfo() {
            return this.fileInfo;
        }

        @NotNull
        public SimpleNode[] getChildren() {
            return new SimpleNode[0];
        }

        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)this.fileInfo.fileName, (String)"fileName");
            return objectArray;
        }

        @NotNull
        public String getName() {
            String string = this.fileInfo.fileName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileName");
            return string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/typescript/compiler/ui/TypeScriptServiceStructure$NamedNode;", "Lcom/intellij/ui/treeStructure/SimpleNode;", "nodeName", "", "childrenNodes", "", "<init>", "(Ljava/lang/String;[Lcom/intellij/ui/treeStructure/SimpleNode;)V", "[Lcom/intellij/ui/treeStructure/SimpleNode;", "getChildren", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "getEqualityObjects", "", "()[Ljava/lang/Object;", "getName", "intellij.javascript.backend"})
    public static final class NamedNode
    extends SimpleNode {
        @NotNull
        private final String nodeName;
        @NotNull
        private final SimpleNode[] childrenNodes;

        public NamedNode(@NotNull String nodeName, @NotNull SimpleNode[] childrenNodes) {
            Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
            Intrinsics.checkNotNullParameter((Object)childrenNodes, (String)"childrenNodes");
            this.nodeName = nodeName;
            this.childrenNodes = childrenNodes;
        }

        @NotNull
        public SimpleNode[] getChildren() {
            return this.childrenNodes;
        }

        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray = new Object[]{this.nodeName};
            return objectArray;
        }

        @NotNull
        public String getName() {
            return this.nodeName + " [files: " + this.childrenNodes.length + "]";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/typescript/compiler/ui/TypeScriptServiceStructure$ProjectNode;", "Lcom/intellij/ui/treeStructure/SimpleNode;", "projectName", "", "<init>", "(Lcom/intellij/lang/typescript/compiler/ui/TypeScriptServiceStructure;Ljava/lang/String;)V", "getProjectName", "()Ljava/lang/String;", "getChildren", "", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "getEqualityObjects", "", "()[Ljava/lang/Object;", "getName", "intellij.javascript.backend"})
    @SourceDebugExtension(value={"SMAP\nTypeScriptServiceStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptServiceStructure.kt\ncom/intellij/lang/typescript/compiler/ui/TypeScriptServiceStructure$ProjectNode\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,81:1\n37#2,2:82\n37#2,2:84\n37#2,2:86\n37#2,2:88\n37#2,2:90\n37#2,2:92\n*S KotlinDebug\n*F\n+ 1 TypeScriptServiceStructure.kt\ncom/intellij/lang/typescript/compiler/ui/TypeScriptServiceStructure$ProjectNode\n*L\n50#1:82,2\n51#1:84,2\n52#1:86,2\n53#1:88,2\n54#1:90,2\n56#1:92,2\n*E\n"})
    public final class ProjectNode
    extends SimpleNode {
        @NotNull
        private final String projectName;

        public ProjectNode(String projectName) {
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            this.projectName = projectName;
        }

        @NotNull
        public final String getProjectName() {
            return this.projectName;
        }

        @NotNull
        public SimpleNode[] getChildren() {
            Collection thisCollection$iv;
            boolean $i$f$toTypedArray;
            TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsInfo iDEGetProjectsInfo = TypeScriptServiceStructure.this.getStructures().get(this.projectName);
            if (iDEGetProjectsInfo == null) {
                return new SimpleNode[0];
            }
            TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsInfo projectStructure = iDEGetProjectsInfo;
            List openFiles = new ArrayList();
            List nodeModulesFiles = new ArrayList();
            List projectFiles = new ArrayList();
            List externalFiles = new ArrayList();
            List libs = new ArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)projectStructure.fileInfos, (String)"fileInfos");
            for (TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsFileInfo fileInfo : projectStructure.fileInfos) {
                boolean bl;
                Intrinsics.checkNotNull((Object)fileInfo);
                FileNode node = new FileNode(fileInfo);
                if (fileInfo.isOpen) {
                    bl = openFiles.add(node);
                    continue;
                }
                if (fileInfo.isExternal) {
                    bl = externalFiles.add(node);
                    continue;
                }
                String string = VfsUtil.extractFileName((String)fileInfo.fileName);
                Intrinsics.checkNotNull((Object)string);
                if (StringsKt.startsWith$default((String)string, (String)"lib.", (boolean)false, (int)2, null)) {
                    bl = libs.add(node);
                    continue;
                }
                String string2 = fileInfo.fileName;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileName");
                bl = StringsKt.contains$default((CharSequence)string2, (CharSequence)"node_modules", (boolean)false, (int)2, null) ? nodeModulesFiles.add(node) : projectFiles.add(node);
            }
            List resultChildren = new ArrayList();
            if (!((Collection)openFiles).isEmpty()) {
                Collection $this$toTypedArray$iv = openFiles;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                resultChildren.add(new NamedNode("Open files", thisCollection$iv.toArray(new SimpleNode[0])));
            }
            if (!((Collection)projectFiles).isEmpty()) {
                Collection $this$toTypedArray$iv = projectFiles;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                resultChildren.add(new NamedNode("Project files", thisCollection$iv.toArray(new SimpleNode[0])));
            }
            if (!((Collection)externalFiles).isEmpty()) {
                Collection $this$toTypedArray$iv = externalFiles;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                resultChildren.add(new NamedNode("External files", thisCollection$iv.toArray(new SimpleNode[0])));
            }
            if (!((Collection)nodeModulesFiles).isEmpty()) {
                Collection $this$toTypedArray$iv = nodeModulesFiles;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                resultChildren.add(new NamedNode("Node modules", thisCollection$iv.toArray(new SimpleNode[0])));
            }
            if (!((Collection)libs).isEmpty()) {
                Collection $this$toTypedArray$iv = libs;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                resultChildren.add(new NamedNode("Libs", thisCollection$iv.toArray(new SimpleNode[0])));
            }
            Collection $this$toTypedArray$iv = resultChildren;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new SimpleNode[0]);
        }

        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray = new Object[]{this.projectName};
            return objectArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getName() {
            Integer n;
            TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsFileInfo[] iDEGetProjectsFileInfoArray = TypeScriptServiceStructure.this.getStructures().get(this.projectName);
            if (iDEGetProjectsFileInfoArray != null) {
                iDEGetProjectsFileInfoArray = iDEGetProjectsFileInfoArray.fileInfos;
                if (iDEGetProjectsFileInfoArray.fileInfos != null) {
                    n = iDEGetProjectsFileInfoArray.length;
                    return this.projectName + " [files: " + n + "]";
                }
            }
            n = null;
            return this.projectName + " [files: " + n + "]";
        }
    }
}

