/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSKeywordElementType;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.structuralsearch.JSMatchingStrategy;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.WordOptimizer;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import org.jetbrains.annotations.NotNull;

final class JSCompilingVisitor
extends JSRecursiveWalkingElementVisitor {
    private final GlobalCompilingVisitor myCompilingVisitor;
    private PsiElement myTopLevelElement = null;

    JSCompilingVisitor(GlobalCompilingVisitor compilingVisitor) {
        this.myCompilingVisitor = compilingVisitor;
    }

    public void compile(PsiElement[] topLevelElements) {
        JSWordOptimizer optimizer = new JSWordOptimizer();
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        if (pattern.getStrategy() == null) {
            MatchOptions options = this.myCompilingVisitor.getContext().getOptions();
            pattern.setStrategy((MatchingStrategy)new JSMatchingStrategy(options.getDialect()));
        }
        for (PsiElement element2 : topLevelElements) {
            if (topLevelElements.length == 1) {
                this.myTopLevelElement = element2;
            }
            if (element2 instanceof PsiWhiteSpace) {
                this.myCompilingVisitor.addLexicalNode(element2);
                continue;
            }
            element2.accept((PsiElementVisitor)this);
            element2.accept((PsiElementVisitor)optimizer);
            pattern.setHandler(element2, (MatchingHandler)new TopLevelMatchingHandler(pattern.getHandler(element2)));
        }
    }

    public void visitElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSCompilingVisitor.$$$reportNull$$$0(0);
        }
        if (!(element2.getLanguage() instanceof JSLanguageDialect) && StructuralSearchUtil.compileForeignElement((PsiElement)element2, (GlobalCompilingVisitor)this.myCompilingVisitor)) {
            return;
        }
        if (!(element2 instanceof JSReferenceListMember) && !(element2 instanceof JSEmbeddedContent)) {
            this.myCompilingVisitor.handle(element2);
        }
        super.visitElement(element2);
    }

    public void visitJSVariable(@NotNull JSVariable variable) {
        if (variable == null) {
            JSCompilingVisitor.$$$reportNull$$$0(1);
        }
        super.visitJSVariable(variable);
        MatchingHandler handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)variable);
        GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof JSVariable || e instanceof JSFunctionExpression);
    }

    public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
        if (function == null) {
            JSCompilingVisitor.$$$reportNull$$$0(2);
        }
        super.visitJSFunctionDeclaration(function);
        MatchingHandler handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)function);
        GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof JSFunction);
    }

    public void visitJSClass(@NotNull JSClass aClass) {
        if (aClass == null) {
            JSCompilingVisitor.$$$reportNull$$$0(3);
        }
        super.visitJSClass(aClass);
        MatchingHandler handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)aClass);
        GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof JSClass);
    }

    public void visitJSReferenceExpression(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSCompilingVisitor.$$$reportNull$$$0(4);
        }
        super.visitJSReferenceExpression(expression);
        PsiElement parent = expression.getParent();
        if (parent instanceof JSClass || parent instanceof JSTypeDeclaration || parent instanceof JSExpressionStatement && parent != this.myTopLevelElement) {
            return;
        }
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        if (pattern.isRealTypedVar((PsiElement)expression)) {
            MatchingHandler handler = pattern.getHandler((PsiElement)expression);
            if (expression.getParent() instanceof JSFunctionExpression) {
                GlobalCompilingVisitor.setFilter((MatchingHandler)handler, element2 -> true);
            } else {
                GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof JSExpression || JSCompilingVisitor.isLeafToken(e, JSTokenTypes.IDENTIFIER));
            }
        }
    }

    public void visitJSLiteralExpression(@NotNull JSLiteralExpression expression) {
        MatchingHandler handler;
        if (expression == null) {
            JSCompilingVisitor.$$$reportNull$$$0(5);
        }
        super.visitJSLiteralExpression(expression);
        if ((expression.isQuotedLiteral() || expression.isRegExpLiteral()) && (handler = this.myCompilingVisitor.processPatternStringWithFragments(expression.getText(), GlobalCompilingVisitor.OccurenceKind.LITERAL)) != null) {
            expression.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
        }
    }

    public void visitJSExpressionStatement(@NotNull JSExpressionStatement statement) {
        if (statement == null) {
            JSCompilingVisitor.$$$reportNull$$$0(6);
        }
        super.visitJSExpressionStatement(statement);
        JSExpression expression = statement.getExpression();
        MatchingHandler statementHandler = new MatchingHandler(this){

            public boolean match(PsiElement patternNode, PsiElement matchedNode, @NotNull MatchContext context2) {
                if (context2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return context2.getMatcher().match((PsiElement)((JSExpressionStatement)patternNode).getExpression(), matchedNode);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/structuralsearch/JSCompilingVisitor$1", "match"));
            }
        };
        if (this.myTopLevelElement == statement && expression != null && statement.getFirstChild() == statement.getLastChild()) {
            this.myCompilingVisitor.setHandler((PsiElement)statement, statementHandler);
            GlobalCompilingVisitor.setFilter((MatchingHandler)statementHandler, e -> e instanceof JSExpression || JSCompilingVisitor.isLeafToken(e, JSTokenTypes.IDENTIFIER));
        } else {
            MatchingHandler handler;
            CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
            if (expression instanceof JSReferenceExpression && pattern.isRealTypedVar((PsiElement)statement) && (handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)statement)) instanceof SubstitutionHandler) {
                ((SubstitutionHandler)handler).setMatchHandler(statementHandler);
                handler.setFilter(e -> e instanceof JSStatement && !(e.getParent() instanceof JSFunction) && !(e instanceof JSPackageStatement) || e instanceof PsiComment && e.getParent() instanceof JSBlockStatement);
            }
        }
    }

    public void visitJSAttributeNameValuePair(@NotNull JSAttributeNameValuePair attributeNameValuePair) {
        if (attributeNameValuePair == null) {
            JSCompilingVisitor.$$$reportNull$$$0(7);
        }
        super.visitJSAttributeNameValuePair(attributeNameValuePair);
        ASTNode valueNode = attributeNameValuePair.getValueNode();
        if (valueNode == null) {
            return;
        }
        String text = valueNode.getText();
        if (!StringUtil.isQuotedString((String)text)) {
            return;
        }
        MatchingHandler handler = this.myCompilingVisitor.processPatternStringWithFragments(text, GlobalCompilingVisitor.OccurenceKind.LITERAL);
        if (handler != null) {
            valueNode.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
        }
    }

    public void visitJSAttributeList(@NotNull JSAttributeList list) {
        if (list == null) {
            JSCompilingVisitor.$$$reportNull$$$0(8);
        }
        super.visitJSAttributeList(list);
        if (this.myTopLevelElement != list) {
            return;
        }
        JSAttribute[] attributes = list.getAttributes();
        if (attributes.length != 1) {
            return;
        }
        JSAttribute attribute = attributes[0];
        if (!attribute.getText().equals(list.getText())) {
            return;
        }
        MatchingHandler handler = new MatchingHandler(this){

            public boolean match(PsiElement patternNode, PsiElement matchedNode, @NotNull MatchContext context2) {
                if (context2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return super.match(patternNode, matchedNode, context2) && context2.getMatcher().match((PsiElement)((JSAttributeList)patternNode).getAttributes()[0], matchedNode);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/structuralsearch/JSCompilingVisitor$2", "match"));
            }
        };
        this.myCompilingVisitor.setHandler((PsiElement)list, handler);
        handler.setFilter(element2 -> element2 instanceof JSAttribute);
    }

    private static boolean isLeafToken(PsiElement element2, IElementType elementType) {
        return element2 instanceof LeafElement && ((LeafElement)element2).getElementType() == elementType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeNameValuePair";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/JSCompilingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSReferenceExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSLiteralExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSExpressionStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSAttributeNameValuePair";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSAttributeList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class JSWordOptimizer
    extends JSRecursiveWalkingElementVisitor
    implements WordOptimizer {
        private JSWordOptimizer() {
        }

        public void visitElement(@NotNull PsiElement element2) {
            if (element2 == null) {
                JSWordOptimizer.$$$reportNull$$$0(0);
            }
            super.visitElement(element2);
            if (element2 instanceof LeafPsiElement) {
                IElementType elementType = ((LeafPsiElement)element2).getElementType();
                if (elementType instanceof JSKeywordElementType) {
                    JSKeywordElementType keywordElementType = (JSKeywordElementType)elementType;
                    String keyword = keywordElementType.getKeyword();
                    if ("function".equals(keyword)) {
                        return;
                    }
                    if ("var".equals(keyword)) {
                        GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"const", (boolean)false, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)JSCompilingVisitor.this.myCompilingVisitor.getContext());
                        GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"let", (boolean)false, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)JSCompilingVisitor.this.myCompilingVisitor.getContext());
                    }
                    GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)keyword, (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)JSCompilingVisitor.this.myCompilingVisitor.getContext());
                } else if (elementType == JSTokenTypes.IDENTIFIER) {
                    this.handleWord(element2.getText(), GlobalCompilingVisitor.OccurenceKind.CODE, JSCompilingVisitor.this.myCompilingVisitor.getContext());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/JSCompilingVisitor$JSWordOptimizer", "visitElement"));
        }
    }
}

