/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.DatabaseEngine;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionStateListener;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.console.session.SessionAuditService;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.connection.audit.AuditService;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.audit.AuditorChain;
import com.intellij.database.run.audit.CancelProgressAuditor;
import com.intellij.database.run.audit.TxIsolationAuditor;
import com.intellij.database.run.audit.TxMarkerAuditor;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.MessageBusSessionState;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.session.StateWatcher;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000 `2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0005`abcdB)\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010F\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020GH\u0016J\b\u0010K\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020I2\u0006\u0010N\u001a\u00020LH\u0016J\b\u0010O\u001a\u00020(H\u0016J\b\u0010P\u001a\u00020\bH\u0016J\b\u0010Q\u001a\u00020(H\u0016J\b\u0010R\u001a\u00020\fH\u0016J\b\u0010S\u001a\u00020BH\u0016J\u0010\u0010T\u001a\u00020I2\u0006\u0010U\u001a\u00020(H\u0016J\u0010\u0010V\u001a\u00020I2\u0006\u0010W\u001a\u00020XH\u0016J\b\u0010Y\u001a\u00020IH\u0016J\b\u0010Z\u001a\u00020IH\u0016J\u0010\u0010[\u001a\u00020I2\u0006\u0010\\\u001a\u000201H\u0016J\u0010\u0010]\u001a\u00020I2\u0006\u0010\\\u001a\u000201H\u0016J\u0018\u0010^\u001a\u00020I2\u0006\u0010\\\u001a\u0002012\u0006\u0010_\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R(\u0010\u001a\u001a\u00020\f2\b\b\u0001\u0010\u0019\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010)R\u0014\u0010*\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010)R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u000201008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u001a\u00104\u001a\b\u0012\u0004\u0012\u000205008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R$\u00108\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020(@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010)\"\u0004\b9\u0010:R$\u0010<\u001a\u00020;2\u0006\u0010\u0019\u001a\u00020;@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/intellij/database/console/session/MessageBusSession;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/database/console/session/DatabaseSession;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lcom/intellij/openapi/Disposable$Parent;", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "kernel", "Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;", "name", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/DatabaseConnectionPoint;Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getConnectionPoint", "()Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "getKernel", "()Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;", "id", "", "getId", "()J", "value", "title", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "getConfiguration", "()Lcom/intellij/database/run/ConsoleRunConfiguration;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/AuditService;", "getAuditService", "()Lcom/intellij/database/dataSource/connection/audit/AuditService;", "isService", "", "()Z", "isInternal", "view", "Lcom/intellij/database/run/session/LogView;", "getView", "()Lcom/intellij/database/run/session/LogView;", "clients", "", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "getClients", "()[Lcom/intellij/database/console/client/DatabaseSessionClient;", "clientsWithFile", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "getClientsWithFile", "()[Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "isConnected", "setConnected", "(Z)V", "Lcom/intellij/database/run/session/MessageBusSessionState;", "state", "getState", "()Lcom/intellij/database/run/session/MessageBusSessionState;", "setState", "(Lcom/intellij/database/run/session/MessageBusSessionState;)V", "messageBus", "Lcom/intellij/database/DataBus$Consuming;", "wallet", "Lcom/intellij/database/console/session/MessageBusSession$Wallet;", "wasPublicClient", "getCurrentTx", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "setCurrentTx", "", "marker", "getTxIsolation", "", "setTxIsolation", "isolation", "isIdle", "getTarget", "isValid", "getDisplayName", "getMessageBus", "setAutoCommit", "autoCommit", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "dispose", "beforeTreeDispose", "attach", "client", "detach", "exchange", "to", "Companion", "Wallet", "SessionKernel", "NaturalKernel", "MessageBusSessionChangeEvent", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nMessageBusSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageBusSession.kt\ncom/intellij/database/console/session/MessageBusSession\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,306:1\n37#2,2:307\n37#2,2:309\n*S KotlinDebug\n*F\n+ 1 MessageBusSession.kt\ncom/intellij/database/console/session/MessageBusSession\n*L\n87#1:307,2\n90#1:309,2\n*E\n"})
public class MessageBusSession
extends UserDataHolderBase
implements DatabaseSession,
UiDataProvider,
Disposable.Parent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DatabaseConnectionPoint connectionPoint;
    @NotNull
    private final SessionKernel kernel;
    private final long id;
    @NotNull
    private String title;
    @NotNull
    private final AuditService auditService;
    private final boolean isService;
    private volatile boolean isConnected;
    @NotNull
    private MessageBusSessionState state;
    @NotNull
    private final DataBus.Consuming messageBus;
    @NotNull
    private final Wallet wallet;
    private boolean wasPublicClient;
    @NlsSafe
    @NotNull
    public static final String DEFAULT_SESSION_NAME = "default";
    @NotNull
    public static final String DATABASE_CONSOLE_HELP_ID = "reference.runToolWindow.jdbcTab";
    @NotNull
    private static final AtomicLong idCounter = new AtomicLong(0L);

    public MessageBusSession(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull SessionKernel kernel, @Nls @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        Intrinsics.checkNotNullParameter((Object)kernel, (String)"kernel");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.project = project;
        this.connectionPoint = connectionPoint;
        this.kernel = kernel;
        this.id = AtomicsKt.fetchAndIncrement((AtomicLong)idCounter);
        this.title = name;
        this.auditService = (AuditService)new SessionAuditService(this);
        this.isService = ((CharSequence)name).length() == 0;
        this.state = new MessageBusSessionState();
        DataBus.Consuming consuming = this.kernel.getConsuming().filterFor((DataRequest.Owner)this);
        Intrinsics.checkNotNullExpressionValue((Object)consuming, (String)"filterFor(...)");
        this.messageBus = consuming;
        this.wallet = new Wallet(this);
        this.kernel.init(this.getProject(), this);
        Disposer.register((Disposable)((Disposable)this.getProject().getMessageBus()), (Disposable)this);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public DatabaseConnectionPoint getConnectionPoint() {
        return this.connectionPoint;
    }

    @NotNull
    protected final SessionKernel getKernel() {
        return this.kernel;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getTitle() {
        return ((CharSequence)this.title).length() == 0 ? DEFAULT_SESSION_NAME : this.title;
    }

    @Override
    public void setTitle(@Nls @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((CharSequence)this.title).length() == 0) {
            return;
        }
        this.title = value;
        MessageBusSession.Companion.syncPublisher().renamed(this);
    }

    @Override
    @Nullable
    public ConsoleRunConfiguration getConfiguration() {
        return this.kernel.getConfiguration();
    }

    @Override
    @NotNull
    public AuditService getAuditService() {
        return this.auditService;
    }

    @Override
    public boolean isService() {
        return this.isService;
    }

    @Override
    public boolean isInternal() {
        return !this.isService() && !this.wasPublicClient;
    }

    @NotNull
    public final LogView<DatabaseSession> getView() {
        return DatabaseSessionViewService.Companion.getInstance().getView(this);
    }

    @Override
    @NotNull
    public DatabaseSessionClient[] getClients() {
        Collection $this$toTypedArray$iv = this.wallet.getAttached();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new DatabaseSessionClient[0]);
    }

    @Override
    @NotNull
    public DatabaseSessionClientWithFile[] getClientsWithFile() {
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterIsInstance((Sequence)CollectionsKt.asSequence((Iterable)this.wallet.getAttached()), DatabaseSessionClientWithFile.class), MessageBusSession::_get_clientsWithFile_$lambda$0));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new DatabaseSessionClientWithFile[0]);
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean value) {
        this.isConnected = value;
        DatabaseSessionStateListener listener = MessageBusSession.Companion.syncPublisher();
        if (value) {
            listener.connected(this);
        } else {
            listener.disconnected(this);
        }
    }

    @Override
    @NotNull
    public MessageBusSessionState getState() {
        return this.state;
    }

    public void setState(@NotNull MessageBusSessionState value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ThreadingAssertions.assertEventDispatchThread();
        DatabaseSessionStateListener.ChangeEvent.EventType eventType = this.state.isIdle() == value.isIdle() ? DatabaseSessionStateListener.ChangeEvent.EventType.CHANGED : (this.state.isIdle() ? DatabaseSessionStateListener.ChangeEvent.EventType.STARTED : DatabaseSessionStateListener.ChangeEvent.EventType.STOPPED);
        this.state = value;
        MessageBusSession.Companion.syncPublisher().stateChanged(new MessageBusSessionChangeEvent(this, eventType));
    }

    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        return this.kernel.getTxMarker();
    }

    @Override
    public void setCurrentTx(@NotNull DataRequest.TxMarker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        this.kernel.setTxMarker(marker);
    }

    public int getTxIsolation() {
        return this.kernel.getIsolation();
    }

    public void setTxIsolation(int isolation) {
        this.kernel.setIsolation(isolation);
    }

    @Override
    public boolean isIdle() {
        return this.kernel.getIdle();
    }

    @Override
    @NotNull
    public DatabaseConnectionPoint getTarget() {
        return this.getConnectionPoint();
    }

    @Override
    public boolean isValid() {
        LogView<DatabaseSession> view = DatabaseSessionViewService.Companion.getInstance().getViewIfAny(this);
        return (view == null || view.isValid()) && !this.wallet.getDisposed() && DataSourceUtil.isDataSourceValid(DbPsiFacade.getInstance((Project)this.getProject()), (DasDataSource)this.getTarget().getDataSource());
    }

    @NotNull
    public String getDisplayName() {
        return this.getTitle();
    }

    @Override
    @NotNull
    public DataBus.Consuming getMessageBus() {
        return this.messageBus;
    }

    public void setAutoCommit(boolean autoCommit) {
        DataRequest.TxMarker txMarker;
        if (autoCommit) {
            DataRequest.TxMarker txMarker2 = DataRequest.AUTO_COMMIT;
            txMarker = txMarker2;
            Intrinsics.checkNotNullExpressionValue((Object)txMarker2, (String)"AUTO_COMMIT");
        } else {
            DataRequest.TxMarker txMarker3 = DataRequest.START_NEW;
            txMarker = txMarker3;
            Intrinsics.checkNotNullExpressionValue((Object)txMarker3, (String)"START_NEW");
        }
        this.setCurrentTx(txMarker);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformCoreDataKeys.HELP_ID;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"HELP_ID");
        sink.set(dataKey, (Object)DATABASE_CONSOLE_HELP_ID);
        DataKey<Session<?>> dataKey2 = Session.SESSION_KEY;
        Intrinsics.checkNotNullExpressionValue(dataKey2, (String)"SESSION_KEY");
        sink.set(dataKey2, (Object)this);
    }

    public void dispose() {
    }

    public void beforeTreeDispose() {
        this.wallet.setDisposed(true);
    }

    @Override
    public void attach(@NotNull DatabaseSessionClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (this.wallet.contains(client)) {
            return;
        }
        boolean wasInternal = this.isInternal();
        boolean bl = this.wasPublicClient = this.wasPublicClient || !client.getDepartment().isInternal();
        if (!this.isInternal() && !ApplicationManager.getApplication().isUnitTestMode()) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> MessageBusSession.attach$lambda$0(this));
        }
        if (wasInternal && !this.isInternal()) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> MessageBusSession.attach$lambda$1(this));
        }
        this.wallet.attach(client);
    }

    @Override
    public void detach(@NotNull DatabaseSessionClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.wallet.detach(client, DatabaseSessionClient.DetachTrigger.USER_REQUEST);
    }

    @Override
    public void exchange(@NotNull DatabaseSessionClient client, @NotNull DatabaseSession to) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            if (this.wallet.contains(client)) {
                this.wallet.detach(client, DatabaseSessionClient.DetachTrigger.SESSION_SWITCH);
            }
            to.attach(client);
            VisibleDatabaseSessionClient visibleDatabaseSessionClient = client instanceof VisibleDatabaseSessionClient ? (VisibleDatabaseSessionClient)client : null;
            if (visibleDatabaseSessionClient == null) break block1;
            VisibleDatabaseSessionClient it = visibleDatabaseSessionClient;
            boolean bl = false;
            MessageBusSession.Companion.syncPublisher().clientReattached(it, this, to);
        }
    }

    private static final boolean _get_clientsWithFile_$lambda$0(DatabaseSessionClientWithFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.getDepartment().isInternal();
    }

    private static final void attach$lambda$0(MessageBusSession this$0) {
        DatabaseSessionViewService.Companion.getInstance().initView(this$0);
    }

    private static final void attach$lambda$1(MessageBusSession this$0) {
        MessageBusSessionChangeEvent event = new MessageBusSessionChangeEvent(this$0, DatabaseSessionStateListener.ChangeEvent.EventType.PUBLISHED);
        MessageBusSession.Companion.syncPublisher().stateChanged(event);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$Companion;", "", "<init>", "()V", "DEFAULT_SESSION_NAME", "", "DATABASE_CONSOLE_HELP_ID", "syncPublisher", "Lcom/intellij/database/console/session/DatabaseSessionStateListener;", "idCounter", "Lkotlin/concurrent/atomics/AtomicLong;", "Ljava/util/concurrent/atomic/AtomicLong;", "intellij.database.connectivity"})
    public static final class Companion {
        private Companion() {
        }

        private final DatabaseSessionStateListener syncPublisher() {
            return (DatabaseSessionStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DatabaseSession.Companion.getTopic());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$MessageBusSessionChangeEvent;", "Lcom/intellij/database/console/session/DatabaseSessionStateListener$ChangeEvent;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "eventType", "Lcom/intellij/database/console/session/DatabaseSessionStateListener$ChangeEvent$EventType;", "<init>", "(Lcom/intellij/database/console/session/DatabaseSession;Lcom/intellij/database/console/session/DatabaseSessionStateListener$ChangeEvent$EventType;)V", "getType", "getSession", "intellij.database.connectivity"})
    private static final class MessageBusSessionChangeEvent
    implements DatabaseSessionStateListener.ChangeEvent {
        @NotNull
        private final DatabaseSession session;
        @NotNull
        private final DatabaseSessionStateListener.ChangeEvent.EventType eventType;

        public MessageBusSessionChangeEvent(@NotNull DatabaseSession session, @NotNull DatabaseSessionStateListener.ChangeEvent.EventType eventType) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
            this.session = session;
            this.eventType = eventType;
        }

        @Override
        @NotNull
        public DatabaseSessionStateListener.ChangeEvent.EventType getType() {
            return this.eventType;
        }

        @Override
        @NotNull
        public DatabaseSession getSession() {
            return this.session;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u00101\u001a\u0002022\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00103\u001a\u000204H\u0016J2\u00105\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00106\u001a\u0002072\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u00103\u001a\u00020\u0013H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0016\u0010-\u001a\u0004\u0018\u00010.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00068"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$NaturalKernel;", "Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/database/dataSource/DatabaseConnectionPoint;Lcom/intellij/database/access/DatabaseCredentials;Z)V", "broker", "Lcom/intellij/database/SimpleRequestBroker;", "kotlin.jvm.PlatformType", "watcher", "Lcom/intellij/database/run/session/StateWatcher;", "Lcom/intellij/database/console/session/DatabaseSession;", "isolation", "", "getIsolation", "()I", "setIsolation", "(I)V", "txMarker", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getTxMarker", "()Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "setTxMarker", "(Lcom/intellij/database/datagrid/DataRequest$TxMarker;)V", "consuming", "Lcom/intellij/database/DataBus$Consuming;", "getConsuming", "()Lcom/intellij/database/DataBus$Consuming;", "idle", "getIdle", "()Z", "engine", "Lcom/intellij/database/console/DatabaseEngine;", "getEngine", "()Lcom/intellij/database/console/DatabaseEngine;", "setEngine", "(Lcom/intellij/database/console/DatabaseEngine;)V", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "getConfiguration", "()Lcom/intellij/database/run/ConsoleRunConfiguration;", "init", "", "session", "Lcom/intellij/database/console/session/MessageBusSession;", "createEngine", "bus", "Lcom/intellij/database/DataBus$Producing;", "intellij.database.connectivity"})
    public static class NaturalKernel
    implements SessionKernel {
        @NotNull
        private final DatabaseConnectionPoint connectionPoint;
        @Nullable
        private final DatabaseCredentials credentialsStore;
        private final boolean silent;
        private final SimpleRequestBroker broker;
        private StateWatcher<DatabaseSession> watcher;
        private volatile int isolation;
        @NotNull
        private volatile DataRequest.TxMarker txMarker;
        public DatabaseEngine engine;

        public NaturalKernel(@NotNull Project project, @NotNull String title, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, boolean silent) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            this.connectionPoint = connectionPoint;
            this.credentialsStore = credentialsStore;
            this.silent = silent;
            this.broker = SimpleRequestBroker.newInstance((Project)project, (String)title);
            this.isolation = this.connectionPoint.getTxIsolation();
            DataRequest.TxMarker txMarker = DataRequest.getInitialTxMarker((boolean)this.connectionPoint.isAutoCommit());
            Intrinsics.checkNotNullExpressionValue((Object)txMarker, (String)"getInitialTxMarker(...)");
            this.txMarker = txMarker;
        }

        @Override
        public int getIsolation() {
            return this.isolation;
        }

        @Override
        public void setIsolation(int n) {
            this.isolation = n;
        }

        @Override
        @NotNull
        public DataRequest.TxMarker getTxMarker() {
            return this.txMarker;
        }

        @Override
        public void setTxMarker(@NotNull DataRequest.TxMarker txMarker) {
            Intrinsics.checkNotNullParameter((Object)txMarker, (String)"<set-?>");
            this.txMarker = txMarker;
        }

        @Override
        @NotNull
        public DataBus.Consuming getConsuming() {
            SimpleRequestBroker simpleRequestBroker = this.broker;
            Intrinsics.checkNotNullExpressionValue((Object)simpleRequestBroker, (String)"broker");
            return (DataBus.Consuming)simpleRequestBroker;
        }

        @Override
        public boolean getIdle() {
            StateWatcher<DatabaseSession> stateWatcher = this.watcher;
            if (stateWatcher == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"watcher");
                stateWatcher = null;
            }
            return stateWatcher.isIdle();
        }

        @NotNull
        public final DatabaseEngine getEngine() {
            DatabaseEngine databaseEngine = this.engine;
            if (databaseEngine != null) {
                return databaseEngine;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            return null;
        }

        public final void setEngine(@NotNull DatabaseEngine databaseEngine) {
            Intrinsics.checkNotNullParameter((Object)((Object)databaseEngine), (String)"<set-?>");
            this.engine = databaseEngine;
        }

        @Override
        @Nullable
        public ConsoleRunConfiguration getConfiguration() {
            return this.getEngine().getConfiguration();
        }

        @Override
        public void init(@NotNull Project project, @NotNull MessageBusSession session) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            SimpleRequestBroker simpleRequestBroker = this.broker;
            Intrinsics.checkNotNullExpressionValue((Object)simpleRequestBroker, (String)"broker");
            this.setEngine(this.createEngine(project, (DataBus.Producing)simpleRequestBroker, this.connectionPoint, this.credentialsStore, session));
            DataAuditor[] dataAuditorArray = new DataAuditor[]{new TxIsolationAuditor(session), new TxMarkerAuditor(session), new CancelProgressAuditor(session)};
            session.messageBus.addAuditor((DataAuditor)new AuditorChain(dataAuditorArray));
            Disposer.register((Disposable)session, (Disposable)this.getEngine());
            this.watcher = new StateWatcher.DatabaseSessionWatcher(session);
        }

        @NotNull
        protected DatabaseEngine createEngine(@NotNull Project project, @NotNull DataBus.Producing bus, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, @NotNull DatabaseSession session) {
            JdbcEngine jdbcEngine;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            JdbcEngine $this$createEngine_u24lambda_u240 = jdbcEngine = new JdbcEngine(project, bus, connectionPoint, credentialsStore, session);
            boolean bl = false;
            $this$createEngine_u24lambda_u240.setAskPassword(!this.silent);
            return jdbcEngine;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\u00020\u0007X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00020\rX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006 \u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;", "", "consuming", "Lcom/intellij/database/DataBus$Consuming;", "getConsuming", "()Lcom/intellij/database/DataBus$Consuming;", "txMarker", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getTxMarker", "()Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "setTxMarker", "(Lcom/intellij/database/datagrid/DataRequest$TxMarker;)V", "isolation", "", "getIsolation", "()I", "setIsolation", "(I)V", "idle", "", "getIdle", "()Z", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "getConfiguration", "()Lcom/intellij/database/run/ConsoleRunConfiguration;", "init", "", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/database/console/session/MessageBusSession;", "intellij.database.connectivity"})
    public static interface SessionKernel {
        @NotNull
        public DataBus.Consuming getConsuming();

        @NotNull
        public DataRequest.TxMarker getTxMarker();

        public void setTxMarker(@NotNull DataRequest.TxMarker var1);

        public int getIsolation();

        public void setIsolation(int var1);

        public boolean getIdle();

        @Nullable
        public ConsoleRunConfiguration getConfiguration();

        public void init(@NotNull Project var1, @NotNull MessageBusSession var2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\bH\u0086\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\bJ\u0016\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$Wallet;", "", "session", "Lcom/intellij/database/console/session/MessageBusSession;", "<init>", "(Lcom/intellij/database/console/session/MessageBusSession;)V", "attached", "", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "getAttached", "()Ljava/util/List;", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "contains", "client", "attach", "", "detach", "trigger", "Lcom/intellij/database/console/client/DatabaseSessionClient$DetachTrigger;", "disposeIfPossible", "canClose", "intellij.database.connectivity"})
    private static final class Wallet {
        @NotNull
        private final MessageBusSession session;
        @NotNull
        private final List<DatabaseSessionClient> attached;
        private volatile boolean disposed;

        public Wallet(@NotNull MessageBusSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
            ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
            this.attached = (List)concurrentList;
        }

        @NotNull
        public final List<DatabaseSessionClient> getAttached() {
            return this.attached;
        }

        public final boolean getDisposed() {
            return this.disposed;
        }

        public final void setDisposed(boolean bl) {
            this.disposed = bl;
        }

        public final boolean contains(@NotNull DatabaseSessionClient client) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            return this.attached.contains(client);
        }

        public final void attach(@NotNull DatabaseSessionClient client) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> Wallet.attach$lambda$0(this, client));
            Disposer.register((Disposable)client, () -> Wallet.attach$lambda$1(this, client));
        }

        public final void detach(@NotNull DatabaseSessionClient client, @NotNull DatabaseSessionClient.DetachTrigger trigger) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)((Object)trigger), (String)"trigger");
            this.disposeIfPossible(client);
            client.detached(trigger);
        }

        private final void disposeIfPossible(DatabaseSessionClient client) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> Wallet.disposeIfPossible$lambda$0(this, client));
        }

        private final boolean canClose(DatabaseSessionClient client) {
            return !this.session.isService() && (this.session.isInternal() || ApplicationManager.getApplication().isUnitTestMode() || !this.session.getCurrentTx().isTransactionInProgress() && client instanceof DatabaseSessionClientWithFile && ((DatabaseSessionClientWithFile)client).getAutoClose());
        }

        private static final void attach$lambda$0(Wallet this$0, DatabaseSessionClient $client) {
            ((Collection)this$0.attached).add($client);
            if ($client instanceof VisibleDatabaseSessionClient) {
                Companion.syncPublisher().clientAttached((VisibleDatabaseSessionClient)$client);
            }
        }

        private static final void attach$lambda$1(Wallet this$0, DatabaseSessionClient $client) {
            this$0.disposeIfPossible($client);
        }

        private static final void disposeIfPossible$lambda$0(Wallet this$0, DatabaseSessionClient $client) {
            ((Collection)this$0.attached).remove($client);
            if ($client instanceof VisibleDatabaseSessionClient) {
                Companion.syncPublisher().clientDetached((VisibleDatabaseSessionClient)$client);
            }
            if (this$0.attached.isEmpty() && this$0.canClose($client)) {
                Disposer.dispose((Disposable)this$0.session);
            }
        }
    }
}

