/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.ssh;

import com.intellij.database.console.ssh.DatabaseProxyServer;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisher;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.remote.AuthType;
import com.intellij.ssh.SshSession;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00132\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140 J\b\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/intellij/database/console/ssh/SshTunnelsInfo;", "Ljava/io/Closeable;", "session", "Lcom/intellij/ssh/SshSession;", "authType", "Lcom/intellij/remote/AuthType;", "tunnels", "", "Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshTunnel;", "<init>", "(Lcom/intellij/ssh/SshSession;Lcom/intellij/remote/AuthType;Ljava/util/List;)V", "getSession", "()Lcom/intellij/ssh/SshSession;", "getAuthType", "()Lcom/intellij/remote/AuthType;", "getTunnels", "()Ljava/util/List;", "additionalTunnels", "", "Lcom/intellij/database/dataSource/url/HostPort;", "", "getAdditionalTunnels", "()Ljava/util/Map;", "proxyServer", "Lcom/intellij/database/console/ssh/DatabaseProxyServer;", "getProxyServer", "()Lcom/intellij/database/console/ssh/DatabaseProxyServer;", "setProxyServer", "(Lcom/intellij/database/console/ssh/DatabaseProxyServer;)V", "addAdditionalTunnel", "hostPort", "tunnelProvider", "Lkotlin/Function1;", "close", "", "intellij.database.connectivity"})
public final class SshTunnelsInfo
implements Closeable {
    @NotNull
    private final SshSession session;
    @NotNull
    private final AuthType authType;
    @NotNull
    private final List<DatabaseSshTunnelEstablisher.SshTunnel> tunnels;
    @NotNull
    private final Map<HostPort, Integer> additionalTunnels;
    @Nullable
    private DatabaseProxyServer proxyServer;

    public SshTunnelsInfo(@NotNull SshSession session, @NotNull AuthType authType, @NotNull List<DatabaseSshTunnelEstablisher.SshTunnel> tunnels) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        Intrinsics.checkNotNullParameter(tunnels, (String)"tunnels");
        this.session = session;
        this.authType = authType;
        this.tunnels = tunnels;
        this.additionalTunnels = new ConcurrentHashMap();
        for (DatabaseSshTunnelEstablisher.SshTunnel tunnel : this.tunnels) {
            this.additionalTunnels.put(tunnel.remoteHostPort, tunnel.localPort);
        }
    }

    @NotNull
    public final SshSession getSession() {
        return this.session;
    }

    @NotNull
    public final AuthType getAuthType() {
        return this.authType;
    }

    @NotNull
    public final List<DatabaseSshTunnelEstablisher.SshTunnel> getTunnels() {
        return this.tunnels;
    }

    @NotNull
    public final Map<HostPort, Integer> getAdditionalTunnels() {
        return this.additionalTunnels;
    }

    @Nullable
    public final DatabaseProxyServer getProxyServer() {
        return this.proxyServer;
    }

    public final void setProxyServer(@Nullable DatabaseProxyServer databaseProxyServer) {
        this.proxyServer = databaseProxyServer;
    }

    public final int addAdditionalTunnel(@NotNull HostPort hostPort, @NotNull Function1<? super HostPort, Integer> tunnelProvider) {
        Intrinsics.checkNotNullParameter((Object)hostPort, (String)"hostPort");
        Intrinsics.checkNotNullParameter(tunnelProvider, (String)"tunnelProvider");
        Integer n = this.additionalTunnels.computeIfAbsent(hostPort, arg_0 -> SshTunnelsInfo.addAdditionalTunnel$lambda$0(tunnelProvider, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"computeIfAbsent(...)");
        return ((Number)n).intValue();
    }

    @Override
    public void close() {
        DatabaseProxyServer databaseProxyServer;
        DatabaseProxyServer databaseProxyServer2 = databaseProxyServer = this.proxyServer;
        if (databaseProxyServer2 != null) {
            databaseProxyServer2.stop();
        }
        try {
            this.session.disconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final Integer addAdditionalTunnel$lambda$0(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }
}

