/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.tables;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.kotlin.jupyter.tables.KotlinDataframeParsingKt;
import com.intellij.notebooks.dataframe.KotlinDataframeParserBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.List;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019H\u0002R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/kotlin/jupyter/tables/KotlinDataframeParserImpl;", "Lcom/intellij/notebooks/dataframe/KotlinDataframeParserBase;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "pathToData", "", "", "pathToMetadata", "isNestedFrameStatic", "", "extractColumnData", "Lkotlin/Function1;", "Lcom/fasterxml/jackson/databind/JsonNode;", "extractNestedTablesRowNum", "", "<init>", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/util/List;Ljava/util/List;ZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getRawJson", "serializedData", "processTextPrimitive", "", "text", "base64Pattern", "Lkotlin/text/Regex;", "tryDecodeBase64", "", "isGzipCompressed", "bytes", "decompressGzip", "input", "intellij.kotlin.jupyter.tables"})
final class KotlinDataframeParserImpl
extends KotlinDataframeParserBase {
    @NotNull
    private final Regex base64Pattern;

    public KotlinDataframeParserImpl(@NotNull ObjectMapper mapper, @NotNull List<String> pathToData, @NotNull List<String> pathToMetadata, boolean isNestedFrameStatic, @NotNull Function1<? super JsonNode, ? extends JsonNode> extractColumnData, @NotNull Function1<? super JsonNode, Integer> extractNestedTablesRowNum) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter(pathToData, (String)"pathToData");
        Intrinsics.checkNotNullParameter(pathToMetadata, (String)"pathToMetadata");
        Intrinsics.checkNotNullParameter(extractColumnData, (String)"extractColumnData");
        Intrinsics.checkNotNullParameter(extractNestedTablesRowNum, (String)"extractNestedTablesRowNum");
        super(mapper, pathToData, pathToMetadata, isNestedFrameStatic, extractColumnData, extractNestedTablesRowNum);
        this.base64Pattern = new Regex("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$");
    }

    public /* synthetic */ KotlinDataframeParserImpl(ObjectMapper objectMapper, List list, List list2, boolean bl, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            function1 = KotlinDataframeParserImpl::_init_$lambda$0;
        }
        if ((n & 0x20) != 0) {
            function12 = KotlinDataframeParserImpl::_init_$lambda$1;
        }
        this(objectMapper, list, list2, bl, (Function1<? super JsonNode, ? extends JsonNode>)function1, (Function1<? super JsonNode, Integer>)function12);
    }

    @NotNull
    protected JsonNode getRawJson(@NotNull String serializedData) {
        Intrinsics.checkNotNullParameter((Object)serializedData, (String)"serializedData");
        return KotlinDataframeParsingKt.access$extractRawJson(this.getMapper(), serializedData);
    }

    @NotNull
    protected Object processTextPrimitive(@NotNull String text) {
        String string;
        byte[] bytes;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        byte[] byArray = this.tryDecodeBase64(text);
        if (byArray != null) {
            byte[] bytes2 = byArray;
            boolean bl = false;
            v1 = this.isGzipCompressed(bytes2) ? this.decompressGzip(bytes2) : bytes2;
        } else {
            v1 = bytes = null;
        }
        if (bytes != null) {
            ImageInfo info = ImageInfo.tryDetectImage(bytes);
            string = info;
            if (string == null) {
                string = text;
            }
        } else {
            string = text;
        }
        return string;
    }

    private final byte[] tryDecodeBase64(String text) {
        byte[] byArray;
        if (!this.base64Pattern.matches((CharSequence)text)) {
            return null;
        }
        try {
            byArray = Base64.getDecoder().decode(text);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            byArray = null;
        }
        return byArray;
    }

    private final boolean isGzipCompressed(byte[] bytes) {
        boolean bl;
        if (bytes.length < 3) {
            bl = false;
        } else {
            boolean gzipSignature = bytes[0] == 31 && bytes[1] == -117 && bytes[2] == 8;
            boolean freezeSignature = bytes[0] == 31 && bytes[1] == -98;
            bl = gzipSignature || freezeSignature;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] decompressGzip(byte[] input) {
        byte[] byArray;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new GZIPInputStream(new ByteArrayInputStream(input));
            Throwable throwable2 = null;
            try {
                GZIPInputStream inputStream = (GZIPInputStream)closeable2;
                boolean bl2 = false;
                long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)byteArrayOutputStream, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    private static final JsonNode _init_$lambda$0(JsonNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final int _init_$lambda$1(JsonNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((ArrayNode)it).size();
    }
}

