/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.tables;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.kotlin.jupyter.tables.KotlinDataframeParserFormatV1;
import com.intellij.kotlin.jupyter.tables.KotlinDataframeParserFormatV2;
import com.intellij.notebooks.dataframe.KotlinDataframeParser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kotlin/jupyter/tables/KotlinDataframeParsing;", "", "<init>", "()V", "isKotlinDataFrame", "", "dataObject", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "isFormattedDataFrame", "isFormatSupported", "serializedData", "", "createParserForData", "Lcom/intellij/notebooks/dataframe/KotlinDataframeParser;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "intellij.kotlin.jupyter.tables"})
public final class KotlinDataframeParsing {
    @NotNull
    public static final KotlinDataframeParsing INSTANCE = new KotlinDataframeParsing();

    private KotlinDataframeParsing() {
    }

    public final boolean isKotlinDataFrame(@NotNull ObjectNode dataObject) {
        Intrinsics.checkNotNullParameter((Object)dataObject, (String)"dataObject");
        if (!dataObject.has(MimeType.KOTLIN_DATAFRAME.getMimeType())) {
            return false;
        }
        String string = dataObject.get(MimeType.KOTLIN_DATAFRAME.getMimeType()).asText();
        if (string == null) {
            return false;
        }
        String jsonPayload = string;
        return StringsKt.contains$default((CharSequence)jsonPayload, (CharSequence)"kotlin_dataframe", (boolean)false, (int)2, null);
    }

    public final boolean isFormattedDataFrame(@NotNull ObjectNode dataObject) {
        Intrinsics.checkNotNullParameter((Object)dataObject, (String)"dataObject");
        Object object = dataObject.get(MimeType.KOTLIN_DATAFRAME.getMimeType());
        if (object == null || (object = object.asText()) == null) {
            return false;
        }
        Object jsonPayload = object;
        JsonNode jsonObject = JupyterJsonKt.getJackson().readTree((String)jsonPayload);
        ObjectNode objectNode = (ObjectNode)jsonObject.get("metadata");
        if (objectNode == null) {
            return false;
        }
        ObjectNode metadata = objectNode;
        return Intrinsics.areEqual((Object)metadata.get("is_formatted"), (Object)BooleanNode.TRUE);
    }

    public final boolean isFormatSupported(@NotNull String serializedData) {
        Intrinsics.checkNotNullParameter((Object)serializedData, (String)"serializedData");
        return StringsKt.contains$default((CharSequence)serializedData, (CharSequence)"kotlin_dataframe", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)serializedData, (CharSequence)"ncol", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)serializedData, (CharSequence)"nrow", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)serializedData, (CharSequence)"columns", (boolean)false, (int)2, null);
    }

    @NotNull
    public final KotlinDataframeParser createParserForData(@NotNull String serializedData, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)serializedData, (String)"serializedData");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        return StringsKt.contains$default((CharSequence)serializedData, (CharSequence)"$version", (boolean)false, (int)2, null) ? (KotlinDataframeParser)new KotlinDataframeParserFormatV2(mapper) : (KotlinDataframeParser)new KotlinDataframeParserFormatV1(mapper);
    }
}

