/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasType;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlImplicitTarget;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSetOperatorExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0004\u001a\u00020\u0003J\u001c\u0010\u0011\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u001c\u0010\u0012\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u000fH\u0002J$\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u000fH\u0002J$\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/SqlColumnToValuesMapper;", "", "target", "Lcom/intellij/psi/PsiElement;", "columnHolder", "index", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;I)V", "getTarget", "()Lcom/intellij/psi/PsiElement;", "getColumnHolder", "processValueElements", "", "consumer", "Lkotlin/Function1;", "withNewHolder", "computeUsagesInValues", "computeUsagesInQuery", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "query", "Lcom/intellij/sql/psi/SqlQueryExpression;", "Companion", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlColumnToValuesMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlColumnToValuesMapper.kt\ncom/intellij/sql/SqlColumnToValuesMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1#2:110\n1915#3,2:111\n*S KotlinDebug\n*F\n+ 1 SqlColumnToValuesMapper.kt\ncom/intellij/sql/SqlColumnToValuesMapper\n*L\n92#1:111,2\n*E\n"})
public final class SqlColumnToValuesMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiElement target;
    @NotNull
    private final PsiElement columnHolder;
    private final int index;

    private SqlColumnToValuesMapper(PsiElement target, PsiElement columnHolder, int index) {
        this.target = target;
        this.columnHolder = columnHolder;
        this.index = index;
    }

    @NotNull
    public final PsiElement getTarget() {
        return this.target;
    }

    @NotNull
    public final PsiElement getColumnHolder() {
        return this.columnHolder;
    }

    public final void processValueElements(@NotNull Function1<? super PsiElement, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.computeUsagesInValues(consumer);
        this.computeUsagesInQuery(consumer);
    }

    @Nullable
    public final SqlColumnToValuesMapper withNewHolder(@NotNull PsiElement columnHolder) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)columnHolder, (String)"columnHolder");
        if (Intrinsics.areEqual((Object)columnHolder, (Object)this.columnHolder)) {
            return this;
        }
        PsiElement psiElement = columnHolder;
        if (psiElement instanceof SqlInsertDmlInstruction) {
            Object object2 = ((SqlInsertDmlInstruction)columnHolder).getColumnsList();
            object = object2 != null && (object2 = object2.getColumnsReferenceList()) != null && (object2 = object2.getReferenceList()) != null ? (SqlReferenceExpression)CollectionsKt.getOrNull((List)object2, (int)this.index) : null;
        } else if (psiElement instanceof SqlCreateViewStatement) {
            SqlDefinition[] sqlDefinitionArray = ((SqlCreateViewStatement)columnHolder).getColumnAliases();
            Intrinsics.checkNotNullExpressionValue((Object)sqlDefinitionArray, (String)"getColumnAliases(...)");
            object = ArraysKt.getOrNull((Object[])sqlDefinitionArray, (int)this.index);
        } else {
            object = null;
        }
        if (object == null) {
            return null;
        }
        Object newTarget = object;
        return new SqlColumnToValuesMapper((PsiElement)newTarget, columnHolder, this.index);
    }

    private final void computeUsagesInValues(Function1<? super PsiElement, Unit> consumer) {
        SqlValuesExpression sqlValuesExpression = (SqlValuesExpression)PsiTreeUtil.getChildOfType((PsiElement)this.columnHolder, SqlValuesExpression.class);
        if (sqlValuesExpression == null) {
            return;
        }
        SqlValuesExpression expression = sqlValuesExpression;
        for (SqlParenthesizedExpression p : expression.getExpressions().filter(SqlParenthesizedExpression.class)) {
            PsiElement it;
            Class[] classArray = new Class[]{PsiErrorElement.class, SqlExpression.class};
            PsiElement child = (PsiElement)SqlImplUtil.sqlChildren((PsiElement)((PsiElement)p)).filter(Conditions.instanceOf((Class[])classArray)).skip(this.index).first();
            if (child == null) continue;
            boolean bl = false;
            consumer.invoke((Object)it);
        }
    }

    private final void computeUsagesInQuery(Function1<? super PsiElement, Unit> consumer) {
        PsiElement psiElement = this.columnHolder;
        SqlExpression sqlExpression = psiElement instanceof SqlInsertDmlInstruction ? (SqlExpression)((SqlInsertDmlInstruction)this.columnHolder).getResultSetExpression() : (psiElement instanceof SqlCreateViewStatement ? ((SqlCreateViewStatement)this.columnHolder).getQueryExpression() : null);
        if (sqlExpression == null) {
            return;
        }
        SqlExpression expression = sqlExpression;
        this.computeUsagesInQuery(expression, consumer);
    }

    private final void computeUsagesInQuery(SqlExpression expression, Function1<? super PsiElement, Unit> consumer) {
        SqlExpression sqlExpression = expression;
        if (sqlExpression instanceof SqlQueryExpression) {
            this.computeUsagesInQuery((SqlQueryExpression)expression, consumer);
        } else if (sqlExpression instanceof SqlSetOperatorExpression) {
            Iterable $this$forEach$iv = ((SqlSetOperatorExpression)expression).getOperands();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlExpression it = (SqlExpression)element$iv;
                boolean bl = false;
                this.computeUsagesInQuery(it, consumer);
            }
        }
    }

    private final void computeUsagesInQuery(SqlQueryExpression query, Function1<? super PsiElement, Unit> consumer) {
        DasType dasType = query.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType dasType2 = dasType;
        if (!(dasType2 instanceof SqlTableType)) {
            return;
        }
        PsiElement element = ((SqlTableType)dasType2).getImmediateSourceColumnElement(this.index);
        while (element instanceof SqlImplicitTarget) {
            element = ((SqlImplicitTarget)element).getContextElement();
        }
        if (element == null) {
            return;
        }
        SqlSelectClause selectClause = query.getSelectClause();
        if (PsiTreeUtilKt.isAncestor((PsiElement)((PsiElement)selectClause), (PsiElement)element, (boolean)true)) {
            consumer.invoke((Object)element);
        }
    }

    @JvmStatic
    @Nullable
    public static final SqlColumnToValuesMapper getInstance(@NotNull PsiElement element) {
        return Companion.getInstance(element);
    }

    public /* synthetic */ SqlColumnToValuesMapper(PsiElement target, PsiElement columnHolder, int index, DefaultConstructorMarker $constructor_marker) {
        this(target, columnHolder, index);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/SqlColumnToValuesMapper$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/sql/SqlColumnToValuesMapper;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.database.sql.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlColumnToValuesMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlColumnToValuesMapper.kt\ncom/intellij/sql/SqlColumnToValuesMapper$Companion\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,109:1\n67#2:110\n66#2,2:111\n66#2,2:113\n66#2,2:115\n66#2,2:117\n66#2,2:119\n*S KotlinDebug\n*F\n+ 1 SqlColumnToValuesMapper.kt\ncom/intellij/sql/SqlColumnToValuesMapper$Companion\n*L\n34#1:110\n36#1:111,2\n37#1:113,2\n38#1:115,2\n45#1:117,2\n48#1:119,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final SqlColumnToValuesMapper getInstance(@NotNull PsiElement element) {
            void $this$parentOfType$iv;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement = element;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType = false;
            SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, SqlReferenceExpression.class, (boolean)false);
            if (ref != null && Intrinsics.areEqual((Object)ref.getReferenceElementType().getTargetKind(), (Object)ObjectKind.COLUMN)) {
                PsiElement $this$parentOfType_u24default$iv = (PsiElement)ref;
                boolean withSelf$iv2 = false;
                boolean $i$f$parentOfType2 = false;
                SqlReferenceList sqlReferenceList = (SqlReferenceList)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, SqlReferenceList.class, (boolean)true);
                if (sqlReferenceList == null) {
                    return null;
                }
                SqlReferenceList refList = sqlReferenceList;
                PsiElement $this$parentOfType_u24default$iv2 = (PsiElement)refList;
                boolean withSelf$iv3 = false;
                boolean $i$f$parentOfType3 = false;
                SqlTableColumnsList sqlTableColumnsList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, SqlTableColumnsList.class, (boolean)true);
                if (sqlTableColumnsList == null) {
                    return null;
                }
                SqlTableColumnsList tableColList = sqlTableColumnsList;
                $this$parentOfType_u24default$iv2 = (PsiElement)tableColList;
                withSelf$iv3 = false;
                $i$f$parentOfType3 = false;
                SqlInsertDmlInstruction dml = (SqlInsertDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, SqlInsertDmlInstruction.class, (boolean)true);
                if (dml == null || !(dml.getParent() instanceof SqlInsertStatement)) {
                    return null;
                }
                List list = refList.getReferenceList();
                int id = list.indexOf(ref);
                return new SqlColumnToValuesMapper((PsiElement)ref, (PsiElement)dml, id, null);
            }
            PsiElement $this$parentOfType_u24default$iv = element;
            boolean withSelf$iv4 = false;
            boolean $i$f$parentOfType4 = false;
            SqlColumnAliasDefinition columnAlias = (SqlColumnAliasDefinition)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, SqlColumnAliasDefinition.class, (boolean)true);
            if (columnAlias != null) {
                int index = SqlImplUtil.revSiblings((PsiElement)((PsiElement)columnAlias)).filter(SqlColumnAliasDefinition.class).size() - 1;
                PsiElement $this$parentOfType_u24default$iv3 = (PsiElement)columnAlias;
                boolean withSelf$iv5 = false;
                boolean $i$f$parentOfType5 = false;
                SqlCreateViewStatement sqlCreateViewStatement = (SqlCreateViewStatement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv3, SqlCreateViewStatement.class, (boolean)true);
                if (sqlCreateViewStatement == null) {
                    return null;
                }
                SqlCreateViewStatement createView = sqlCreateViewStatement;
                return new SqlColumnToValuesMapper(element, (PsiElement)createView, index, null);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

