/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.FlowUtilKt;
import com.intellij.sql.dataFlow.instructions.SqlFlowGraph;
import com.intellij.sql.dataFlow.instructions.SqlInstruction;
import com.intellij.sql.dataFlow.instructions.SqlInstructionWithSource;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlRaiseStatement;
import com.intellij.sql.psi.SqlReturnStatement;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.Consumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016J,\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0014\u0010\u0012\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\u0013H\u0014J\u0016\u0010\u0014\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/highlighting/SqlHighlightExitPointsHandler;", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/project/DumbAware;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "target", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lcom/intellij/psi/PsiElement;)V", "getFeatureId", "", "getTargets", "", "selectTargets", "", "targets", "selectionConsumer", "Lcom/intellij/util/Consumer;", "computeUsages", "intellij.database.sql.impl"})
public final class SqlHighlightExitPointsHandler
extends HighlightUsagesHandlerBase<PsiElement>
implements DumbAware {
    @NotNull
    private final PsiElement target;

    public SqlHighlightExitPointsHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super(editor, file);
        this.target = target;
    }

    @NotNull
    public String getFeatureId() {
        return "codeassists.highlight.return";
    }

    @NotNull
    public List<PsiElement> getTargets() {
        return CollectionsKt.listOf((Object)this.target);
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter(selectionConsumer, (String)"selectionConsumer");
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        SqlRoutineDefinition sqlRoutineDefinition = (SqlRoutineDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.target, SqlRoutineDefinition.class);
        if (sqlRoutineDefinition == null) {
            return;
        }
        SqlRoutineDefinition routine = sqlRoutineDefinition;
        SqlFlowGraph flowGraph = FlowUtilKt.buildFlowGraph((SqlRoutineDefinition)routine);
        int count = 0;
        for (SqlInstruction instruction : FlowUtilKt.findExitPoints((SqlFlowGraph)flowGraph)) {
            SqlInstructionWithSource sqlInstructionWithSource = instruction instanceof SqlInstructionWithSource ? (SqlInstructionWithSource)instruction : null;
            SqlElement sqlElement = sqlInstructionWithSource != null ? sqlInstructionWithSource.getSource() : null;
            SqlStatement sqlStatement = sqlElement instanceof SqlStatement ? (SqlStatement)sqlElement : null;
            if (sqlStatement == null) {
                return;
            }
            SqlStatement statement = sqlStatement;
            if (!(statement instanceof SqlReturnStatement) && !(statement instanceof SqlRaiseStatement)) continue;
            this.addOccurrence((PsiElement)statement);
            ++count;
        }
        Object[] objectArray = new Object[]{count, HighlightUsagesHandler.getShortcutText()};
        this.myStatusText = CodeInsightBundle.message((String)"status.bar.exit.points.highlighted.message", (Object[])objectArray);
    }
}

