/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.DropPsiFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlLimitClause;
import com.intellij.sql.psi.SqlOffsetClause;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlUnaryExpression;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantLimitInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlRedundantLimitInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlRedundantLimitInspection.kt\ncom/intellij/sql/inspections/SqlRedundantLimitInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class SqlRedundantLimitInspection
extends SqlInspectionBase {
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        BuiltinFunction builtinFunction;
        String functionName;
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        String string = functionName = dbms2.isCassandra() || dbms2.isClickHouse() || dbms2.isHive() ? null : (dbms2.isPostgres() ? "exists" : "EXISTS");
        if (string != null) {
            String it = string;
            boolean bl = false;
            builtinFunction = dialect.getSupportedFunctions().get(it);
        } else {
            builtinFunction = null;
        }
        BuiltinFunction existsFunction = builtinFunction;
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result, existsFunction, onTheFly){
            final /* synthetic */ BuiltinFunction $existsFunction;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$existsFunction = $existsFunction;
                this.$onTheFly = $onTheFly;
                super($manager, (SqlLanguageDialect)$dialect, (Collection)$result);
            }

            public void visitSqlQueryExpression(SqlQueryExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlQueryExpression(o);
                PsiElement parent = o.getParent();
                if (parent instanceof SqlParenthesizedExpression) {
                    PsiElement psiElement = ((SqlParenthesizedExpression)parent).getParent();
                    SqlUnaryExpression sqlUnaryExpression = psiElement instanceof SqlUnaryExpression ? (SqlUnaryExpression)psiElement : null;
                    if (sqlUnaryExpression == null) {
                        return;
                    }
                    SqlUnaryExpression unaryExpr = sqlUnaryExpression;
                    if (Intrinsics.areEqual((Object)unaryExpr.getOpSign(), (Object)SqlCommonKeywords.SQL_EXISTS)) {
                        this.reportQuery(o);
                    }
                } else if (parent instanceof SqlExpressionList) {
                    if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)parent), (Object)SqlCompositeElementTypes.SQL_ARGUMENT_LIST)) {
                        return;
                    }
                    PsiElement psiElement = ((SqlExpressionList)parent).getParent();
                    SqlFunctionCallExpression sqlFunctionCallExpression = psiElement instanceof SqlFunctionCallExpression ? (SqlFunctionCallExpression)psiElement : null;
                    if (sqlFunctionCallExpression == null) {
                        return;
                    }
                    SqlFunctionCallExpression call = sqlFunctionCallExpression;
                    if (Intrinsics.areEqual((Object)call.getFunctionDefinition(), (Object)this.$existsFunction)) {
                        this.reportQuery(o);
                    }
                }
            }

            private final void reportQuery(SqlQueryExpression query) {
                SqlLimitClause sqlLimitClause = (SqlLimitClause)CollectionsKt.firstOrNull((Iterable)((Iterable)query.getLimitClauses()));
                if (sqlLimitClause == null) {
                    return;
                }
                SqlLimitClause limitClause = sqlLimitClause;
                SqlOffsetClause offsetClause = (SqlOffsetClause)CollectionsKt.firstOrNull((Iterable)((Iterable)query.getOffsetClauses()));
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)limitClause)), (Object)SqlCompositeElementTypes.SQL_TOP_CLAUSE)) {
                    Object[] objectArray = limitClause.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getChildren(...)");
                    Object[] children = objectArray;
                    SqlLimitClause innerLimitClause = (SqlLimitClause)CollectionsKt.firstOrNull((List)ArraysKt.filterIsInstance((Object[])children, SqlLimitClause.class));
                    if (innerLimitClause != null) {
                        limitClause = innerLimitClause;
                    }
                    SqlOffsetClause innerOffsetClause = (SqlOffsetClause)CollectionsKt.firstOrNull((List)ArraysKt.filterIsInstance((Object[])children, SqlOffsetClause.class));
                    SqlOffsetClause sqlOffsetClause = offsetClause;
                    if (sqlOffsetClause == null) {
                        sqlOffsetClause = innerOffsetClause;
                    }
                    offsetClause = sqlOffsetClause;
                }
                SqlOffsetClause sqlOffsetClause = offsetClause;
                if ((sqlOffsetClause != null ? sqlOffsetClause.getOffsetExpression() : null) == null) {
                    String keyword = StringUtil.toUpperCase((String)limitClause.getFirstChild().getText());
                    Object[] objectArray = new Object[]{keyword};
                    String string = SqlBundle.message((String)"inspection.message.clause.redundant.here", (Object[])objectArray);
                    objectArray = new LocalQuickFix[]{DropPsiFix.Companion.getINSTANCE()};
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)limitClause, (PsiElement)limitClause, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, (LocalQuickFix[])objectArray));
                }
            }
        };
    }
}

