/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.DropPsiFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlRedundantOrderingDirectionInspection;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlOrderByClause;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bH\u0002J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantOrderingDirectionInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "processElements", "", "orderBy", "Lcom/intellij/sql/psi/SqlOrderByClause;", "dbms", "Lcom/intellij/database/Dbms;", "processor", "Lkotlin/Function2;", "Lcom/intellij/psi/PsiElement;", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlRedundantOrderingDirectionInspection
extends SqlInspectionBase {
    private final void processElements(SqlOrderByClause orderBy, Dbms dbms, Function2<? super PsiElement, ? super PsiElement, Unit> processor) {
        PsiElement psiElement;
        PsiElement element = orderBy.getFirstChild();
        while (element != null && ((psiElement = PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)((IElementType)SqlCommonKeywords.SQL_ASC), (boolean)true, null)) != null || (psiElement = dbms.isClickHouse() ? PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)((IElementType)SqlCommonKeywords.SQL_ASCENDING), (boolean)true, null) : null) != null)) {
            PsiElement psiElement2;
            PsiElement direction = psiElement;
            if (dbms.isDb2()) {
                PsiElement nulls;
                PsiElement psiElement3 = nulls = PsiTreeUtil.findSiblingForward((PsiElement)direction, (IElementType)((IElementType)SqlCommonKeywords.SQL_NULLS), (boolean)true, null);
                PsiElement last = psiElement3 != null ? PsiTreeUtil.findSiblingForward((PsiElement)psiElement3, (IElementType)((IElementType)SqlCommonKeywords.SQL_LAST), (boolean)true, null) : null;
                psiElement2 = last;
                if (psiElement2 == null && (psiElement2 = nulls) == null) {
                    psiElement2 = direction;
                }
            } else {
                psiElement2 = direction;
            }
            PsiElement lastElement = psiElement2;
            processor.invoke((Object)direction, (Object)lastElement);
            element = lastElement;
        }
    }

    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result, this, onTheFly){
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ SqlRedundantOrderingDirectionInspection this$0;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$dialect = $dialect;
                this.this$0 = $receiver;
                this.$onTheFly = $onTheFly;
                super($manager, (SqlLanguageDialect)$dialect, (Collection)$result);
            }

            public void visitSqlOrderByClause(SqlOrderByClause o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                Dbms dbms = this.$dialect.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                Dbms dbms2 = dbms;
                SqlRedundantOrderingDirectionInspection.access$processElements(this.this$0, o, dbms2, (arg_0, arg_1) -> createAnnotationVisitor.1.visitSqlOrderByClause$lambda$0(this, this.$onTheFly, arg_0, arg_1));
            }

            private static final Unit visitSqlOrderByClause$lambda$0(createAnnotationVisitor.1 this$0, boolean $onTheFly, PsiElement startElement, PsiElement endElement) {
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{DropPsiFix.Companion.getINSTANCE()};
                this$0.addDescriptor(this$0.myManager.createProblemDescriptor(startElement, endElement, SqlBundle.message((String)"inspection.message.ordering.direction.redundant.here", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, $onTheFly, localQuickFixArray));
                return Unit.INSTANCE;
            }
        };
    }

    public static final /* synthetic */ void access$processElements(SqlRedundantOrderingDirectionInspection $this, SqlOrderByClause orderBy, Dbms dbms, Function2 processor) {
        $this.processElements(orderBy, dbms, (Function2<? super PsiElement, ? super PsiElement, Unit>)processor);
    }
}

