/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.refactoring.SqlIntroduceHandlerBase$smartChooseExpression$;
import com.intellij.sql.refactoring.SqlIntroduceHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u0011\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0017\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u0015H$\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH$J\"\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u001e\u001a\u00020\u0006H\u0004J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0086\u0002\u00a2\u0006\u0002\u0010\"J+\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0086\u0002J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010$\u001a\u00020\f2\b\u0010%\u001a\u0004\u0018\u00010!H\u0002J-\u0010&\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020'2\u0006\u0010(\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010)R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lcom/intellij/sql/refactoring/SqlIntroduceHandlerBase;", "Helper", "Lcom/intellij/sql/refactoring/SqlIntroduceHelper;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "Lcom/intellij/lang/ContextAwareActionHandler;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "isAvailableForQuickList", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getHelper", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;)Lcom/intellij/sql/refactoring/SqlIntroduceHelper;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "showError", "message", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "showNoContainerError", "isCalleeExpression", "e", "smartChooseExpression", "Lcom/intellij/sql/psi/SqlFile;", "helper", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/sql/psi/SqlFile;Lcom/intellij/sql/refactoring/SqlIntroduceHelper;)V", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlIntroduceHandlerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlIntroduceHandlerBase.kt\ncom/intellij/sql/refactoring/SqlIntroduceHandlerBase\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n479#2:114\n1#3:115\n*S KotlinDebug\n*F\n+ 1 SqlIntroduceHandlerBase.kt\ncom/intellij/sql/refactoring/SqlIntroduceHandlerBase\n*L\n96#1:114\n*E\n"})
public abstract class SqlIntroduceHandlerBase<Helper extends SqlIntroduceHelper>
implements RefactoringActionHandler,
ContextAwareActionHandler {
    @NotNull
    private final String name;

    public SqlIntroduceHandlerBase(@Nls @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return file instanceof SqlFile;
    }

    @Nullable
    protected abstract Helper getHelper(@NotNull SqlLanguageDialectEx var1);

    protected abstract void invoke(@NotNull Project var1, @NotNull Editor var2, @NotNull SqlExpression var3);

    protected final void showError(@NotNull Project project, @NotNull Editor editor, @NlsContexts.DialogMessage @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)SqlBundle.message((String)"dialog.title.cannot.perform.refactoring", (Object[])new Object[0]), null);
    }

    public final void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
    }

    public final void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)((PsiElement)file))) {
            return;
        }
        if (!(file instanceof SqlFile)) {
            return;
        }
        SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)file));
        Helper helper = this.getHelper(dialect);
        if (helper == null) {
            Object[] objectArray = new Object[]{this.name, dialect.getDisplayName()};
            String string = SqlBundle.message((String)"dialog.message.not.supported.for", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.showError(project, editor, string);
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        if (selectionModel2.hasSelection()) {
            SqlExpression expression = (SqlExpression)SqlImplUtil.getElementBySelection((PsiFile)file, (int)selectionModel2.getSelectionStart(), (int)selectionModel2.getSelectionEnd(), SqlExpression.class);
            if (expression == null) {
                String string = SqlBundle.message((String)"dialog.message.selected.fragment.must.be.valid.expression", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.showError(project, editor, string);
                return;
            }
            if (helper.findTopmostBlock((PsiElement)expression) == null) {
                this.showNoContainerError(project, editor);
                return;
            }
            this.invoke(project, editor, expression);
        } else {
            this.smartChooseExpression(project, editor, (SqlFile)file, helper);
        }
    }

    private final void showNoContainerError(Project project, Editor editor) {
        Object[] objectArray = new Object[]{this.name};
        String string = SqlBundle.message((String)"dialog.message.not.available.in.this.context", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.showError(project, editor, string);
    }

    private final boolean isCalleeExpression(PsiElement e) {
        return e instanceof SqlReferenceExpression && ((SqlReferenceExpression)e).getReferenceElementType() == SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE;
    }

    private final void smartChooseExpression(Project project, Editor editor, SqlFile file, Helper helper) {
        Sequence parents;
        int offset = editor.getCaretModel().getOffset();
        PsiElement currentElement = file.findElementAt(offset);
        if (helper.findTopmostBlock(currentElement) == null) {
            this.showNoContainerError(project, editor);
            return;
        }
        Sequence $this$filterIsInstance$iv = parents = SequencesKt.generateSequence((Object)currentElement, SqlIntroduceHandlerBase::smartChooseExpression$lambda$0);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)smartChooseExpression$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List expressions = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)sequence, arg_0 -> SqlIntroduceHandlerBase.smartChooseExpression$lambda$1(this, arg_0)));
        if (expressions.isEmpty()) {
            String string = SqlBundle.message((String)"dialog.message.no.valid.expressions.were.found", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.showError(project, editor, string);
        } else if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            this.invoke(project, editor, (SqlExpression)CollectionsKt.first((List)expressions));
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor, (List)expressions, (Pass)((Pass)new Pass<SqlExpression>(this, project, editor){
                final /* synthetic */ SqlIntroduceHandlerBase<Helper> this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ Editor $editor;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$editor = $editor;
                }

                public void pass(SqlExpression expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.this$0.invoke(this.$project, this.$editor, expression);
                }
            }), arg_0 -> SqlIntroduceHandlerBase.smartChooseExpression$lambda$3(SqlIntroduceHandlerBase::smartChooseExpression$lambda$2, arg_0));
        }
    }

    private static final PsiElement smartChooseExpression$lambda$0(PsiElement element) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        if (psiElement != null) {
            PsiElement psiElement2;
            PsiElement it = psiElement2 = psiElement;
            boolean bl = false;
            object = !(it instanceof SqlStatement) && !(it instanceof SqlQueryExpression) ? psiElement2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private static final boolean smartChooseExpression$lambda$1(SqlIntroduceHandlerBase this$0, SqlExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.isCalleeExpression((PsiElement)it);
    }

    private static final String smartChooseExpression$lambda$2(SqlExpression it) {
        return it.getText();
    }

    private static final String smartChooseExpression$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

