/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.outputs.impl;

import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/notebooks/visualization/outputs/impl/CollapsingComponentBorder;", "Ljavax/swing/border/Border;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "resized", "", "getResized", "()Z", "setResized", "(Z)V", "paintBorder", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "width", "height", "getBorderInsets", "Ljava/awt/Insets;", "isBorderOpaque", "Companion", "intellij.notebooks.visualization"})
public final class CollapsingComponentBorder
implements Border {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    private boolean resized;
    @NotNull
    private static final JBInsets borderInsets;

    public CollapsingComponentBorder(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    public final boolean getResized() {
        return this.resized;
    }

    public final void setResized(boolean bl) {
        this.resized = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!this.resized) {
            return;
        }
        Graphics g2 = g.create();
        try {
            boolean bl;
            g2.setColor((Color)NotebookUtil.INSTANCE.getNotebookAppearance(this.editor).getCodeCellBackgroundColor().get());
            Insets insets = this.getBorderInsets(c);
            boolean bl2 = bl = insets.top + insets.left + insets.right == 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            int yDraw = y + height - insets.bottom / 2;
            g2.fillRect(x, yDraw, width, JBUI.scale((int)1));
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    @NotNull
    public Insets getBorderInsets(@NotNull Component c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return (Insets)borderInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    static {
        JBInsets jBInsets = JBUI.insetsBottom((int)JBUI.scale((int)4));
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insetsBottom(...)");
        borderInsets = jBInsets;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/notebooks/visualization/outputs/impl/CollapsingComponentBorder$Companion;", "", "<init>", "()V", "borderInsets", "Lcom/intellij/util/ui/JBInsets;", "Lorg/jetbrains/annotations/NotNull;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

