/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.SwingClientProperty;
import com.intellij.notebooks.visualization.context.EditorCellDataContext;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.notebooks.visualization.outputs.NotebookOutputComponentFactory;
import com.intellij.notebooks.visualization.outputs.NotebookOutputComponentFactoryGetter;
import com.intellij.notebooks.visualization.outputs.NotebookOutputDataKey;
import com.intellij.notebooks.visualization.outputs.impl.CollapsingComponent;
import com.intellij.notebooks.visualization.outputs.impl.InnerComponent;
import com.intellij.notebooks.visualization.outputs.impl.SurroundingComponent;
import com.intellij.notebooks.visualization.settings.NotebookSettings;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellOutput;
import com.intellij.notebooks.visualization.ui.EditorCellOutputView;
import com.intellij.notebooks.visualization.ui.EditorCellOutputsPreprocessor;
import com.intellij.notebooks.visualization.ui.EditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.visualization.ui.providers.bounds.JupyterBoundsChangeHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorEmbeddedComponentManager;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0006\u0018\u0000 W2\u00020\u00012\u00020\u0002:\u0001WB-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010+\u001a\u00020,H\u0016J\u0006\u0010-\u001a\u00020\tJ\u0014\u0010.\u001a\u00020\t2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u001aJ\b\u00101\u001a\u00020\tH\u0002J\u0016\u00102\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002000\u001aH\u0003J\u0010\u00103\u001a\u00020\t2\u0006\u00104\u001a\u000205H\u0002J\u0016\u00106\u001a\b\u0012\u0002\b\u0003\u0018\u0001072\u0006\u00108\u001a\u000200H\u0002J?\u00109\u001a\b\u0012\u0002\b\u0003\u0018\u000107\"\b\b\u0000\u0010:*\u00020;2\u0010\u0010<\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H:0=2\u0006\u00108\u001a\u0002002\u0006\u0010>\u001a\u0002H:H\u0002\u00a2\u0006\u0002\u0010?J\"\u0010@\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020$\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030=0A0\u0017H\u0002J<\u0010B\u001a\u00020C\"\b\b\u0000\u0010D*\u00020$\"\b\b\u0001\u0010:*\u00020;*\u000e\u0012\u0004\u0012\u0002HD\u0012\u0004\u0012\u0002H:0=2\u0006\u0010E\u001a\u00020$2\u0006\u0010>\u001a\u00020;H\u0002J\f\u0010F\u001a\u0006\u0012\u0002\b\u00030%H\u0002J\n\u0010G\u001a\u0004\u0018\u00010HH\u0002J\u0018\u0010I\u001a\u0002052\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0002J&\u0010N\u001a\u00020\t2\u0006\u00108\u001a\u0002002\n\u0010O\u001a\u0006\u0012\u0002\b\u0003072\b\b\u0002\u0010P\u001a\u000205H\u0002J>\u0010Q\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002HS\u0012\u0004\u0012\u0002HT0A0R\"\u0004\b\u0000\u0010S\"\u0004\b\u0001\u0010T*\b\u0012\u0004\u0012\u0002HS0R2\f\u0010U\u001a\b\u0012\u0004\u0012\u0002HT0RH\u0002J\b\u0010V\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010%2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010%@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006X"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellOutputsView;", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "onInlayDisposed", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/ui/EditorCell;Lkotlin/jvm/functions/Function1;)V", "value", "", "foldingsVisible", "getFoldingsVisible", "()Z", "setFoldingsVisible", "(Z)V", "foldingsSelected", "getFoldingsSelected", "setFoldingsSelected", "_outputs", "", "Lcom/intellij/notebooks/visualization/ui/EditorCellOutputView;", "outputs", "", "getOutputs", "()Ljava/util/List;", "innerComponent", "Lcom/intellij/notebooks/visualization/outputs/impl/InnerComponent;", "getInnerComponent$intellij_notebooks_visualization", "()Lcom/intellij/notebooks/visualization/outputs/impl/InnerComponent;", "surroundingComponent", "Lcom/intellij/notebooks/visualization/outputs/impl/SurroundingComponent;", "outerComponent", "Ljavax/swing/JComponent;", "Lcom/intellij/openapi/editor/Inlay;", "inlay", "getInlay$intellij_notebooks_visualization", "()Lcom/intellij/openapi/editor/Inlay;", "setInlay", "(Lcom/intellij/openapi/editor/Inlay;)V", "calculateBounds", "Ljava/awt/Rectangle;", "update", "updateView", "newDataKeys", "Lcom/intellij/notebooks/visualization/ui/EditorCellOutput;", "recreateInlayIfNecessary", "updateData", "removeOutput", "idx", "", "createOutputGuessingFactory", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory$CreatedComponent;", "output", "createOutput", "K", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "factory", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory;", "outputDataKey", "(Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory;Lcom/intellij/notebooks/visualization/ui/EditorCellOutput;Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;)Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory$CreatedComponent;", "getComponentsWithFactories", "Lkotlin/Pair;", "matchWithTypes", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory$Match;", "C", "component", "createInlay", "makeGutterIcon", "Lcom/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$Properties$RendererFactory;", "computeInlayOffset", "document", "Lcom/intellij/openapi/editor/Document;", "lines", "Lkotlin/ranges/IntRange;", "addIntoInnerComponent", "newComponent", "pos", "zip", "", "A", "B", "other", "doCheckAndRebuildInlays", "Companion", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellOutputsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellOutputsView.kt\ncom/intellij/notebooks/visualization/ui/EditorCellOutputsView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,337:1\n1915#2,2:338\n1915#2,2:340\n1915#2,2:342\n18#3:344\n23#4:345\n1#5:346\n*S KotlinDebug\n*F\n+ 1 EditorCellOutputsView.kt\ncom/intellij/notebooks/visualization/ui/EditorCellOutputsView\n*L\n45#1:338,2\n53#1:340,2\n146#1:342,2\n172#1:344\n224#1:345\n*E\n"})
public final class EditorCellOutputsView
extends EditorCellViewComponent
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final EditorCell cell;
    @NotNull
    private final Function1<EditorCellOutputsView, Unit> onInlayDisposed;
    private boolean foldingsVisible;
    private boolean foldingsSelected;
    @NotNull
    private final List<EditorCellOutputView> _outputs;
    @NotNull
    private final InnerComponent innerComponent;
    @NotNull
    private final SurroundingComponent surroundingComponent;
    @NotNull
    private final JComponent outerComponent;
    @Nullable
    private Inlay<?> inlay;
    @NotNull
    private static final SwingClientProperty<NotebookOutputComponentFactory<?, ?>, NotebookOutputComponentFactory<?, ?>> outputComponentFactory$delegate = new SwingClientProperty("outputComponentFactory");

    /*
     * WARNING - void declaration
     */
    public EditorCellOutputsView(@NotNull EditorImpl editor, @NotNull EditorCell cell, @NotNull Function1<? super EditorCellOutputsView, Unit> onInlayDisposed) {
        int outputMaxHeightInEditorLines;
        void it;
        InnerComponent innerComponent;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter(onInlayDisposed, (String)"onInlayDisposed");
        this.editor = editor;
        this.cell = cell;
        this.onInlayDisposed = onInlayDisposed;
        this._outputs = new ArrayList();
        InnerComponent innerComponent2 = innerComponent = new InnerComponent();
        EditorCellOutputsView editorCellOutputsView = this;
        boolean bl = false;
        it.setMaxHeight(!ApplicationManager.getApplication().isUnitTestMode() ? ((outputMaxHeightInEditorLines = NotebookSettings.Companion.getInstance().getOutputMaxHeightInEditorLines()) <= 0 ? (int)((double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.3) : outputMaxHeightInEditorLines * this.editor.getLineHeight()) : 200);
        editorCellOutputsView.innerComponent = innerComponent;
        this.surroundingComponent = SurroundingComponent.Companion.create(this.editor, this.innerComponent);
        this.outerComponent = EditorCellDataContext.INSTANCE.createContextProvider(this.cell, this.surroundingComponent);
        this.cell.getOutputs().getOutputs().afterChange((Disposable)this, arg_0 -> EditorCellOutputsView._init_$lambda$1(this, arg_0));
        com.intellij.notebooks.ui.NotebookEditorUiUtilKt.bind((ObservableProperty)((ObservableProperty)this.cell.getOutputs().getScrollingEnabled()), (Disposable)this, arg_0 -> EditorCellOutputsView._init_$lambda$2(this, arg_0));
        com.intellij.notebooks.ui.NotebookEditorUiUtilKt.bind((ObservableProperty)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getEditorBackgroundColor(), (Disposable)this, arg_0 -> EditorCellOutputsView._init_$lambda$3(this, arg_0));
        this.update();
    }

    public /* synthetic */ EditorCellOutputsView(EditorImpl editorImpl, EditorCell editorCell, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = EditorCellOutputsView::_init_$lambda$0;
        }
        this(editorImpl, editorCell, (Function1<? super EditorCellOutputsView, Unit>)function1);
    }

    public final boolean getFoldingsVisible() {
        return this.foldingsVisible;
    }

    public final void setFoldingsVisible(boolean value) {
        if (this.foldingsVisible != value) {
            this.foldingsVisible = value;
            Iterable $this$forEach$iv = this.getOutputs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorCellOutputView it = (EditorCellOutputView)element$iv;
                boolean bl = false;
                it.getFolding().setVisible(value);
            }
        }
    }

    public final boolean getFoldingsSelected() {
        return this.foldingsSelected;
    }

    public final void setFoldingsSelected(boolean value) {
        if (this.foldingsSelected != value) {
            this.foldingsSelected = value;
            Iterable $this$forEach$iv = this.getOutputs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorCellOutputView it = (EditorCellOutputView)element$iv;
                boolean bl = false;
                it.getFolding().setSelected(value);
            }
        }
    }

    @NotNull
    public final List<EditorCellOutputView> getOutputs() {
        return this._outputs;
    }

    @NotNull
    public final InnerComponent getInnerComponent$intellij_notebooks_visualization() {
        return this.innerComponent;
    }

    @Nullable
    public final Inlay<?> getInlay$intellij_notebooks_visualization() {
        return this.inlay;
    }

    private final void setInlay(Inlay<?> value) {
        Inlay<?> inlay = this.inlay;
        int oldHeight = inlay != null ? inlay.getHeightInPixels() : 0;
        Inlay<?> inlay2 = value;
        int newHeight = inlay2 != null ? inlay2.getHeightInPixels() : 0;
        boolean shouldUpdate = oldHeight != newHeight;
        this.inlay = value;
        if (shouldUpdate) {
            JupyterBoundsChangeHandler.Companion.get((Editor)this.editor).boundsChanged();
        }
    }

    @Override
    @NotNull
    public Rectangle calculateBounds() {
        Object object = this.inlay;
        if (object == null || (object = object.getBounds()) == null) {
            object = new Rectangle(0, 0, 0, 0);
        }
        return object;
    }

    public final void update() {
        ActionsKt.runInEdt$default(null, () -> EditorCellOutputsView.update$lambda$0(this), (int)1, null);
    }

    public final void updateView(@NotNull List<EditorCellOutput> newDataKeys) {
        Intrinsics.checkNotNullParameter(newDataKeys, (String)"newDataKeys");
        ActionsKt.runInEdt$default(null, () -> EditorCellOutputsView.updateView$lambda$0(this, newDataKeys), (int)1, null);
    }

    private final void recreateInlayIfNecessary() {
        block2: {
            block0: {
                block1: {
                    if (!(!((Collection)this.getOutputs()).isEmpty())) break block0;
                    DocumentEx documentEx = this.editor.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
                    int expectedOffset = this.computeInlayOffset((Document)documentEx, this.cell.getInterval().getLines());
                    Inlay<?> currentInlay = this.inlay;
                    if (currentInlay == null) break block1;
                    if (currentInlay.getOffset() == expectedOffset) break block2;
                    Disposer.dispose((Disposable)((Disposable)currentInlay));
                    this.setInlay(this.createInlay());
                    break block2;
                }
                this.setInlay(this.createInlay());
                break block2;
            }
            Inlay<?> inlay = this.inlay;
            if (inlay == null) break block2;
            Inlay<?> it = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
            this.setInlay(null);
        }
    }

    @RequiresEdt
    private final boolean updateData(List<EditorCellOutput> outputs) {
        int idx;
        EditorCellOutputsPreprocessor it;
        List<EditorCellOutput> outputs2 = null;
        outputs2 = outputs;
        if (!((Collection)outputs2).isEmpty()) {
            Iterable $this$forEach$iv = EditorCellOutputsPreprocessor.EP_NAME.getExtensionList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (EditorCellOutputsPreprocessor)element$iv;
                boolean bl = false;
                outputs2 = it.processOutputs(outputs2);
            }
        }
        Iterator<EditorCellOutput> newOutputsIterator = outputs2.iterator();
        Iterator<Pair<JComponent, NotebookOutputComponentFactory<?, ?>>> oldComponentsWithFactories = this.getComponentsWithFactories().iterator();
        boolean isFilled = false;
        Iterator<Object> iterator = CollectionsKt.withIndex(this.zip(newOutputsIterator, oldComponentsWithFactories));
        while (iterator.hasNext()) {
            it = (IndexedValue)iterator.next();
            idx = it.component1();
            Pair pair1 = (Pair)it.component2();
            EditorCellOutput output = (EditorCellOutput)pair1.component1();
            Pair pair2 = (Pair)pair1.component2();
            JComponent oldComponent = (JComponent)pair2.component1();
            NotebookOutputComponentFactory oldFactory = (NotebookOutputComponentFactory)pair2.component2();
            NotebookOutputDataKey outputDataKey = output.getDataKey();
            isFilled = (switch (WhenMappings.$EnumSwitchMapping$0[this.matchWithTypes(oldFactory, oldComponent, outputDataKey).ordinal()]) {
                case 1 -> {
                    this.removeOutput(idx);
                    NotebookOutputComponentFactory.CreatedComponent<?> newComponent = this.createOutputGuessingFactory(output);
                    if (newComponent != null) {
                        this.addIntoInnerComponent(output, newComponent, idx);
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    Intrinsics.checkNotNull((Object)oldFactory, (String)"null cannot be cast to non-null type com.intellij.notebooks.visualization.outputs.NotebookOutputComponentFactory<javax.swing.JComponent, com.intellij.notebooks.visualization.outputs.NotebookOutputDataKey>");
                    oldFactory.updateComponent(this.editor, oldComponent, outputDataKey);
                    Container $this$asSafely$iv = oldComponent.getParent();
                    boolean $i$f$asSafely = false;
                    Container v1 = $this$asSafely$iv;
                    if (!(v1 instanceof CollapsingComponent)) {
                        v1 = null;
                    }
                    CollapsingComponent v2 = (CollapsingComponent)v1;
                    if (v2 != null) {
                        v2.updateStubIfCollapsed();
                    }
                    yield true;
                }
                case 3 -> true;
                default -> throw new NoWhenBranchMatchedException();
            }) || isFilled;
        }
        iterator = oldComponentsWithFactories;
        while (iterator.hasNext()) {
            Pair<JComponent, NotebookOutputComponentFactory<?, ?>> ignored = iterator.next();
            idx = this.innerComponent.getComponentCount() - 1;
            this.removeOutput(idx);
        }
        iterator = newOutputsIterator;
        while (iterator.hasNext()) {
            EditorCellOutput output = (EditorCellOutput)iterator.next();
            NotebookOutputComponentFactory.CreatedComponent<?> newComponent = this.createOutputGuessingFactory(output);
            if (newComponent == null) continue;
            isFilled = true;
            EditorCellOutputsView.addIntoInnerComponent$default(this, output, newComponent, 0, 4, null);
        }
        return isFilled;
    }

    private final void removeOutput(int idx) {
        this.innerComponent.remove(idx);
        EditorCellOutputView outputComponent = this._outputs.remove(idx);
        Disposer.dispose((Disposable)((Disposable)outputComponent));
        this.remove(outputComponent);
    }

    private final NotebookOutputComponentFactory.CreatedComponent<?> createOutputGuessingFactory(EditorCellOutput output) {
        NotebookOutputComponentFactory.CreatedComponent<?> createdComponent;
        block1: {
            NotebookOutputDataKey outputDataKey = output.getDataKey();
            for (NotebookOutputComponentFactory factory : SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)NotebookOutputComponentFactoryGetter.Companion.getInstance().getList()), arg_0 -> EditorCellOutputsView.createOutputGuessingFactory$lambda$0(outputDataKey, arg_0))) {
                boolean bl = false;
                Intrinsics.checkNotNull((Object)factory, (String)"null cannot be cast to non-null type com.intellij.notebooks.visualization.outputs.NotebookOutputComponentFactory<*, com.intellij.notebooks.visualization.outputs.NotebookOutputDataKey>");
                NotebookOutputComponentFactory.CreatedComponent<?> createdComponent2 = this.createOutput(factory, output, outputDataKey);
                if (createdComponent2 == null) continue;
                createdComponent = createdComponent2;
                break block1;
            }
            createdComponent = null;
        }
        NotebookOutputComponentFactory.CreatedComponent<?> createdComponent3 = createdComponent;
        return createdComponent3;
    }

    private final <K extends NotebookOutputDataKey> NotebookOutputComponentFactory.CreatedComponent<?> createOutput(NotebookOutputComponentFactory<?, K> factory, EditorCellOutput output, K outputDataKey) {
        NotebookOutputComponentFactory.CreatedComponent<?> createdComponent;
        try {
            createdComponent = factory.createComponent(this.editor, output, outputDataKey);
        }
        catch (Throwable t) {
            EditorCellOutputsView $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(EditorCellOutputsView.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(factory.getClass().getName() + " shouldn't throw exceptions at .createComponent()", t);
            createdComponent = null;
        }
        NotebookOutputComponentFactory.CreatedComponent<?> createdComponent2 = createdComponent;
        if (createdComponent2 == null) {
            return null;
        }
        NotebookOutputComponentFactory.CreatedComponent<?> result = createdComponent2;
        Object component = result.getComponent();
        EditorCellOutputsView.Companion.setOutputComponentFactory(component, factory);
        NotebookOutputComponentFactory.Companion.setExecutionCountHolder$intellij_notebooks_visualization((JComponent)component, result.getExecutionCountHolder());
        Disposable disposable = result.getDisposable();
        if (disposable != null) {
            Disposer.register((Disposable)this, (Disposable)disposable);
        }
        return result;
    }

    private final List<Pair<JComponent, NotebookOutputComponentFactory<?, ?>>> getComponentsWithFactories() {
        List list;
        List it = list = (List)new ArrayList();
        boolean bl = false;
        for (JComponent component : this.innerComponent.getMainComponents()) {
            NotebookOutputComponentFactory factory = EditorCellOutputsView.Companion.getOutputComponentFactory(component);
            if (factory == null) continue;
            ((Collection)it).add(TuplesKt.to((Object)component, (Object)factory));
        }
        return list;
    }

    private final <C extends JComponent, K extends NotebookOutputDataKey> NotebookOutputComponentFactory.Match matchWithTypes(NotebookOutputComponentFactory<C, K> $this$matchWithTypes, JComponent component, NotebookOutputDataKey outputDataKey) {
        NotebookOutputComponentFactory.Match match;
        if (!$this$matchWithTypes.getComponentClass().isAssignableFrom(component.getClass())) {
            match = NotebookOutputComponentFactory.Match.NONE;
        } else if (!$this$matchWithTypes.getOutputDataKeyClass().isAssignableFrom(outputDataKey.getClass())) {
            match = NotebookOutputComponentFactory.Match.NONE;
        } else {
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type C of com.intellij.notebooks.visualization.ui.EditorCellOutputsView.matchWithTypes");
            Intrinsics.checkNotNull((Object)outputDataKey, (String)"null cannot be cast to non-null type K of com.intellij.notebooks.visualization.ui.EditorCellOutputsView.matchWithTypes");
            match = $this$matchWithTypes.match(component, outputDataKey);
        }
        return match;
    }

    private final Inlay<?> createInlay() {
        Inlay inlay;
        EditorEx editorEx = (EditorEx)this.editor;
        int n = NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellOutputToolbarInlayPriority();
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        Inlay inlay2 = inlay = NotebookEditorUiUtilKt.addComponentInlay$default(editorEx, this.outerComponent, true, false, false, n, this.computeInlayOffset((Document)documentEx, this.cell.getInterval().getLines()), this.makeGutterIcon(), 8, null);
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)inlay2));
        Disposer.register((Disposable)((Disposable)inlay2), () -> EditorCellOutputsView.createInlay$lambda$0$0(this));
        return inlay;
    }

    private final EditorEmbeddedComponentManager.Properties.RendererFactory makeGutterIcon() {
        EditorEmbeddedComponentManager.Properties.RendererFactory rendererFactory;
        EditorCellOutputView editorCellOutputView;
        block3: {
            for (EditorCellOutputView it : (Iterable)this.getOutputs()) {
                boolean bl = false;
                if ((it = it.getGutterRenderer$intellij_notebooks_visualization()) == null) continue;
                editorCellOutputView = it;
                break block3;
            }
            editorCellOutputView = null;
        }
        if (editorCellOutputView != null) {
            EditorCellOutputView renderer = editorCellOutputView;
            boolean bl = false;
            rendererFactory = arg_0 -> EditorCellOutputsView.makeGutterIcon$lambda$1$0(renderer, arg_0);
        } else {
            rendererFactory = null;
        }
        return rendererFactory;
    }

    private final int computeInlayOffset(Document document, IntRange lines) {
        return document.getLineEndOffset(lines.getLast());
    }

    private final void addIntoInnerComponent(EditorCellOutput output, NotebookOutputComponentFactory.CreatedComponent<?> newComponent, int pos) {
        block0: {
            EditorImpl editorImpl = this.editor;
            Object obj = newComponent.getComponent();
            boolean bl = newComponent.getResizable();
            Function0<String> function0 = newComponent.getCollapsedTextSupplier();
            UiDataProvider collapsingComponent2 = new UiDataProvider(output, editorImpl, (JComponent)obj, bl, function0){
                final /* synthetic */ EditorCellOutput $output;
                {
                    this.$output = $output;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
                }

                public void uiDataSnapshot(DataSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    sink.set(NotebookDataContext.INSTANCE.getNOTEBOOK_CELL_OUTPUT_DATA_KEY(), (Object)this.$output);
                }
            };
            EditorCellOutputView outputComponent = new EditorCellOutputView(this.editor, output, (CollapsingComponent)collapsingComponent2, newComponent.getDisposable(), newComponent.getGutterRenderer());
            this.innerComponent.add((Component)collapsingComponent2, new InnerComponent.Constraint(newComponent.getWidthStretching(), newComponent.getLimitHeight()), pos);
            outputComponent.getFolding().setVisible(this.foldingsVisible);
            outputComponent.getFolding().setSelected(this.foldingsSelected);
            this._outputs.add(pos == -1 ? this._outputs.size() : pos, outputComponent);
            this.add(outputComponent);
            ((JComponent)newComponent.getComponent()).revalidate();
            Inlay<?> inlay = this.inlay;
            if (inlay == null) break block0;
            inlay.update();
        }
    }

    static /* synthetic */ void addIntoInnerComponent$default(EditorCellOutputsView editorCellOutputsView, EditorCellOutput editorCellOutput, NotebookOutputComponentFactory.CreatedComponent createdComponent, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = -1;
        }
        editorCellOutputsView.addIntoInnerComponent(editorCellOutput, createdComponent, n);
    }

    private final <A, B> Iterator<Pair<A, B>> zip(Iterator<? extends A> $this$zip, Iterator<? extends B> other) {
        return new Iterator<Pair<? extends A, ? extends B>>($this$zip, other){
            final /* synthetic */ Iterator<A> $this_zip;
            final /* synthetic */ Iterator<B> $other;
            {
                this.$this_zip = $receiver;
                this.$other = $other;
            }

            public boolean hasNext() {
                return this.$this_zip.hasNext() && this.$other.hasNext();
            }

            public Pair<A, B> next() {
                return TuplesKt.to(this.$this_zip.next(), this.$other.next());
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Override
    public void doCheckAndRebuildInlays() {
        block3: {
            NotebookCellLines.Interval interval = this.cell.getIntervalOrNull();
            if (interval == null) {
                EditorCellOutputsView it = this;
                boolean bl = false;
                Inlay<?> inlay = this.inlay;
                if (inlay != null) {
                    Inlay<?> it2 = inlay;
                    boolean bl2 = false;
                    Disposer.dispose((Disposable)((Disposable)it2));
                }
                this.setInlay(null);
                return;
            }
            NotebookCellLines.Interval interval2 = interval;
            DocumentEx documentEx = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            int offset = this.computeInlayOffset((Document)documentEx, interval2.getLines());
            Inlay<?> inlay = this.inlay;
            if (inlay == null) break block3;
            Inlay<?> currentInlay = inlay;
            boolean bl = false;
            if (!currentInlay.isValid() || currentInlay.getOffset() != offset) {
                Inlay<?> it = currentInlay;
                boolean bl3 = false;
                Disposer.dispose((Disposable)((Disposable)it));
                this.setInlay(null);
                this.recreateInlayIfNecessary();
            }
        }
    }

    private static final Unit _init_$lambda$0(EditorCellOutputsView it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(EditorCellOutputsView this$0, List keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        this$0.updateView(keys);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(EditorCellOutputsView this$0, boolean it) {
        this$0.innerComponent.setScrollingEnabled(it);
        this$0.innerComponent.revalidate();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(EditorCellOutputsView this$0, Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.surroundingComponent.setBackground(it);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$0(EditorCellOutputsView this$0) {
        this$0.updateView((List)this$0.cell.getOutputs().getOutputs().get());
        return Unit.INSTANCE;
    }

    private static final Unit updateView$lambda$0(EditorCellOutputsView this$0, List $newDataKeys) {
        this$0.updateData($newDataKeys);
        this$0.recreateInlayIfNecessary();
        return Unit.INSTANCE;
    }

    private static final boolean createOutputGuessingFactory$lambda$0(NotebookOutputDataKey $outputDataKey, NotebookOutputComponentFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        return factory.getOutputDataKeyClass().isAssignableFrom($outputDataKey.getClass());
    }

    private static final void createInlay$lambda$0$0(EditorCellOutputsView this$0) {
        this$0.onInlayDisposed.invoke((Object)this$0);
    }

    private static final GutterIconRenderer makeGutterIcon$lambda$1$0(GutterIconRenderer $renderer, Inlay it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $renderer;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003RC\u0010\u0006\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0005*\u00020\u00072\u0010\u0010\u0004\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00058B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellOutputsView$Companion;", "", "<init>", "()V", "<set-?>", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory;", "outputComponentFactory", "Ljavax/swing/JComponent;", "getOutputComponentFactory", "(Ljavax/swing/JComponent;)Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory;", "setOutputComponentFactory", "(Ljavax/swing/JComponent;Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory;)V", "outputComponentFactory$delegate", "Lcom/intellij/notebooks/visualization/SwingClientProperty;", "intellij.notebooks.visualization"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final NotebookOutputComponentFactory<?, ?> getOutputComponentFactory(JComponent $this$outputComponentFactory) {
            return (NotebookOutputComponentFactory)outputComponentFactory$delegate.getValue($this$outputComponentFactory, $$delegatedProperties[0]);
        }

        private final void setOutputComponentFactory(JComponent $this$outputComponentFactory, NotebookOutputComponentFactory<?, ?> notebookOutputComponentFactory) {
            outputComponentFactory$delegate.setValue($this$outputComponentFactory, $$delegatedProperties[0], notebookOutputComponentFactory);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "outputComponentFactory", "getOutputComponentFactory(Ljavax/swing/JComponent;)Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookOutputComponentFactory.Match.values().length];
            try {
                nArray[NotebookOutputComponentFactory.Match.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookOutputComponentFactory.Match.COMPATIBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookOutputComponentFactory.Match.SAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

