/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.modifiers;

import com.ibm.icu.impl.number.Modifier;
import com.ibm.icu.impl.number.NumberStringBuilder;
import com.ibm.icu.impl.number.Properties;
import com.ibm.icu.text.NumberFormat;

public class ConstantAffixModifier
extends Modifier.BaseModifier
implements Modifier.AffixModifier {
    public static final Modifier.AffixModifier EMPTY = new ConstantAffixModifier();
    private final String prefix;
    private final String suffix;
    private final NumberFormat.Field field;
    private final boolean strong;

    public ConstantAffixModifier(String prefix, String suffix, NumberFormat.Field field, boolean strong) {
        this.prefix = prefix == null ? "" : prefix;
        this.suffix = suffix == null ? "" : suffix;
        this.field = field;
        this.strong = strong;
    }

    public ConstantAffixModifier() {
        this.prefix = "";
        this.suffix = "";
        this.field = null;
        this.strong = false;
    }

    @Override
    public int apply(NumberStringBuilder output, int leftIndex, int rightIndex) {
        int length = output.insert(rightIndex, this.suffix, this.field);
        return length += output.insert(leftIndex, this.prefix, this.field);
    }

    @Override
    public int length() {
        return this.prefix.length() + this.suffix.length();
    }

    @Override
    public boolean isStrong() {
        return this.strong;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    public boolean contentEquals(CharSequence _prefix, CharSequence _suffix) {
        int i;
        if (_prefix == null && !this.prefix.isEmpty()) {
            return false;
        }
        if (_suffix == null && !this.suffix.isEmpty()) {
            return false;
        }
        if (_prefix != null && this.prefix.length() != _prefix.length()) {
            return false;
        }
        if (_suffix != null && this.suffix.length() != _suffix.length()) {
            return false;
        }
        for (i = 0; i < this.prefix.length(); ++i) {
            if (this.prefix.charAt(i) == _prefix.charAt(i)) continue;
            return false;
        }
        for (i = 0; i < this.suffix.length(); ++i) {
            if (this.suffix.charAt(i) == _suffix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("<ConstantAffixModifier(%d) prefix:'%s' suffix:'%s'>", this.length(), this.prefix, this.suffix);
    }

    @Override
    public void export(Properties properties) {
        throw new UnsupportedOperationException();
    }
}

