/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.ide.IconProvider;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.micronaut.MicronautIcons;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.gutter.DumbAwareLineMarkerUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/micronaut/config/MnIconProvider;", "Lcom/intellij/ide/IconProvider;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "element", "Lcom/intellij/psi/PsiElement;", "flags", "", "getIconInSmartMode", "getIconInDumbMode", "psiElement", "intellij.micronaut"})
public final class MnIconProvider
extends IconProvider {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        return DumbService.Companion.isDumb(project2) ? this.getIconInDumbMode(element) : this.getIconInSmartMode(element);
    }

    private final Icon getIconInSmartMode(PsiElement element) {
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (element instanceof PropertyImpl) {
            if (!MicronautUtils.hasMicronautLibrary(project2)) {
                return null;
            }
            PsiFile psiFile = ((PropertyImpl)element).getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            if (MnConfigUtilsKt.isMicronautConfigFile(psiFile)) {
                ASTNode aSTNode = ((PropertyImpl)element).getKeyNode();
                if (aSTNode == null) {
                    return null;
                }
                ASTNode keyNode = aSTNode;
                MetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)keyNode.getPsi());
                if (configKey != null) {
                    return configKey.getPresentation().getIcon();
                }
            }
            return null;
        }
        if (element instanceof PropertiesFile) {
            if (!MicronautUtils.hasMicronautLibrary(project2)) {
                return null;
            }
            PsiFile psiFile = ((PropertiesFile)element).getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            return MnConfigUtilsKt.getMicronautConfigFileIcon(psiFile);
        }
        return null;
    }

    private final Icon getIconInDumbMode(PsiElement psiElement) {
        if (psiElement instanceof PropertiesFileImpl) {
            String string = ((PropertiesFileImpl)psiElement).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String fileName = string;
            if (StringsKt.startsWith$default((String)fileName, (String)"application", (boolean)false, (int)2, null)) {
                Module module = DumbAwareLineMarkerUtilsKt.findModuleForFileWhenDumb((PsiFile)((PsiFile)psiElement));
                if (module == null || module.isDisposed() || !MicronautUtils.hasMicronautLibrary(module)) {
                    return null;
                }
                return MicronautIcons.MicronautLogo;
            }
        }
        return null;
    }
}

