/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.yaml;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.MnParametrizedConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.MicroservicesConfigBundle;
import com.intellij.microservices.jvm.config.MicroservicesConfigUtils;
import com.intellij.microservices.jvm.config.yaml.ShowDuplicateKeysQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J-\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/micronaut/config/yaml/MnYamlConfigInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.micronaut.config.yaml"})
public final class MnYamlConfigInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Project project = holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (!MicronautUtils.hasMicronautLibrary(project)) break block2;
                PsiFile psiFile = holder.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                if (MnConfigUtilsKt.isMicronautConfigFile(psiFile)) break block3;
            }
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"buildVisitor(...)");
        return psiElementVisitor;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!(file instanceof YAMLFile)) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        List yamlDocuments = ((YAMLFile)file).getDocuments();
        for (YAMLDocument document : yamlDocuments) {
            MultiMap duplicates = new MultiMap();
            document.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(holder, (MultiMap<String, YAMLKeyValue>)duplicates){
                final /* synthetic */ ProblemsHolder $holder;
                final /* synthetic */ MultiMap<String, YAMLKeyValue> $duplicates;
                {
                    this.$holder = $holder;
                    this.$duplicates = $duplicates;
                }

                public void visitElement(PsiElement element) {
                    YAMLSequence sequence;
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    super.visitElement(element);
                    if (!(element instanceof YAMLKeyValue) || ((YAMLKeyValue)element).getKey() == null) {
                        return;
                    }
                    YAMLValue valueElement = ((YAMLKeyValue)element).getValue();
                    if (valueElement != null && !(valueElement instanceof YAMLScalar) && !(valueElement instanceof YAMLSequence)) {
                        return;
                    }
                    if (valueElement != null) {
                        if (valueElement instanceof YAMLScalar) {
                            MicroservicesConfigUtils.highlightValueReferences((PsiElement)((PsiElement)valueElement), (ProblemsHolder)this.$holder);
                        } else {
                            sequence = (YAMLSequence)valueElement;
                            for (YAMLSequenceItem item : sequence.getItems()) {
                                YAMLScalar itemValue;
                                YAMLValue yAMLValue = item.getValue();
                                if ((yAMLValue instanceof YAMLScalar ? (YAMLScalar)yAMLValue : null) == null) continue;
                                itemValue = itemValue;
                                MicroservicesConfigUtils.highlightValueReferences((PsiElement)((PsiElement)itemValue), (ProblemsHolder)this.$holder);
                            }
                        }
                    }
                    if (PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])(sequence = new YAMLSequence[]{YAMLSequenceItem.class})) != null) {
                        return;
                    }
                    MetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)element);
                    if (configKey == null) {
                        return;
                    }
                    MetaConfigKey.AccessType[] accessTypeArray = MetaConfigKey.AccessType.MAP_GROUP;
                    if (!configKey.isAccessType(Arrays.copyOf(accessTypeArray, accessTypeArray.length))) {
                        this.$duplicates.putValue((Object)configKey.getName(), (Object)element);
                    }
                }
            });
            for (Map.Entry entry : duplicates.entrySet()) {
                Intrinsics.checkNotNull((Object)entry);
                String configKey = (String)entry.getKey();
                Collection values = (Collection)entry.getValue();
                if (values.size() == 1) continue;
                Intrinsics.checkNotNull((Object)configKey);
                if (MnParametrizedConfigKey.Companion.getParametrizedConfigKey(configKey) != null) continue;
                ShowDuplicateKeysQuickFix showDuplicatesFix = new ShowDuplicateKeysQuickFix(configKey, values);
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    YAMLKeyValue keyValue;
                    YAMLKeyValue yAMLKeyValue = keyValue = (YAMLKeyValue)iterator.next();
                    Intrinsics.checkNotNull((Object)yAMLKeyValue);
                    Object[] objectArray = new Object[]{configKey};
                    String string = MicroservicesConfigBundle.message((String)"config.duplicate.key", (Object[])objectArray);
                    objectArray = new LocalQuickFix[]{showDuplicatesFix};
                    holder.registerProblem((PsiElement)yAMLKeyValue, string, (LocalQuickFix[])objectArray);
                }
            }
        }
        return holder.getResultsArray();
    }
}

