/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.highlighting.beans;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.highlighting.beans.MnInjectionGeneratorHelperKt;
import com.intellij.micronaut.jam.beans.MnBeanDefinition;
import com.intellij.micronaut.jam.beans.MnBeansModel;
import com.intellij.micronaut.jam.beans.MnInject;
import com.intellij.micronaut.jam.beans.MnPsiClassBeanDefinition;
import com.intellij.micronaut.jam.beans.MnStereotypeElement;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.microservices.jvm.inject.InjectionConstructorHandler;
import com.intellij.microservices.jvm.inject.InjectionDescriptor;
import com.intellij.microservices.jvm.inject.InjectionGeneratorContext;
import com.intellij.microservices.jvm.inject.InjectionGeneratorHelper;
import com.intellij.microservices.jvm.inject.InjectionType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFieldEx;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002/0B-\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!2\u0006\u0010\"\u001a\u00020\u0007H\u0014J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$H\u0002J\b\u0010%\u001a\u00020&H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*H\u0014J\b\u0010+\u001a\u00020,H\u0014J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020.0!2\u0006\u0010\u0010\u001a\u00020\u0016H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/micronaut/highlighting/beans/MnInjectionGeneratorHelper;", "Lcom/intellij/microservices/jvm/inject/InjectionGeneratorHelper;", "Lcom/intellij/micronaut/highlighting/beans/MnInjectionGeneratorHelper$MnBeanDefinitionWrapper;", "elementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "name", "", "context", "Lcom/intellij/microservices/jvm/inject/InjectionGeneratorContext;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Ljava/lang/String;Lcom/intellij/microservices/jvm/inject/InjectionGeneratorContext;Lcom/intellij/openapi/module/Module;)V", "injectAnnotation", "getBeanName", "bean", "getBeanLocation", "getBeanIdentifyingPsiElement", "getBeanType", "Lcom/intellij/psi/PsiType;", "getAlias", "Lcom/intellij/micronaut/jam/beans/MnBeanDefinition;", "getElementName", "psiElement", "getBeanIcon", "Ljavax/swing/Icon;", "hasFieldInjection", "", "uClass", "Lorg/jetbrains/uast/UClass;", "hasSetterInjection", "findMatchingBeans", "", "prefix", "getKnownInjectionCandidates", "", "checkInject", "", "getBeanDescriptor", "Lcom/intellij/microservices/jvm/inject/InjectionDescriptor;", "type", "Lcom/intellij/microservices/jvm/inject/InjectionType;", "getConstructorHandler", "Lcom/intellij/microservices/jvm/inject/InjectionConstructorHandler;", "getQualifiers", "Lcom/intellij/lang/jvm/actions/AnnotationRequest;", "MnBeanDefinitionWrapper", "MnConstructorHandler", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnInjectionGeneratorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnInjectionGeneratorHelper.kt\ncom/intellij/micronaut/highlighting/beans/MnInjectionGeneratorHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n1#2:204\n1#2:220\n1#2:234\n1586#3:205\n1661#3,3:206\n1642#3,10:209\n1915#3:219\n1916#3:221\n1652#3:222\n1642#3,10:223\n1915#3:233\n1916#3:235\n1652#3:236\n*S KotlinDebug\n*F\n+ 1 MnInjectionGeneratorHelper.kt\ncom/intellij/micronaut/highlighting/beans/MnInjectionGeneratorHelper\n*L\n140#1:220\n167#1:234\n135#1:205\n135#1:206,3\n140#1:209,10\n140#1:219\n140#1:221\n140#1:222\n167#1:223,10\n167#1:233\n167#1:235\n167#1:236\n*E\n"})
public abstract class MnInjectionGeneratorHelper
extends InjectionGeneratorHelper<MnBeanDefinitionWrapper> {
    @NotNull
    private final Module module;
    @NotNull
    private String injectAnnotation;

    public MnInjectionGeneratorHelper(@NotNull SmartPsiElementPointer<PsiElement> elementPointer, @NotNull String name, @NotNull InjectionGeneratorContext context, @NotNull Module module) {
        Intrinsics.checkNotNullParameter(elementPointer, (String)"elementPointer");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super(elementPointer, name, context);
        this.module = module;
        this.injectAnnotation = "jakarta.inject.Inject";
    }

    @NotNull
    protected String getBeanName(@NotNull MnBeanDefinitionWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getName();
    }

    @Nullable
    protected String getBeanLocation(@NotNull MnBeanDefinitionWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getLocation();
    }

    @Nullable
    protected PsiElement getBeanIdentifyingPsiElement(@NotNull MnBeanDefinitionWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getBean().getDefiningPsiElement();
    }

    @Nullable
    protected PsiType getBeanType(@NotNull MnBeanDefinitionWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getBean().getBeanType();
    }

    private final String getAlias(MnBeanDefinition bean) {
        UAnnotated uAnnotated = (UAnnotated)UastContextKt.toUElement((PsiElement)bean.getDefiningPsiElement(), UAnnotated.class);
        if (uAnnotated == null) {
            return null;
        }
        UAnnotated uAnnotated2 = uAnnotated;
        for (UAnnotation uAnnotation : uAnnotated2.getUAnnotations()) {
            String string;
            PsiAnnotation psiAnnotation;
            if (uAnnotation.getJavaPsi() == null || !Intrinsics.areEqual((Object)"javax.inject.Named", (Object)psiAnnotation.getQualifiedName()) && !Intrinsics.areEqual((Object)"jakarta.inject.Named", (Object)psiAnnotation.getQualifiedName())) continue;
            PsiAnnotationMemberValue value = psiAnnotation.findDeclaredAttributeValue("value");
            if (value == null) {
                PsiElement psiElement = bean.getDefiningPsiElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getDefiningPsiElement(...)");
                string = this.getElementName(psiElement);
            } else {
                string = AnnotationUtil.getStringAttributeValue((PsiAnnotationMemberValue)value);
            }
            return string;
        }
        return null;
    }

    private final String getElementName(PsiElement psiElement) {
        UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)psiElement, UClass.class);
        if (uClass != null) {
            return uClass.getJavaPsi().getName();
        }
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)psiElement, UMethod.class);
        if (uMethod != null) {
            return uMethod.getName();
        }
        UField uField = (UField)UastContextKt.toUElement((PsiElement)psiElement, UField.class);
        if (uField != null) {
            return uField.getName();
        }
        return null;
    }

    @NotNull
    protected Icon getBeanIcon(@NotNull MnBeanDefinitionWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        if (bean.getBean() instanceof MnStereotypeElement) {
            Icon icon = ((MnStereotypeElement)bean.getBean()).getBeanIcon(false);
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getBeanIcon(...)");
            return icon;
        }
        Icon icon = JavaUltimateIcons.Cdi.Bean;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Bean");
        return icon;
    }

    protected boolean hasFieldInjection(@NotNull UClass uClass) {
        UField uField;
        block1: {
            Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
            UField[] uFieldArray = uClass.getFields();
            int n = uFieldArray.length;
            for (int i = 0; i < n; ++i) {
                UField uField2;
                UField it = uField2 = uFieldArray[i];
                boolean bl = false;
                if (!(it instanceof UFieldEx && MicronautBeanUtilsKt.isInjectionPoint((UFieldEx)it))) continue;
                uField = uField2;
                break block1;
            }
            uField = null;
        }
        return uField != null;
    }

    protected boolean hasSetterInjection(@NotNull UClass uClass) {
        UMethod uMethod;
        block1: {
            Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
            UMethod[] uMethodArray = uClass.getMethods();
            int n = uMethodArray.length;
            for (int i = 0; i < n; ++i) {
                UMethod uMethod2;
                UMethod it = uMethod2 = uMethodArray[i];
                boolean bl = false;
                if (!(!it.isConstructor() && MicronautBeanUtilsKt.isInjectionPoint(it))) continue;
                uMethod = uMethod2;
                break block1;
            }
            uMethod = null;
        }
        return uMethod != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<MnBeanDefinitionWrapper> findMatchingBeans(@NotNull String prefix) {
        void $this$mapTo$iv$iv;
        Object alias;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.checkInject();
        CamelHumpMatcher matcher = new CamelHumpMatcher(prefix, true);
        HashMap candidates = new HashMap();
        Stream<MnBeanDefinition> stream = MnBeansModel.getAllBeans(this.module);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"getAllBeans(...)");
        Sequence beans = SequencesKt.plus((Sequence)StreamsKt.asSequence(stream), (Iterable)this.getKnownInjectionCandidates());
        for (MnBeanDefinition bean : beans) {
            Object name;
            Intrinsics.checkNotNull((Object)bean);
            String typeName = MnInjectionGeneratorHelperKt.access$getBeanName(bean);
            if (Intrinsics.areEqual((Object)typeName, (Object)prefix)) {
                return CollectionsKt.listOf((Object)new MnBeanDefinitionWrapper(bean, typeName, this.getQualifiers(bean)));
            }
            alias = this.getAlias(bean);
            if (Intrinsics.areEqual((Object)alias, (Object)prefix)) {
                return CollectionsKt.listOf((Object)new MnBeanDefinitionWrapper(bean, (String)alias, this.getQualifiers(bean)));
            }
            Object object = alias;
            if (object == null) {
                object = name = typeName;
            }
            if (alias != null && matcher.prefixMatches((String)alias)) {
                ((Map)candidates).put(bean, new Pair(name, (Object)matcher.matchingDegree((String)alias)));
                continue;
            }
            if (!matcher.prefixMatches(typeName)) continue;
            ((Map)candidates).put(bean, new Pair(name, (Object)matcher.matchingDegree(typeName)));
        }
        ArrayList result = new ArrayList(candidates.entrySet());
        CollectionsKt.sortWith((List)result, (arg_0, arg_1) -> MnInjectionGeneratorHelper.findMatchingBeans$lambda$1(MnInjectionGeneratorHelper::findMatchingBeans$lambda$0, arg_0, arg_1));
        Iterable $this$map$iv = result;
        boolean $i$f$map = false;
        alias = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            MnBeanDefinition mnBeanDefinition = (MnBeanDefinition)k;
            String string = (String)((Pair)it.getValue()).getFirst();
            Object k2 = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k2, (String)"<get-key>(...)");
            collection.add(new MnBeanDefinitionWrapper(mnBeanDefinition, string, this.getQualifiers((MnBeanDefinition)k2)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<MnBeanDefinition> getKnownInjectionCandidates() {
        void $this$mapNotNullTo$iv$iv;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.module.getProject());
        Iterable $this$mapNotNull$iv = MnBeansModel.KNOWN_INJECTION_CANDIDATES.keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MnPsiClassBeanDefinition mnPsiClassBeanDefinition;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String beanType = (String)element$iv$iv;
            boolean bl2 = false;
            PsiClass psiClass = javaPsiFacade.findClass(beanType, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.module));
            if (psiClass != null) {
                PsiClass it = psiClass;
                boolean bl3 = false;
                mnPsiClassBeanDefinition = new MnPsiClassBeanDefinition(it);
            } else {
                mnPsiClassBeanDefinition = null;
            }
            if (mnPsiClassBeanDefinition == null) continue;
            MnPsiClassBeanDefinition it$iv$iv = mnPsiClassBeanDefinition;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void checkInject() {
        if (!MicronautUtils.hasJakartaInject(this.module) && MicronautUtils.hasJavaxInject(this.module)) {
            this.injectAnnotation = "javax.inject.Inject";
        }
    }

    @Nullable
    protected InjectionDescriptor getBeanDescriptor(@NotNull MnBeanDefinitionWrapper bean, @NotNull InjectionType type) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String name = PsiNameHelper.getInstance((Project)this.getContext().getProject()).isIdentifier(bean.getName()) ? bean.getName() : MnInjectionGeneratorHelperKt.access$getBeanName(bean.getBean());
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)bean.getBean().getBeanType());
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        SmartList annotationRequests = new SmartList();
        if (type != InjectionType.CONSTRUCTOR) {
            annotationRequests.add((Object)AnnotationRequestsKt.annotationRequest((String)this.injectAnnotation, (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0]));
        }
        annotationRequests.addAll((Collection)bean.getQualifiers());
        PsiClassType psiClassType = PsiTypesUtil.getClassType((PsiClass)psiClass2);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getClassType(...)");
        return new InjectionDescriptor(name, (PsiType)psiClassType, (List)annotationRequests);
    }

    @NotNull
    protected InjectionConstructorHandler getConstructorHandler() {
        return new MnConstructorHandler(this.injectAnnotation);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnnotationRequest> getQualifiers(MnBeanDefinition bean) {
        void $this$mapNotNullTo$iv$iv;
        UAnnotated uAnnotated = (UAnnotated)UastContextKt.toUElement((PsiElement)bean.getDefiningPsiElement(), UAnnotated.class);
        if (uAnnotated == null) {
            return CollectionsKt.emptyList();
        }
        UAnnotated uAnnotated2 = uAnnotated;
        Iterable $this$mapNotNull$iv = uAnnotated2.getUAnnotations();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AnnotationRequest it$iv$iv;
            PsiAnnotation psiAnnotation;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UAnnotation it = (UAnnotation)element$iv$iv;
            boolean bl2 = false;
            if ((it.getJavaPsi() == null ? null : (!Intrinsics.areEqual((Object)"javax.inject.Named", (Object)psiAnnotation.getQualifiedName()) && !Intrinsics.areEqual((Object)"jakarta.inject.Named", (Object)psiAnnotation.getQualifiedName()) ? null : AnnotationRequestsKt.annotationRequest((JvmAnnotation)((JvmAnnotation)psiAnnotation)))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final int findMatchingBeans$lambda$0(Map.Entry t1, Map.Entry t2) {
        int matchingDegree = ((Number)((Pair)t2.getValue()).getSecond()).intValue() - ((Number)((Pair)t1.getValue()).getSecond()).intValue();
        if (matchingDegree == 0) {
            return StringUtil.compare((String)((String)((Pair)t1.getValue()).getFirst()), (String)((String)((Pair)t2.getValue()).getFirst()), (boolean)false);
        }
        return matchingDegree;
    }

    private static final int findMatchingBeans$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0014\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001a\u001a\u00020\u001bH\u00d6\u0081\u0004J\n\u0010\u001c\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/micronaut/highlighting/beans/MnInjectionGeneratorHelper$MnBeanDefinitionWrapper;", "", "bean", "Lcom/intellij/micronaut/jam/beans/MnBeanDefinition;", "name", "", "qualifiers", "", "Lcom/intellij/lang/jvm/actions/AnnotationRequest;", "<init>", "(Lcom/intellij/micronaut/jam/beans/MnBeanDefinition;Ljava/lang/String;Ljava/util/List;)V", "getBean", "()Lcom/intellij/micronaut/jam/beans/MnBeanDefinition;", "getName", "()Ljava/lang/String;", "getQualifiers", "()Ljava/util/List;", "location", "getLocation", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.micronaut"})
    public static final class MnBeanDefinitionWrapper {
        @NotNull
        private final MnBeanDefinition bean;
        @NotNull
        private final String name;
        @NotNull
        private final List<AnnotationRequest> qualifiers;
        @Nullable
        private final String location;

        public MnBeanDefinitionWrapper(@NotNull MnBeanDefinition bean, @NotNull String name, @NotNull List<? extends AnnotationRequest> qualifiers) {
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
            this.bean = bean;
            this.name = name;
            this.qualifiers = qualifiers;
            this.location = MnInjectionGeneratorHelperKt.access$getBeanLocation(this.bean, this.name);
        }

        @NotNull
        public final MnBeanDefinition getBean() {
            return this.bean;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<AnnotationRequest> getQualifiers() {
            return this.qualifiers;
        }

        @Nullable
        public final String getLocation() {
            return this.location;
        }

        @NotNull
        public final MnBeanDefinition component1() {
            return this.bean;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final List<AnnotationRequest> component3() {
            return this.qualifiers;
        }

        @NotNull
        public final MnBeanDefinitionWrapper copy(@NotNull MnBeanDefinition bean, @NotNull String name, @NotNull List<? extends AnnotationRequest> qualifiers) {
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
            return new MnBeanDefinitionWrapper(bean, name, qualifiers);
        }

        public static /* synthetic */ MnBeanDefinitionWrapper copy$default(MnBeanDefinitionWrapper mnBeanDefinitionWrapper, MnBeanDefinition mnBeanDefinition, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                mnBeanDefinition = mnBeanDefinitionWrapper.bean;
            }
            if ((n & 2) != 0) {
                string = mnBeanDefinitionWrapper.name;
            }
            if ((n & 4) != 0) {
                list = mnBeanDefinitionWrapper.qualifiers;
            }
            return mnBeanDefinitionWrapper.copy(mnBeanDefinition, string, list);
        }

        @NotNull
        public String toString() {
            return "MnBeanDefinitionWrapper(bean=" + this.bean + ", name=" + this.name + ", qualifiers=" + this.qualifiers + ")";
        }

        public int hashCode() {
            int result = this.bean.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + ((Object)this.qualifiers).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MnBeanDefinitionWrapper)) {
                return false;
            }
            MnBeanDefinitionWrapper mnBeanDefinitionWrapper = (MnBeanDefinitionWrapper)other;
            if (!Intrinsics.areEqual((Object)this.bean, (Object)mnBeanDefinitionWrapper.bean)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)mnBeanDefinitionWrapper.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.qualifiers, mnBeanDefinitionWrapper.qualifiers);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/micronaut/highlighting/beans/MnInjectionGeneratorHelper$MnConstructorHandler;", "Lcom/intellij/microservices/jvm/inject/InjectionConstructorHandler;", "injectAnnotation", "", "<init>", "(Ljava/lang/String;)V", "findConstructor", "Lorg/jetbrains/uast/UMethod;", "uClass", "Lorg/jetbrains/uast/UClass;", "getAnnotationRequests", "", "Lcom/intellij/lang/jvm/actions/AnnotationRequest;", "intellij.micronaut"})
    @SourceDebugExtension(value={"SMAP\nMnInjectionGeneratorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnInjectionGeneratorHelper.kt\ncom/intellij/micronaut/highlighting/beans/MnInjectionGeneratorHelper$MnConstructorHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,203:1\n3938#2:204\n4474#2,2:205\n3938#2:207\n4474#2,2:208\n*S KotlinDebug\n*F\n+ 1 MnInjectionGeneratorHelper.kt\ncom/intellij/micronaut/highlighting/beans/MnInjectionGeneratorHelper$MnConstructorHandler\n*L\n183#1:204\n183#1:205,2\n199#1:207\n199#1:208,2\n*E\n"})
    private static final class MnConstructorHandler
    implements InjectionConstructorHandler {
        @NotNull
        private final String injectAnnotation;

        public MnConstructorHandler(@NotNull String injectAnnotation) {
            Intrinsics.checkNotNullParameter((Object)injectAnnotation, (String)"injectAnnotation");
            this.injectAnnotation = injectAnnotation;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public UMethod findConstructor(@NotNull UClass uClass) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
            UMethod[] $this$filter$iv = uClass.getMethods();
            boolean $i$f$filter = false;
            UMethod[] uMethodArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!it.isConstructor()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List constructors = (List)destination$iv$iv;
            if (constructors.size() == 1) {
                return (UMethod)CollectionsKt.first((List)constructors);
            }
            for (UMethod constructor : constructors) {
                if (MnInject.METHOD_META.getJamElement((PsiModifierListOwner)constructor.getJavaPsi()) == null) continue;
                return constructor;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<AnnotationRequest> getAnnotationRequests(@NotNull UClass uClass) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
            UMethod[] $this$filter$iv = uClass.getMethods();
            boolean $i$f$filter = false;
            UMethod[] uMethodArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!it.isConstructor()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List constructors = (List)destination$iv$iv;
            return constructors.isEmpty() ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)AnnotationRequestsKt.annotationRequest((String)this.injectAnnotation, (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0]));
        }
    }
}

