/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider;

import com.intellij.micronaut.config.MnConfigPlaceholderReference;
import com.intellij.micronaut.jam.beans.MnBeansConstants;
import com.intellij.micronaut.jam.cache.MnCacheModelKt;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.micronaut.provider.management.MnManagementUtils;
import com.intellij.micronaut.provider.mq.MnMqUtilsKt;
import com.intellij.micronaut.provider.websocket.MnWebSocketUtilsKt;
import com.intellij.microservices.url.UrlSpecialSegmentMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.util.SmartList;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J1\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0002J*\u0010 \u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00132\b\b\u0002\u0010\"\u001a\u00020\u001dH\u0002\u00a8\u0006$"}, d2={"Lcom/intellij/micronaut/provider/MnPropertyReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "<init>", "()V", "registerReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "createPropertyReferences", "", "Lcom/intellij/psi/PsiReference;", "host", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "createPlaceholderPropertiesReferences", "createEachPropertyReferences", "getTextRangesWithNested", "", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/micronaut/provider/MnPropertyReferenceContributor$PlaceholderInfo;", "element", "getFullTextRange", "getPlaceholderPrefixes", "", "Lcom/intellij/microservices/url/UrlSpecialSegmentMarker;", "textRanges", "valueElement", "(Ljava/util/Map;Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "hasNestedPlaceholders", "", "textRange", "ranges", "createPlaceholderReference", "info", "asPrefix", "PlaceholderInfo", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnPropertyReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnPropertyReferenceContributor.kt\ncom/intellij/micronaut/provider/MnPropertyReferenceContributor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,153:1\n37#2,2:154\n*S KotlinDebug\n*F\n+ 1 MnPropertyReferenceContributor.kt\ncom/intellij/micronaut/provider/MnPropertyReferenceContributor\n*L\n121#1:154,2\n*E\n"})
public final class MnPropertyReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        UExpressionPattern injection = UastPatterns.injectionHostUExpression$default((boolean)false, (int)1, null);
        Object[] objectArray = new ElementPattern[2];
        objectArray[0] = injection.annotationParam("io.micronaut.context.annotation.Property", "name");
        String[] stringArray = new String[]{"property", "missingProperty"};
        StringPattern stringPattern = PsiJavaPatterns.string().oneOf(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern, (String)"oneOf(...)");
        objectArray[1] = injection.annotationParams("io.micronaut.context.annotation.Requires", (ElementPattern)stringPattern);
        ElementPattern elementPattern = StandardPatterns.or((ElementPattern[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)elementPattern, (String)"or(...)");
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)elementPattern, (UastReferenceProvider)((UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((arg_0, arg_1) -> MnPropertyReferenceContributor.registerReferenceProviders$lambda$0(this, arg_0, arg_1))), (double)100.0);
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)injection.annotationParam("io.micronaut.context.annotation.EachProperty", "value")), (UastReferenceProvider)((UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((arg_0, arg_1) -> MnPropertyReferenceContributor.registerReferenceProviders$lambda$1(this, arg_0, arg_1))), (double)100.0);
        PsiClassPattern propertyResolver = PsiJavaPatterns.psiClass().inheritorOf(false, "io.micronaut.core.value.PropertyResolver");
        objectArray = new String[]{"getProperty", "containsProperty", "getRequiredProperty"};
        UCallExpressionPattern uCallExpressionPattern = UastPatterns.callExpression().withMethodNames((Collection)CollectionsKt.listOf((Object[])objectArray));
        Intrinsics.checkNotNull((Object)propertyResolver);
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)injection.callParameter(0, (ElementPattern)uCallExpressionPattern.withReceiver((ElementPattern)propertyResolver))), (UastReferenceProvider)((UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((arg_0, arg_1) -> MnPropertyReferenceContributor.registerReferenceProviders$lambda$2(this, arg_0, arg_1))), (double)100.0);
        SpreadBuilder spreadBuilder = new SpreadBuilder(7);
        spreadBuilder.addSpread(MicronautBeanUtilsKt.getBeansPropertyPatterns(injection));
        spreadBuilder.addSpread(MnHttpUtils.getHttpPropertyPatterns(injection));
        spreadBuilder.addSpread(MicronautBeanUtilsKt.getRetryPropertyPatterns(injection));
        spreadBuilder.addSpread(MnWebSocketUtilsKt.getWebSocketPropertyPatterns(injection));
        spreadBuilder.addSpread(MnManagementUtils.getManagementPropertyPatterns(injection));
        spreadBuilder.addSpread(MnMqUtilsKt.getMqPropertyPatterns(injection));
        spreadBuilder.addSpread(MnCacheModelKt.getCachePropertyPatterns(injection));
        objectArray = StandardPatterns.or((ElementPattern[])((ElementPattern[])spreadBuilder.toArray((Object[])new ElementPattern[spreadBuilder.size()])));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"or(...)");
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)objectArray, (UastReferenceProvider)((UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((arg_0, arg_1) -> MnPropertyReferenceContributor.registerReferenceProviders$lambda$3(this, arg_0, arg_1))), (double)100.0);
    }

    private final PsiReference[] createPropertyReferences(PsiElement host) {
        return this.createPlaceholderPropertiesReferences(this.getFullTextRange(host), host);
    }

    private final PsiReference[] createPlaceholderPropertiesReferences(PsiElement host) {
        return this.createPlaceholderPropertiesReferences(this.getTextRangesWithNested(host), host);
    }

    private final PsiReference[] createEachPropertyReferences(PsiElement host) {
        Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull((Iterable)this.getFullTextRange(host).entrySet());
        if (entry == null) {
            return new PsiReference[0];
        }
        Map.Entry entry2 = entry;
        TextRange textRange = (TextRange)entry2.getKey();
        PlaceholderInfo placeholderInfo = (PlaceholderInfo)entry2.getValue();
        PsiReference[] psiReferenceArray = new PsiReference[]{this.createPlaceholderReference(host, textRange, placeholderInfo, true)};
        return psiReferenceArray;
    }

    private final Map<TextRange, PlaceholderInfo> getTextRangesWithNested(PsiElement element) {
        HashMap textRanges = new HashMap();
        Set<UrlSpecialSegmentMarker> prefixes = this.getPlaceholderPrefixes();
        for (UrlSpecialSegmentMarker prefixAndSuffix : prefixes) {
            String text = element.getText();
            for (TextRange textRange : PlaceholderTextRanges.getPlaceholderRanges((String)text, (String)prefixAndSuffix.getPrefix(), (String)prefixAndSuffix.getSuffix())) {
                String placeholderText;
                Intrinsics.checkNotNullExpressionValue((Object)textRange.substring(text), (String)"substring(...)");
                ((Map)textRanges).put(textRange, new PlaceholderInfo(placeholderText));
            }
        }
        return textRanges;
    }

    private final Map<TextRange, PlaceholderInfo> getFullTextRange(PsiElement element) {
        String string = ElementManipulators.getValueText((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValueText(...)");
        String text = string;
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        TextRange textRange2 = textRange;
        Map<TextRange, PlaceholderInfo> map = Collections.singletonMap(textRange2, new PlaceholderInfo(text));
        Intrinsics.checkNotNullExpressionValue(map, (String)"singletonMap(...)");
        return map;
    }

    private final Set<UrlSpecialSegmentMarker> getPlaceholderPrefixes() {
        return SetsKt.setOf((Object)MnBeansConstants.getMN_PLACEHOLDER_BRACES());
    }

    private final PsiReference[] createPlaceholderPropertiesReferences(Map<TextRange, PlaceholderInfo> textRanges, PsiElement valueElement) {
        if (valueElement == null || textRanges.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList references = new SmartList();
        for (Map.Entry<TextRange, PlaceholderInfo> entry : textRanges.entrySet()) {
            TextRange textRange = entry.getKey();
            PlaceholderInfo info = entry.getValue();
            if (this.hasNestedPlaceholders(textRange, textRanges.keySet())) continue;
            references.add((Object)MnPropertyReferenceContributor.createPlaceholderReference$default(this, valueElement, textRange, info, false, 8, null));
        }
        Collection $this$toTypedArray$iv = (Collection)references;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    private final boolean hasNestedPlaceholders(TextRange textRange, Set<? extends TextRange> ranges) {
        for (TextRange textRange2 : ranges) {
            if (Intrinsics.areEqual((Object)textRange2, (Object)textRange) || !textRange.contains(textRange2)) continue;
            return true;
        }
        return false;
    }

    private final PsiReference createPlaceholderReference(PsiElement element, TextRange textRange, PlaceholderInfo info, boolean asPrefix) {
        TextRange textRange2;
        String text = info.getText();
        int defaultValueSeparatorIndex = StringsKt.indexOf$default((CharSequence)text, (String)":", (int)0, (boolean)false, (int)6, null);
        if (defaultValueSeparatorIndex < 0) {
            textRange2 = textRange;
        } else {
            TextRange textRange3 = TextRange.from((int)textRange.getStartOffset(), (int)defaultValueSeparatorIndex);
            Intrinsics.checkNotNull((Object)textRange3);
            textRange2 = textRange3;
        }
        TextRange referenceRange = textRange2;
        return (PsiReference)new MnConfigPlaceholderReference.Builder(element, referenceRange, false).withMetaConfigKeyVariants().asPrefix(asPrefix).build();
    }

    static /* synthetic */ PsiReference createPlaceholderReference$default(MnPropertyReferenceContributor mnPropertyReferenceContributor, PsiElement psiElement, TextRange textRange, PlaceholderInfo placeholderInfo, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return mnPropertyReferenceContributor.createPlaceholderReference(psiElement, textRange, placeholderInfo, bl);
    }

    private static final PsiReference[] registerReferenceProviders$lambda$0(MnPropertyReferenceContributor this$0, UExpression uExpression, PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)uExpression, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this$0.createPropertyReferences((PsiElement)host);
    }

    private static final PsiReference[] registerReferenceProviders$lambda$1(MnPropertyReferenceContributor this$0, UExpression uExpression, PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)uExpression, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this$0.createEachPropertyReferences((PsiElement)host);
    }

    private static final PsiReference[] registerReferenceProviders$lambda$2(MnPropertyReferenceContributor this$0, UExpression uExpression, PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)uExpression, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this$0.createPropertyReferences((PsiElement)host);
    }

    private static final PsiReference[] registerReferenceProviders$lambda$3(MnPropertyReferenceContributor this$0, UExpression uExpression, PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)uExpression, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this$0.createPlaceholderPropertiesReferences((PsiElement)host);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/micronaut/provider/MnPropertyReferenceContributor$PlaceholderInfo;", "", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "intellij.micronaut"})
    private static final class PlaceholderInfo {
        @NotNull
        private final String text;

        public PlaceholderInfo(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }
    }
}

