/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.management;

import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautIcons;
import com.intellij.micronaut.jam.http.MnHttpUrlPathSpecification;
import com.intellij.micronaut.jam.management.MnManagementEndpoint;
import com.intellij.micronaut.jam.management.MnManagementMethod;
import com.intellij.micronaut.jam.management.MnManagementModel;
import com.intellij.micronaut.provider.management.MnManagementFramework;
import com.intellij.micronaut.provider.management.MnManagementUrlTargetInfo;
import com.intellij.micronaut.provider.management.MnManagementUtils;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.jvm.cache.SourceTestLibSearcher;
import com.intellij.microservices.jvm.url.UastUrlAttributeUtils;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.uast.UastModificationTracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00152\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/intellij/micronaut/provider/management/MnManagementFramework;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "Lcom/intellij/micronaut/jam/management/MnManagementEndpoint;", "Lcom/intellij/micronaut/jam/management/MnManagementMethod;", "<init>", "()V", "endpointsSearcher", "Lcom/intellij/microservices/jvm/cache/SourceTestLibSearcher;", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "getEndpointGroups", "", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "group", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "endpoint", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "isValidEndpoint", "", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "intellij.micronaut"})
public final class MnManagementFramework
implements EndpointsUrlTargetProvider<MnManagementEndpoint, MnManagementMethod> {
    @NotNull
    private final SourceTestLibSearcher<MnManagementEndpoint> endpointsSearcher = new SourceTestLibSearcher("MN_MANAGEMENT_ENDPOINTS", (Function2)endpointsSearcher.1.INSTANCE);
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("Micronaut-Management", MicronautBundle.message("micronaut.management.framework.title", new Object[0]), MicronautIcons.MicronautLogo);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_SERVER_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MnManagementUtils.hasManagementLibrary(project) ? EndpointsProvider.Status.HAS_ENDPOINTS : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<MnManagementEndpoint> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        return this.endpointsSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @NotNull
    public Iterable<MnManagementMethod> getEndpoints(@NotNull MnManagementEndpoint group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        List<MnManagementMethod> list = MnManagementModel.getManagementMethods((PsiClass)group.getPsiElement());
        Intrinsics.checkNotNullExpressionValue(list, (String)"getManagementMethods(...)");
        return list;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull MnManagementEndpoint group, @NotNull MnManagementMethod endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)((Object)endpoint), (String)"endpoint");
        return (ItemPresentation)new HttpMethodPresentation(MnManagementUtils.getManagementResourcePath(endpoint), endpoint.getHttpMethod(), ((PsiClass)group.getPsiElement()).getName(), JavaUltimateIcons.Web.RequestMapping, (TextAttributesKey)(UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)endpoint.getPsiElement()) ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null));
    }

    @NotNull
    public PsiElement getDocumentationElement(@NotNull MnManagementEndpoint group, @NotNull MnManagementMethod endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)((Object)endpoint), (String)"endpoint");
        PsiElement psiElement = endpoint.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        return psiElement;
    }

    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull MnManagementEndpoint group, @NotNull MnManagementMethod endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)((Object)endpoint), (String)"endpoint");
        UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(MnManagementUtils.getManagementResourcePath(endpoint));
        return CollectionsKt.listOf((Object)new MnManagementUrlTargetInfo(UrlConstants.HTTP_SCHEMES, urlPath, endpoint));
    }

    public boolean isValidEndpoint(@NotNull MnManagementEndpoint group, @NotNull MnManagementMethod endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)((Object)endpoint), (String)"endpoint");
        return endpoint.isValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }
}

