/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ModuleBasedConfigurationOptions;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.vmOptions.VMOption;
import com.intellij.execution.wsl.WslPath;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.light.LightJavaModule;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaRunConfigurationBase
extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>
implements CommonJavaRunConfigurationParameters,
ConfigurationWithCommandLineShortener {
    public JavaRunConfigurationBase(String name, @NotNull JavaRunConfigurationModule configurationModule, @NotNull ConfigurationFactory factory) {
        if (configurationModule == null) {
            JavaRunConfigurationBase.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            JavaRunConfigurationBase.$$$reportNull$$$0(1);
        }
        super(name, (RunConfigurationModule)configurationModule, factory);
    }

    public JavaRunConfigurationBase(@NotNull JavaRunConfigurationModule configurationModule, @NotNull ConfigurationFactory factory) {
        if (configurationModule == null) {
            JavaRunConfigurationBase.$$$reportNull$$$0(2);
        }
        if (factory == null) {
            JavaRunConfigurationBase.$$$reportNull$$$0(3);
        }
        super((RunConfigurationModule)configurationModule, factory);
    }

    @Nullable
    public String findJavaModuleName(boolean inTests) {
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        if (module == null) {
            return null;
        }
        PsiJavaModule javaModule = JavaPsiModuleUtil.findDescriptorByModule((Module)module, (boolean)inTests);
        if (javaModule == null) {
            return null;
        }
        if (javaModule instanceof LightJavaModule) {
            return null;
        }
        return javaModule.getName();
    }

    private boolean jdkHomeSatisfies(Predicate<String> condition) {
        String path = this.getAlternativeJrePath();
        if (path != null) {
            String homePath;
            Sdk sdk = ProjectJdkTable.getInstance().findJdk(path);
            if (sdk != null && (homePath = sdk.getHomePath()) != null) {
                return condition.test(homePath);
            }
            return condition.test(path);
        }
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        if (module != null) {
            Sdk sdk;
            try {
                sdk = JavaParameters.getValidJdkToRunModule((Module)module, (boolean)false);
            }
            catch (CantRunException e) {
                return false;
            }
            String sdkHomePath = sdk.getHomePath();
            return sdkHomePath != null && condition.test(sdkHomePath);
        }
        return false;
    }

    protected boolean runsUnderRemoteJdk() {
        return this.jdkHomeSatisfies(homePath -> EelProviderUtil.getEelDescriptor((Path)Path.of(homePath, new String[0])) != LocalEelDescriptor.INSTANCE);
    }

    @ApiStatus.Obsolete
    protected boolean runsUnderWslJdk() {
        return this.jdkHomeSatisfies(WslPath::isWslUncPath);
    }

    @Override
    public List<ModuleBasedConfigurationOptions.ClasspathModification> getClasspathModifications() {
        return this.getOptions().getClasspathModifications();
    }

    @Override
    public void setClasspathModifications(List<ModuleBasedConfigurationOptions.ClasspathModification> modifications) {
        this.getOptions().setClasspathModifications(modifications);
    }

    public List<VMOption> getKnownVMOptions() {
        return List.of(VMOption.property("java.awt.headless", "bool", "Run the application in headless mode", null), VMOption.property("user.home", "string", "User home directory", null), VMOption.property("user.dir", "string", "User working directory", null), VMOption.property("user.name", "string", "User account name", null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "configurationModule";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "factory";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/JavaRunConfigurationBase";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

