/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.diagnostic.logging.OutputFileUtil;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.CompositeParameterTargetedValue;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.filters.ArgumentFileFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.EelTargetEnvironmentRequest;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.testDiscovery.JvmToggleAutoTestAction;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestProxyRoot;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.java.JavaPluginDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.net.NetUtils;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public abstract class JavaTestFrameworkRunnableState<T extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element> & ConfigurationWithCommandLineShortener>
extends JavaCommandLineState
implements RemoteConnectionCreator {
    private static final Logger LOG = Logger.getInstance(JavaTestFrameworkRunnableState.class);
    private static final ExtensionPointName<JUnitPatcher> JUNIT_PATCHER_EP = new ExtensionPointName("com.intellij.junitPatcher");
    private static final String JIGSAW_OPTIONS = "Jigsaw Options";
    @Nullable
    private TargetBoundServerSocket myTargetBoundServerSocket;
    protected File myTempFile;
    protected File myWorkingDirsFile = null;
    private RemoteConnectionCreator remoteConnectionCreator;
    private final List<ArgumentFileFilter> myArgumentFileFilters = new ArrayList<ArgumentFileFilter>();
    @Nullable
    private volatile TargetProgressIndicator myTargetProgressIndicator = null;
    private ServerSocket myForkSocket = null;

    public static ParamsGroup getJigsawOptions(JavaParameters parameters) {
        return parameters.getVMParametersList().getParamsGroup(JIGSAW_OPTIONS);
    }

    public static ParamsGroup getOrCreateJigsawOptions(JavaParameters parameters) {
        ParamsGroup group = JavaTestFrameworkRunnableState.getJigsawOptions(parameters);
        if (group != null) {
            return group;
        }
        return parameters.getVMParametersList().addParamsGroup(JIGSAW_OPTIONS);
    }

    @Nullable
    protected final ServerSocket getServerSocket() {
        return this.myTargetBoundServerSocket != null ? this.myTargetBoundServerSocket.getServerSocket() : null;
    }

    public void setRemoteConnectionCreator(RemoteConnectionCreator remoteConnectionCreator) {
        this.remoteConnectionCreator = remoteConnectionCreator;
    }

    @Override
    @Nullable
    public RemoteConnection createRemoteConnection(ExecutionEnvironment environment) {
        return this.remoteConnectionCreator == null ? super.createRemoteConnection(environment) : this.remoteConnectionCreator.createRemoteConnection(environment);
    }

    @Override
    public boolean isPollConnection() {
        return this.remoteConnectionCreator != null ? this.remoteConnectionCreator.isPollConnection() : super.isPollConnection();
    }

    public JavaTestFrameworkRunnableState(ExecutionEnvironment environment) {
        super(environment);
    }

    @NotNull
    protected abstract String getFrameworkName();

    @NotNull
    protected abstract String getFrameworkId();

    protected abstract void passTempFile(ParametersList var1, String var2);

    @NotNull
    protected abstract T getConfiguration();

    @Nullable
    protected abstract TestSearchScope getScope();

    @NotNull
    protected abstract String getForkMode();

    @NotNull
    private OSProcessHandler createHandler(SMTestRunnerResultsForm viewer) throws ExecutionException {
        TargetEnvironment remoteEnvironment = this.getEnvironment().getPreparedTargetEnvironment((RunProfileState)this, TargetProgressIndicator.EMPTY);
        TargetedCommandLineBuilder targetedCommandLineBuilder = this.getTargetedCommandLine();
        TargetedCommandLine targetedCommandLine = targetedCommandLineBuilder.build();
        this.resolveServerSocketPort(remoteEnvironment);
        Process process = remoteEnvironment.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
        SearchForTestsTask searchForTestsTask = this.createSearchingForTestsTask(remoteEnvironment);
        if (searchForTestsTask != null) {
            searchForTestsTask.arrangeForIndexAccess();
            searchForTestsTask.setIncompleteIndexUsageCallback(() -> viewer.setIncompleteIndexUsed());
        }
        KillableColoredProcessHandler.Silent processHandler = new KillableColoredProcessHandler.Silent(process, targetedCommandLine.getCommandPresentation(remoteEnvironment), targetedCommandLine.getCharset(), targetedCommandLineBuilder.getFilesToDeleteOnTermination());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        if (searchForTestsTask != null) {
            searchForTestsTask.attachTaskToProcess((OSProcessHandler)processHandler);
        }
        KillableColoredProcessHandler.Silent silent = processHandler;
        if (silent == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(0);
        }
        return silent;
    }

    public void downloadAdditionalDependencies(JavaParameters javaParameters) throws ExecutionException {
    }

    @Override
    public TargetEnvironmentRequest createCustomTargetEnvironmentRequest() {
        EelTargetEnvironmentRequest.Configuration config;
        Sdk sdk = null;
        String alternativeJrePath = ((CommonJavaRunConfigurationParameters)this.getConfiguration()).getAlternativeJrePath();
        if (alternativeJrePath != null && (sdk = ProjectJdkTable.getInstance((Project)this.getConfiguration().getProject()).findJdk(alternativeJrePath)) == null) {
            sdk = SimpleJavaSdkType.getInstance().createJdk(alternativeJrePath, alternativeJrePath);
        }
        if (sdk == null) {
            sdk = this.getJdk();
        }
        return (config = JavaTestFrameworkRunnableState.checkCreateNonLocalConfiguration(sdk)) == null ? null : new EelTargetEnvironmentRequest(config);
    }

    public void resolveServerSocketPort(@NotNull TargetEnvironment remoteEnvironment) throws ExecutionException {
        if (remoteEnvironment == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(1);
        }
        if (this.myTargetBoundServerSocket != null) {
            this.myTargetBoundServerSocket.bind(remoteEnvironment);
        }
    }

    @Nullable
    public SearchForTestsTask createSearchingForTestsTask(@NotNull TargetEnvironment targetEnvironment) throws ExecutionException {
        if (targetEnvironment == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(2);
        }
        return null;
    }

    protected boolean configureByModule(Module module) {
        return module != null;
    }

    protected boolean isIdBasedTestTree() {
        return false;
    }

    protected boolean isPrintAsyncStackTraceForExceptions() {
        return true;
    }

    @Override
    public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @NotNull TargetProgressIndicator targetProgressIndicator) throws ExecutionException {
        if (request == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(3);
        }
        if (targetProgressIndicator == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(4);
        }
        this.myTargetProgressIndicator = targetProgressIndicator;
        T myConfiguration = this.getConfiguration();
        if (myConfiguration.getProjectPathOnTarget() != null) {
            request.setProjectPathOnTarget(myConfiguration.getProjectPathOnTarget());
        }
        super.prepareTargetEnvironmentRequest(request, targetProgressIndicator);
    }

    @ApiStatus.Internal
    @Nullable
    protected final TargetProgressIndicator getTargetProgressIndicator() {
        return this.myTargetProgressIndicator;
    }

    @Override
    @NotNull
    protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request) throws ExecutionException {
        Map content;
        if (request == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(5);
        }
        this.downloadAdditionalDependencies(this.getJavaParameters());
        this.appendForkInfo(this.getEnvironment().getExecutor());
        this.appendRepeatMode();
        boolean asyncStackTraceForExceptions = this.isPrintAsyncStackTraceForExceptions();
        if (asyncStackTraceForExceptions && Registry.is((String)"debugger.async.stack.trace.for.exceptions.printing", (boolean)false)) {
            AsyncStacksUtils.addDebuggerAgent((JavaParameters)this.getJavaParameters(), (Project)this.getEnvironment().getProject(), (boolean)true);
        }
        TargetedCommandLineBuilder commandLineBuilder = super.createTargetedCommandLine(request);
        File inputFile = InputRedirectAware.getInputFile(this.getConfiguration());
        if (inputFile != null) {
            commandLineBuilder.setInputFile(request.getDefaultVolume().createUpload(inputFile.getAbsolutePath()));
        }
        if ((content = (Map)commandLineBuilder.getUserData(JdkUtil.COMMAND_LINE_CONTENT)) != null) {
            content.forEach((key, value) -> this.myArgumentFileFilters.add(new ArgumentFileFilter(key, value)));
        }
        TargetedCommandLineBuilder targetedCommandLineBuilder = commandLineBuilder;
        if (targetedCommandLineBuilder == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(6);
        }
        return targetedCommandLineBuilder;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (executor == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(7);
        }
        if (runner == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(8);
        }
        RunnerSettings runnerSettings = this.getRunnerSettings();
        SMTRunnerConsoleProperties testConsoleProperties = ((SMRunnerConsolePropertiesProvider)this.getConfiguration()).createTestConsoleProperties(executor);
        testConsoleProperties.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
        testConsoleProperties.setIdBasedTestTree(this.isIdBasedTestTree());
        BaseTestsOutputConsoleView testConsole = (BaseTestsOutputConsoleView)UIUtil.invokeAndWaitIfNeeded(() -> SMTestRunnerConnectionUtil.createConsole((String)this.getFrameworkName(), (TestConsoleProperties)testConsoleProperties));
        SMTestRunnerResultsForm viewer = ((SMTRunnerConsoleView)testConsole).getResultsViewer();
        ConsoleView consoleView = JavaRunConfigurationExtensionManager.getInstance().decorateExecutionConsole(this.getConfiguration(), this.getRunnerSettings(), (ConsoleView)testConsole, executor);
        Disposer.register((Disposable)JavaPluginDisposable.getInstance((Project)this.getConfiguration().getProject()), (Disposable)consoleView);
        final OSProcessHandler handler = this.createHandler(viewer);
        for (ArgumentFileFilter filter : this.myArgumentFileFilters) {
            consoleView.addMessageFilter((Filter)filter);
        }
        consoleView.attachToProcess((ProcessHandler)handler);
        final AbstractTestProxy root = viewer.getRoot();
        if (root instanceof TestProxyRoot) {
            ((TestProxyRoot)root).setHandler((ProcessHandler)handler);
        }
        handler.addProcessListener(new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (JavaTestFrameworkRunnableState.this.getConfiguration().isSaveOutputToFile()) {
                    File file = OutputFileUtil.getOutputFile(JavaTestFrameworkRunnableState.this.getConfiguration());
                    root.setOutputFilePath(file != null ? file.getAbsolutePath() : null);
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                Runnable runnable = () -> {
                    root.flushOutputFile();
                    JavaTestFrameworkRunnableState.this.deleteTempFiles();
                    JavaTestFrameworkRunnableState.this.clear();
                };
                UIUtil.invokeLaterIfNeeded((Runnable)runnable);
                handler.removeProcessListener((ProcessListener)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/execution/JavaTestFrameworkRunnableState$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        AbstractRerunFailedTestsAction rerunFailedTestsAction = testConsoleProperties.createRerunFailedTestsAction((ConsoleView)testConsole);
        LOG.assertTrue(rerunFailedTestsAction != null);
        rerunFailedTestsAction.setModelProvider(() -> viewer);
        DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)handler);
        result.setRestartActions(new AnAction[]{rerunFailedTestsAction, new JvmToggleAutoTestAction()});
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.getConfiguration(), (ProcessHandler)handler, runnerSettings);
        DefaultExecutionResult defaultExecutionResult = result;
        if (defaultExecutionResult == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(9);
        }
        return defaultExecutionResult;
    }

    protected abstract void configureRTClasspath(JavaParameters var1, Module var2) throws CantRunException;

    protected Sdk getJdk() {
        Project project = this.getConfiguration().getProject();
        Module module = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        return module == null ? ProjectRootManager.getInstance((Project)project).getProjectSdk() : ModuleRootManager.getInstance((Module)module).getSdk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = new JavaParameters();
        Project project = this.getConfiguration().getProject();
        Module module = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        javaParameters.setJdk(this.getJdk());
        String parameters = ((CommonProgramRunConfigurationParameters)this.getConfiguration()).getProgramParameters();
        ((CommonProgramRunConfigurationParameters)this.getConfiguration()).setProgramParameters(null);
        try {
            JavaParametersUtil.configureConfiguration((SimpleJavaParameters)javaParameters, (CommonJavaRunConfigurationParameters)this.getConfiguration());
        }
        finally {
            ((CommonProgramRunConfigurationParameters)this.getConfiguration()).setProgramParameters(parameters);
        }
        ReadAction.run(() -> {
            this.configureClasspath(javaParameters);
            javaParameters.getClassPath().addFirst(JavaSdkUtil.getIdeaRtJarPath());
            javaParameters.setShortenCommandLine(((ConfigurationWithCommandLineShortener)this.getConfiguration()).getShortenCommandLine(), project);
            for (JUnitPatcher patcher : JUNIT_PATCHER_EP.getExtensionList()) {
                patcher.patchJavaParameters(project, module, javaParameters);
            }
            JavaRunConfigurationExtensionManager.getInstance().updateJavaParameters(this.getConfiguration(), javaParameters, this.getRunnerSettings(), this.getEnvironment().getExecutor());
        });
        if (!StringUtil.isEmptyOrSpaces((String)parameters)) {
            javaParameters.getProgramParametersList().addAll(this.getNamedParams(parameters));
        }
        if (ConsoleBuffer.useCycleBuffer()) {
            javaParameters.getVMParametersList().addProperty("idea.test.cyclic.buffer.size", String.valueOf(ConsoleBuffer.getCycleBufferSize()));
        }
        return javaParameters;
    }

    @Override
    protected boolean isReadActionRequired() {
        return false;
    }

    protected List<String> getNamedParams(String parameters) {
        return Collections.singletonList("@name" + parameters);
    }

    @Nullable
    public ServerSocket getForkSocket() {
        if (this.myForkSocket == null && (!Comparing.strEqual((String)this.getForkMode(), (String)"none") || this.forkPerModule()) && this.getRunnerSettings() != null) {
            try {
                this.myForkSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return this.myForkSocket;
    }

    private boolean isExecutorDisabledInForkedMode() {
        RunnerSettings settings = this.getRunnerSettings();
        return settings != null && !(settings instanceof GenericDebuggerRunnerSettings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendForkInfo(Executor executor) throws ExecutionException {
        JavaParameters javaParameters;
        Sdk jdk;
        String forkMode = this.getForkMode();
        if (Comparing.strEqual((String)forkMode, (String)"none")) {
            if (!this.forkPerModule()) return;
            if (this.isExecutorDisabledInForkedMode()) {
                String actionName = executor.getActionName();
                throw new CantRunException(JavaCompilerBundle.message((String)"action.disabled.when.per.module.working.directory.configured", (Object[])new Object[]{actionName}));
            }
        } else if (this.isExecutorDisabledInForkedMode()) {
            String actionName = executor.getActionName();
            throw new CantRunException(JavaCompilerBundle.message((String)"action.disabled.in.fork.mode", (Object[])new Object[]{actionName, StringUtil.toLowerCase((String)actionName)}));
        }
        if ((jdk = (javaParameters = this.getJavaParameters()).getJdk()) == null) {
            throw new ExecutionException(ExecutionBundle.message((String)"run.configuration.error.no.jdk.specified", (Object[])new Object[0]));
        }
        try {
            File tempFile = FileUtil.createTempFile((String)"command.line", (String)"", (boolean)true);
            try (PrintWriter writer = new PrintWriter(tempFile, StandardCharsets.UTF_8);){
                boolean useDynamicClasspathForForkMode;
                ShortenCommandLine shortenCommandLine = ((ConfigurationWithCommandLineShortener)this.getConfiguration()).getShortenCommandLine();
                boolean bl = shortenCommandLine == null ? JdkUtil.useDynamicClasspath((Project)this.getConfiguration().getProject()) : (useDynamicClasspathForForkMode = shortenCommandLine != ShortenCommandLine.NONE);
                if (shortenCommandLine == ShortenCommandLine.ARGS_FILE) {
                    writer.println(shortenCommandLine);
                } else if (useDynamicClasspathForForkMode && this.forkPerModule()) {
                    writer.println("use classpath jar");
                } else {
                    writer.println("");
                }
                writer.println(((JavaSdkType)jdk.getSdkType()).getVMExecutablePath(jdk));
                for (String vmParameter : javaParameters.getVMParametersList().getList()) {
                    writer.println(vmParameter);
                }
            }
            this.passForkMode(this.getForkMode(), tempFile, javaParameters);
            return;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected abstract void passForkMode(String var1, File var2, JavaParameters var3) throws ExecutionException;

    protected void collectListeners(JavaParameters javaParameters, StringBuilder buf, String epName, String delimiter) {
        T configuration = this.getConfiguration();
        for (Object listener : Extensions.getRootArea().getExtensionPoint(epName).getExtensionList()) {
            boolean enabled2 = true;
            for (RunConfigurationExtension ext : RunConfigurationExtension.EP_NAME.getExtensionList()) {
                if (!ext.isListenerDisabled((RunConfigurationBase<?>)configuration, listener, this.getRunnerSettings())) continue;
                enabled2 = false;
                break;
            }
            if (!enabled2) continue;
            if (!buf.isEmpty()) {
                buf.append(delimiter);
            }
            Class<?> classListener = listener.getClass();
            buf.append(classListener.getName());
            javaParameters.getClassPath().add(PathUtil.getJarPathForClass(classListener));
        }
    }

    protected void configureClasspath(JavaParameters javaParameters) throws CantRunException {
        RunConfigurationModule configurationModule = this.getConfiguration().getConfigurationModule();
        String jreHome = this.getTargetEnvironmentRequest() == null && ((CommonJavaRunConfigurationParameters)this.getConfiguration()).isAlternativeJrePathEnabled() ? ((CommonJavaRunConfigurationParameters)this.getConfiguration()).getAlternativeJrePath() : null;
        int pathType = 7;
        Module module = configurationModule.getModule();
        if (this.configureByModule(module)) {
            JavaParametersUtil.configureModule(configurationModule, javaParameters, 7, jreHome);
            LOG.assertTrue(module != null);
            if (JavaSdkUtil.isJdkAtLeast((Sdk)javaParameters.getJdk(), (JavaSdkVersion)JavaSdkVersion.JDK_1_9)) {
                this.configureModulePath(javaParameters, module);
            }
        } else {
            JavaParametersUtil.configureProject(this.getConfiguration().getProject(), javaParameters, 7, jreHome);
        }
        this.configureRTClasspath(javaParameters, module);
    }

    protected static PsiJavaModule findJavaModule(Module module, boolean inTests) {
        return (PsiJavaModule)DumbService.getInstance((Project)module.getProject()).computeWithAlternativeResolveEnabled(() -> JavaModuleGraphUtil.findNonAutomaticDescriptorByModule((Module)module, (boolean)inTests));
    }

    private void configureModulePath(JavaParameters javaParameters, @NotNull Module module) {
        if (module == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(10);
        }
        if (!this.useModulePath()) {
            return;
        }
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            PsiJavaModule testModule = JavaTestFrameworkRunnableState.findJavaModule(module, true);
            if (testModule != null) {
                ParametersList vmParametersList = javaParameters.getVMParametersList().addParamsGroup(JIGSAW_OPTIONS).getParametersList();
                vmParametersList.add("--add-modules");
                vmParametersList.add(testModule.getName());
                JavaParametersUtil.putDependenciesOnModulePath(javaParameters, testModule, true);
            } else {
                PsiJavaModule prodModule = JavaTestFrameworkRunnableState.findJavaModule(module, false);
                if (prodModule != null) {
                    this.splitDepsBetweenModuleAndClasspath(javaParameters, module, prodModule);
                }
            }
        });
    }

    private void splitDepsBetweenModuleAndClasspath(JavaParameters javaParameters, Module module, PsiJavaModule prodModule) {
        CompilerModuleExtension compilerExt = CompilerModuleExtension.getInstance((Module)module);
        if (compilerExt == null) {
            return;
        }
        JavaParametersUtil.putDependenciesOnModulePath(javaParameters, prodModule, true);
        ParametersList vmParametersList = javaParameters.getVMParametersList().addParamsGroup(JIGSAW_OPTIONS).getParametersList();
        String prodModuleName = prodModule.getName();
        VirtualFile testOutput = compilerExt.getCompilerOutputPathForTests();
        if (testOutput != null) {
            vmParametersList.add("--patch-module");
            vmParametersList.add(new CompositeParameterTargetedValue().addLocalPart(prodModuleName + "=").addPathPart(testOutput.getPath()));
        }
        vmParametersList.add("--add-reads");
        vmParametersList.add(prodModuleName + "=ALL-UNNAMED");
        ArrayList<String> opensOptions = new ArrayList<String>();
        this.collectPackagesToOpen(opensOptions);
        for (String option : opensOptions) {
            if (option.isEmpty()) continue;
            vmParametersList.add("--add-opens");
            vmParametersList.add(prodModuleName + "/" + option + "=ALL-UNNAMED");
        }
        vmParametersList.add("--add-modules");
        vmParametersList.add(prodModuleName);
    }

    protected void collectPackagesToOpen(List<String> options) {
    }

    protected static void collectSubPackages(List<String> options, @NotNull PsiPackage aPackage, GlobalSearchScope globalSearchScope) {
        PsiPackage[] subPackages;
        if (aPackage == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(11);
        }
        if (aPackage.getClasses(globalSearchScope).length > 0) {
            options.add(aPackage.getQualifiedName());
        }
        for (PsiPackage subPackage : subPackages = aPackage.getSubPackages(globalSearchScope)) {
            JavaTestFrameworkRunnableState.collectSubPackages(options, subPackage, globalSearchScope);
        }
    }

    protected void createServerSocket(JavaParameters javaParameters) {
        try {
            this.myTargetBoundServerSocket = TargetBoundServerSocket.fromRequest(this.getTargetEnvironmentRequest());
            int localPort = this.myTargetBoundServerSocket.getLocalPort();
            AsyncPromise<String> hostPortPromise = this.myTargetBoundServerSocket.getHostPortPromise();
            javaParameters.getProgramParametersList().add(new CompositeParameterTargetedValue("-socket").addTargetPart(String.valueOf(localPort), hostPortPromise));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected boolean spansMultipleModules(String qualifiedName) {
        SourceScope sourceScope;
        TestSearchScope scope;
        Project project;
        PsiPackage aPackage;
        if (qualifiedName != null && (aPackage = JavaPsiFacade.getInstance((Project)(project = this.getConfiguration().getProject())).findPackage(qualifiedName)) != null && (scope = this.getScope()) != null && (sourceScope = scope.getSourceScope(this.getConfiguration())) != null) {
            GlobalSearchScope configurationSearchScope = GlobalSearchScopesCore.projectTestScope((Project)project).intersectWith(sourceScope.getGlobalSearchScope());
            PsiDirectory[] directories = aPackage.getDirectories(configurationSearchScope);
            return Arrays.stream(directories).map(dir -> ModuleUtilCore.findModuleForFile((VirtualFile)dir.getVirtualFile(), (Project)project)).filter(Objects::nonNull).distinct().count() > 1L;
        }
        return false;
    }

    protected boolean forkPerModule() {
        return this.getScope() != TestSearchScope.SINGLE_MODULE && JavaTestFrameworkRunnableState.toChangeWorkingDirectory(((CommonProgramRunConfigurationParameters)this.getConfiguration()).getWorkingDirectory()) && (Boolean)ReadAction.compute(() -> this.spansMultipleModules(((CommonJavaRunConfigurationParameters)this.getConfiguration()).getPackage())) != false;
    }

    private static boolean toChangeWorkingDirectory(String workingDirectory) {
        return "$MODULE_DIR$".equals(workingDirectory) || "$MODULE_WORKING_DIR$".equals(workingDirectory) || "%MODULE_WORKING_DIR%".equals(workingDirectory);
    }

    protected void createTempFiles(JavaParameters javaParameters) {
        try {
            this.myWorkingDirsFile = FileUtil.createTempFile((String)("idea_working_dirs_" + this.getFrameworkId()), (String)".tmp", (boolean)true);
            javaParameters.getProgramParametersList().add(new CompositeParameterTargetedValue().addLocalPart("@w@").addPathPart(this.myWorkingDirsFile));
            this.myTempFile = FileUtil.createTempFile((String)("idea_" + this.getFrameworkId()), (String)".tmp", (boolean)true);
            this.passTempFile(javaParameters.getProgramParametersList(), this.myTempFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    protected void writeClassesPerModule(String packageName, JavaParameters javaParameters, Map<Module, List<String>> perModule, @NotNull String filters) throws IOException {
        if (filters == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(12);
        }
        if (perModule != null) {
            String classpath = this.getScope() == TestSearchScope.WHOLE_PROJECT ? null : javaParameters.getClassPath().getPathsString();
            T configuration = this.getConfiguration();
            String workingDirectory = ((CommonProgramRunConfigurationParameters)configuration).getWorkingDirectory();
            boolean toChangeWorkingDirectory = JavaTestFrameworkRunnableState.toChangeWorkingDirectory(workingDirectory);
            try (PrintWriter wWriter = new PrintWriter(this.myWorkingDirsFile, StandardCharsets.UTF_8);){
                Project project = configuration.getProject();
                String jreHome = ((CommonJavaRunConfigurationParameters)configuration).isAlternativeJrePathEnabled() ? ((CommonJavaRunConfigurationParameters)configuration).getAlternativeJrePath() : null;
                wWriter.println(packageName);
                for (Module module : perModule.keySet()) {
                    wWriter.println(toChangeWorkingDirectory ? ProgramParametersUtil.getWorkingDir((CommonProgramRunConfigurationParameters)((CommonProgramRunConfigurationParameters)configuration), (Project)project, (Module)module) : workingDirectory);
                    wWriter.println(module.getName());
                    if (classpath == null) {
                        JavaParameters parameters = new JavaParameters();
                        try {
                            JavaParametersUtil.configureModule(module, parameters, 7, jreHome);
                            if (JavaSdkUtil.isJdkAtLeast((Sdk)parameters.getJdk(), (JavaSdkVersion)JavaSdkVersion.JDK_1_9)) {
                                this.configureModulePath(parameters, module);
                            }
                            this.configureRTClasspath(parameters, module);
                            parameters.getClassPath().add(JavaSdkUtil.getIdeaRtJarPath());
                            JavaTestFrameworkRunnableState.writeClasspath(wWriter, parameters);
                        }
                        catch (CantRunException e) {
                            JavaTestFrameworkRunnableState.writeClasspath(wWriter, javaParameters);
                        }
                    } else {
                        JavaTestFrameworkRunnableState.writeClasspath(wWriter, javaParameters);
                    }
                    List<String> classNames = perModule.get(module);
                    wWriter.println(classNames.size());
                    for (String className : classNames) {
                        wWriter.println(className);
                    }
                    wWriter.println(filters);
                }
            }
        }
    }

    private static void writeClasspath(PrintWriter wWriter, JavaParameters parameters) {
        wWriter.println(parameters.getClassPath().getPathsString());
        wWriter.println(parameters.getModulePath().getPathsString());
        ParamsGroup paramsGroup = JavaTestFrameworkRunnableState.getJigsawOptions(parameters);
        if (paramsGroup == null) {
            wWriter.println(0);
        } else {
            List parametersList = paramsGroup.getParametersList().getList();
            wWriter.println(parametersList.size());
            for (String option : parametersList) {
                wWriter.println(option);
            }
        }
    }

    protected void deleteTempFiles() {
        if (this.myTempFile != null) {
            FileUtil.delete((File)this.myTempFile);
        }
        if (this.myWorkingDirsFile != null) {
            FileUtil.delete((File)this.myWorkingDirsFile);
        }
    }

    public void appendRepeatMode() throws ExecutionException {
    }

    protected boolean useModulePath() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/JavaTestFrameworkRunnableState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteEnvironment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironment";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProgressIndicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/JavaTestFrameworkRunnableState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetedCommandLine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveServerSocketPort";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSearchingForTestsTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareTargetEnvironmentRequest";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTargetedCommandLine";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "configureModulePath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectSubPackages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeClassesPerModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 8, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }

    private static final class TargetBoundServerSocket {
        private final int myLocalPort;
        @Nullable
        private final TargetEnvironment.LocalPortBinding myLocalPortBinding;
        @NotNull
        private final Object myLock;
        @Nullable
        private ServerSocket myServerSocket;
        @NotNull
        private final AsyncPromise<String> myHostPortPromise;

        private TargetBoundServerSocket(int localPort) {
            this.myLock = new Object();
            this.myHostPortPromise = new AsyncPromise();
            this.myLocalPortBinding = null;
            this.myLocalPort = localPort;
        }

        private TargetBoundServerSocket(@NotNull TargetEnvironment.LocalPortBinding localPortBinding) {
            if (localPortBinding == null) {
                TargetBoundServerSocket.$$$reportNull$$$0(0);
            }
            this.myLock = new Object();
            this.myHostPortPromise = new AsyncPromise();
            this.myLocalPortBinding = localPortBinding;
            this.myLocalPort = localPortBinding.getLocal();
        }

        public int getLocalPort() {
            return this.myLocalPort;
        }

        @NotNull
        public AsyncPromise<String> getHostPortPromise() {
            AsyncPromise<String> asyncPromise = this.myHostPortPromise;
            if (asyncPromise == null) {
                TargetBoundServerSocket.$$$reportNull$$$0(1);
            }
            return asyncPromise;
        }

        public void bind(@NotNull TargetEnvironment targetEnvironment) throws ExecutionException {
            Object hostPort;
            if (targetEnvironment == null) {
                TargetBoundServerSocket.$$$reportNull$$$0(2);
            }
            try {
                String serverHost;
                boolean local = targetEnvironment instanceof LocalTargetEnvironment;
                if (local) {
                    serverHost = "127.0.0.1";
                    hostPort = String.valueOf(this.myLocalPort);
                } else {
                    ResolvedPortBinding resolvedPortBinding = (ResolvedPortBinding)targetEnvironment.getLocalPortBindings().get(this.myLocalPortBinding);
                    serverHost = resolvedPortBinding.getLocalEndpoint().getHost();
                    HostPort targetHostPort = resolvedPortBinding.getTargetEndpoint();
                    hostPort = targetHostPort.getHost() + ":" + targetHostPort.getPort();
                }
                this.createServerSocketImpl(serverHost);
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
            this.myHostPortPromise.setResult(hostPort);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        private ServerSocket createServerSocketImpl(@NotNull String host) throws IOException {
            ServerSocket socket;
            if (host == null) {
                TargetBoundServerSocket.$$$reportNull$$$0(3);
            }
            Object object = this.myLock;
            // MONITORENTER : object
            if (this.myServerSocket != null) {
                throw new IllegalStateException("Server socket already created");
            }
            this.myServerSocket = socket = new ServerSocket(this.myLocalPort, 0, InetAddress.getByName(host));
            ServerSocket serverSocket = socket;
            // MONITOREXIT : object
            if (serverSocket != null) return serverSocket;
            TargetBoundServerSocket.$$$reportNull$$$0(4);
            return serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public ServerSocket getServerSocket() {
            Object object = this.myLock;
            // MONITORENTER : object
            if (this.myServerSocket == null) {
                throw new IllegalStateException("Server socket must be resolved");
            }
            ServerSocket serverSocket = this.myServerSocket;
            // MONITOREXIT : object
            if (serverSocket != null) return serverSocket;
            TargetBoundServerSocket.$$$reportNull$$$0(5);
            return serverSocket;
        }

        @NotNull
        public static TargetBoundServerSocket fromRequest(@Nullable TargetEnvironmentRequest targetEnvironmentRequest) throws IOException {
            int serverPort = NetUtils.findAvailableSocketPort();
            if (targetEnvironmentRequest != null) {
                TargetEnvironment.LocalPortBinding localPortBinding = new TargetEnvironment.LocalPortBinding(serverPort, null);
                targetEnvironmentRequest.getLocalPortBindings().add(localPortBinding);
                return new TargetBoundServerSocket(localPortBinding);
            }
            return new TargetBoundServerSocket(serverPort);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPortBinding";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/JavaTestFrameworkRunnableState$TargetBoundServerSocket";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetEnvironment";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/JavaTestFrameworkRunnableState$TargetBoundServerSocket";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHostPortPromise";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createServerSocketImpl";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServerSocket";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "bind";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createServerSocketImpl";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

