/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/TargetDebuggerConnection;", "", "remoteConnection", "Lcom/intellij/execution/configurations/RemoteConnection;", "debuggerPortRequest", "Lcom/intellij/execution/target/TargetEnvironment$TargetPortBinding;", "<init>", "(Lcom/intellij/execution/configurations/RemoteConnection;Lcom/intellij/execution/target/TargetEnvironment$TargetPortBinding;)V", "getDebuggerPortRequest", "()Lcom/intellij/execution/target/TargetEnvironment$TargetPortBinding;", "remoteConnectionResolved", "", "resolveRemoteConnection", "", "environment", "Lcom/intellij/execution/target/TargetEnvironment;", "getResolvedRemoteConnection", "intellij.java.execution.impl"})
public final class TargetDebuggerConnection {
    @NotNull
    private final RemoteConnection remoteConnection;
    @NotNull
    private final TargetEnvironment.TargetPortBinding debuggerPortRequest;
    private boolean remoteConnectionResolved;

    public TargetDebuggerConnection(@NotNull RemoteConnection remoteConnection, @NotNull TargetEnvironment.TargetPortBinding debuggerPortRequest) {
        Intrinsics.checkNotNullParameter((Object)remoteConnection, (String)"remoteConnection");
        Intrinsics.checkNotNullParameter((Object)debuggerPortRequest, (String)"debuggerPortRequest");
        this.remoteConnection = remoteConnection;
        this.debuggerPortRequest = debuggerPortRequest;
    }

    @NotNull
    public final TargetEnvironment.TargetPortBinding getDebuggerPortRequest() {
        return this.debuggerPortRequest;
    }

    public final void resolveRemoteConnection(@NotNull TargetEnvironment environment) {
        RemoteConnection remoteConnection;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        ResolvedPortBinding resolvedPortBinding = (ResolvedPortBinding)environment.getTargetPortBindings().get(this.debuggerPortRequest);
        if (resolvedPortBinding == null) {
            throw new IllegalStateException(("Target port binding " + this.debuggerPortRequest + " could not be found in the environment: " + environment).toString());
        }
        HostPort localEndpoint = resolvedPortBinding.component1();
        RemoteConnection $this$resolveRemoteConnection_u24lambda_u240 = remoteConnection = this.remoteConnection;
        boolean bl = false;
        $this$resolveRemoteConnection_u24lambda_u240.setDebuggerHostName(localEndpoint.getHost());
        $this$resolveRemoteConnection_u24lambda_u240.setDebuggerAddress(String.valueOf(localEndpoint.getPort()));
        this.remoteConnectionResolved = true;
    }

    @NotNull
    public final RemoteConnection getResolvedRemoteConnection() {
        if (!this.remoteConnectionResolved) {
            throw new IllegalStateException("The connection parameters to the debugger must be resolved with the target environment");
        }
        return this.remoteConnection;
    }
}

