/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.TargetDebuggerConnection;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TargetDebuggerConnectionUtil {
    private TargetDebuggerConnectionUtil() {
    }

    @Nullable
    private static Integer requiredDebuggerTargetPort(@NotNull JavaCommandLineState javaCommandLineState, @NotNull TargetEnvironmentRequest request) {
        if (javaCommandLineState == null) {
            TargetDebuggerConnectionUtil.$$$reportNull$$$0(0);
        }
        if (request == null) {
            TargetDebuggerConnectionUtil.$$$reportNull$$$0(1);
        }
        if ("Debug".equalsIgnoreCase(javaCommandLineState.getEnvironment().getExecutor().getId()) && !(request instanceof LocalTargetEnvironmentRequest)) {
            return 12345;
        }
        return null;
    }

    @Nullable
    public static TargetDebuggerConnection prepareDebuggerConnection(@NotNull JavaCommandLineState javaCommandLineState, @NotNull TargetEnvironmentRequest request) {
        JavaParameters javaParameters;
        if (javaCommandLineState == null) {
            TargetDebuggerConnectionUtil.$$$reportNull$$$0(2);
        }
        if (request == null) {
            TargetDebuggerConnectionUtil.$$$reportNull$$$0(3);
        }
        try {
            javaParameters = javaCommandLineState.getJavaParameters();
        }
        catch (ExecutionException e) {
            return null;
        }
        Integer remotePort2 = TargetDebuggerConnectionUtil.requiredDebuggerTargetPort(javaCommandLineState, request);
        if (remotePort2 == null) {
            return null;
        }
        int remotePort = remotePort2;
        try {
            boolean java9plus = Optional.ofNullable(request.getConfiguration()).map(TargetEnvironmentConfiguration::getRuntimes).map(list -> (JavaLanguageRuntimeConfiguration)list.findByType(JavaLanguageRuntimeConfiguration.class)).map(JavaLanguageRuntimeConfiguration::getJavaVersionString).filter(StringUtil::isNotEmpty).map(JavaSdkVersion::fromVersionString).map(v -> v.isAtLeast(JavaSdkVersion.JDK_1_9)).orElse(false);
            Object remoteAddressForVmParams = java9plus ? "0.0.0.0:" + remotePort : String.valueOf(remotePort);
            RemoteConnection remoteConnection = new RemoteConnectionBuilder(false, 0, (String)remoteAddressForVmParams).suspend(true).create(javaParameters);
            remoteConnection.setApplicationAddress(String.valueOf(remotePort));
            if (java9plus) {
                remoteConnection.setApplicationHostName("*");
            }
            return new TargetDebuggerConnection(remoteConnection, new TargetEnvironment.TargetPortBinding(null, remotePort));
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaCommandLineState";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/TargetDebuggerConnectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "requiredDebuggerTargetPort";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareDebuggerConnection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

