/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExtendableEditorSupport;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassEditorField
extends EditorTextField {
    public void setClassName(@Nullable String className) {
        String qName = ClassEditorField.getQName(className);
        this.setText(qName);
    }

    @Deprecated(forRemoval=true)
    public String getClassName() {
        return this.getJvmName(this.getText());
    }

    @NotNull
    public static ClassEditorField createClassField(Project project, Computable<? extends Module> moduleSelector, JavaCodeFragment.VisibilityChecker visibilityChecker, @Nullable BrowseModuleValueActionListener<?> classBrowser) {
        if (project.isDefault()) {
            return new ClassEditorField();
        }
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project).findPackage("");
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        PsiJavaCodeReferenceCodeFragment fragment = factory.createReferenceCodeFragment("", (PsiElement)defaultPackage, true, true);
        fragment.setVisibilityChecker(visibilityChecker);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
        final ClassEditorField field = new ClassEditorField(document, project, (FileType)JavaFileType.INSTANCE);
        if (classBrowser != null) {
            classBrowser.setTextAccessor((TextAccessor)field);
        }
        final ClassBrowser.AppClassBrowser<EditorTextField> browser = classBrowser != null ? classBrowser : new ClassBrowser.AppClassBrowser<EditorTextField>(project, moduleSelector){

            public String getText() {
                return field.getText();
            }

            public void actionPerformed(ActionEvent e) {
                String text = this.showDialog();
                if (text != null) {
                    field.setText(text);
                }
            }
        };
        field.addSettingsProvider(editor -> {
            ExtendableTextComponent.Extension extension = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.InlineVariables, (Icon)AllIcons.General.InlineVariablesHover, (String)ComponentWithBrowseButton.getTooltip(), (boolean)true, () -> browser.actionPerformed(null));
            ExtendableEditorSupport.setupExtension((EditorEx)editor, (Color)field.getBackground(), (ExtendableTextComponent.Extension)extension);
        });
        new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                browser.actionPerformed(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/application/ClassEditorField$2", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), (JComponent)((Object)field));
        ClassEditorField classEditorField = field;
        if (classEditorField == null) {
            ClassEditorField.$$$reportNull$$$0(0);
        }
        return classEditorField;
    }

    private ClassEditorField(Document document, Project project, FileType fileType) {
        super(document, project, fileType);
    }

    private ClassEditorField() {
    }

    @NotNull
    private static String getQName(@Nullable String className) {
        if (className == null) {
            return "";
        }
        String string = className.replace('$', '.');
        if (string == null) {
            ClassEditorField.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private String getJvmName(@Nullable String className) {
        if (className == null || className.isEmpty()) {
            return null;
        }
        return (String)FileBasedIndex.getInstance().ignoreDumbMode(DumbModeAccessType.RELIABLE_DATA_ONLY, () -> {
            PsiClass aClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject()));
            return aClass != null ? JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass) : className;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/application/ClassEditorField";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

