/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/application/JavaApplicationRunConfigurationImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationImporter;", "<init>", "()V", "process", "", "project", "Lcom/intellij/openapi/project/Project;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "cfg", "", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "canImport", "", "typeName", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "Companion", "intellij.java.execution.impl"})
public final class JavaApplicationRunConfigurationImporter
implements RunConfigurationImporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public void process(@NotNull Project project, @NotNull RunConfiguration runConfiguration, @NotNull Map<String, ?> cfg, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        if (!(runConfiguration instanceof ApplicationConfiguration)) {
            throw new IllegalArgumentException("Unexpected type of run configuration: " + runConfiguration.getClass());
        }
        ObjectUtils.consumeIfCast(cfg.get("moduleName"), String.class, arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$1(arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$0(modelsProvider, runConfiguration, arg_0), arg_0));
        ObjectUtils.consumeIfCast(cfg.get("mainClass"), String.class, arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$3(arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$2(runConfiguration, arg_0), arg_0));
        ObjectUtils.consumeIfCast(cfg.get("jvmArgs"), String.class, arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$5(arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$4(runConfiguration, arg_0), arg_0));
        ObjectUtils.consumeIfCast(cfg.get("programParameters"), String.class, arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$7(arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$6(runConfiguration, arg_0), arg_0));
        ObjectUtils.consumeIfCast(cfg.get("envs"), Map.class, arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$9(arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$8(runConfiguration, arg_0), arg_0));
        ObjectUtils.consumeIfCast(cfg.get("workingDirectory"), String.class, arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$11(arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$10(runConfiguration, arg_0), arg_0));
        Object obj = cfg.get("includeProvidedDependencies");
        Boolean bl = obj instanceof Boolean ? (Boolean)obj : null;
        ((ApplicationConfiguration)runConfiguration).setIncludeProvidedScope(bl != null ? bl : false);
        ObjectUtils.consumeIfCast(cfg.get("shortenCommandLine"), String.class, arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$13(arg_0 -> JavaApplicationRunConfigurationImporter.process$lambda$12(runConfiguration, arg_0), arg_0));
    }

    public boolean canImport(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return Intrinsics.areEqual((Object)typeName, (Object)"application");
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = ((ApplicationConfigurationType)ConfigurationTypeUtil.findConfigurationType(ApplicationConfigurationType.class)).getConfigurationFactories()[0];
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"get(...)");
        return configurationFactory;
    }

    private static final Unit process$lambda$0(IdeModifiableModelsProvider $modelsProvider, RunConfiguration $runConfiguration, String it) {
        Module module = $modelsProvider.getModifiableModuleModel().findModuleByName(it);
        if (module != null) {
            ((ApplicationConfiguration)$runConfiguration).setModule(module);
        }
        return Unit.INSTANCE;
    }

    private static final void process$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$2(RunConfiguration $runConfiguration, String it) {
        ((ApplicationConfiguration)$runConfiguration).setMainClassName(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$4(RunConfiguration $runConfiguration, String it) {
        ((ApplicationConfiguration)$runConfiguration).setVMParameters(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$6(RunConfiguration $runConfiguration, String it) {
        ((ApplicationConfiguration)$runConfiguration).setProgramParameters(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$8(RunConfiguration $runConfiguration, Map it) {
        ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)$runConfiguration;
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
        applicationConfiguration.setEnvs(TypeIntrinsics.asMutableMap((Object)it));
        return Unit.INSTANCE;
    }

    private static final void process$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$10(RunConfiguration $runConfiguration, String it) {
        ((ApplicationConfiguration)$runConfiguration).setWorkingDirectory(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$12(RunConfiguration $runConfiguration, String it) {
        try {
            ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)$runConfiguration;
            Intrinsics.checkNotNull((Object)it);
            applicationConfiguration.setShortenCommandLine(ShortenCommandLine.valueOf((String)it));
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Illegal value of 'shortenCommandLine': " + it, (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final void process$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(JavaApplicationRunConfigurationImporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/execution/application/JavaApplicationRunConfigurationImporter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.java.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

