/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ClassEditorField;
import com.intellij.execution.application.JavaSettingsEditorBase;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.CommonJavaFragments;
import com.intellij.execution.ui.CommonParameterFragments;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.ModuleClasspathCombo;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.execution.ui.TargetPathFragment;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Predicates;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class JavaApplicationSettingsEditor
extends JavaSettingsEditorBase<ApplicationConfiguration> {
    private SettingsEditorFragment<ApplicationConfiguration, MainClassPanel> myMainClassFragment;
    private final boolean myInitialIsImplicitClass;

    public JavaApplicationSettingsEditor(ApplicationConfiguration configuration) {
        super(configuration);
        this.myInitialIsImplicitClass = configuration.isImplicitClassConfiguration();
    }

    public boolean isInplaceValidationSupported() {
        return true;
    }

    @Override
    protected void customizeFragments(List<SettingsEditorFragment<ApplicationConfiguration, ?>> fragments, SettingsEditorFragment<ApplicationConfiguration, ModuleClasspathCombo> moduleClasspath, CommonParameterFragments<ApplicationConfiguration> commonParameterFragments) {
        fragments.add(SettingsEditorFragment.createTag((String)"include.provided", (String)ExecutionBundle.message((String)"application.configuration.include.provided.scope", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]), configuration -> configuration.getOptions().isIncludeProvidedScope(), (configuration, value) -> configuration.getOptions().setIncludeProvidedScope((boolean)value)));
        fragments.add(SettingsEditorFragment.createTag((String)"unnamed.class", (String)ExecutionBundle.message((String)"application.configuration.is.implicit.class", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]), configuration -> configuration.isImplicitClassConfiguration(), (configuration, value) -> {
            configuration.setImplicitClassConfiguration((boolean)value);
            this.updateMainClassFragment(configuration.isImplicitClassConfiguration());
        }));
        fragments.add(commonParameterFragments.programArguments());
        fragments.add((SettingsEditorFragment<ApplicationConfiguration, ?>)new TargetPathFragment());
        fragments.add(commonParameterFragments.createRedirectFragment());
        SettingsEditorFragment<ApplicationConfiguration, MainClassPanel> mainClassFragment = this.createMainClass((ModuleClasspathCombo)((Object)moduleClasspath.component()));
        fragments.add(mainClassFragment);
        DefaultJreSelector jreSelector = DefaultJreSelector.fromSourceRootsDependencies((ModuleClasspathCombo)((Object)moduleClasspath.component()), ((MainClassPanel)mainClassFragment.component()).getEditorTextField());
        SettingsEditorFragment jrePath = CommonJavaFragments.createJrePath(jreSelector);
        fragments.add(jrePath);
        fragments.add(this.createShortenClasspath((ModuleClasspathCombo)((Object)moduleClasspath.component()), jrePath, true));
    }

    @NotNull
    private SettingsEditorFragment<ApplicationConfiguration, MainClassPanel> createMainClass(ModuleClasspathCombo classpathCombo) {
        MainClassPanel mainClassPanel = new MainClassPanel(classpathCombo);
        this.myMainClassFragment = new SettingsEditorFragment<ApplicationConfiguration, MainClassPanel>(this, "mainClass", ExecutionBundle.message((String)"application.configuration.main.class", (Object[])new Object[0]), null, mainClassPanel, 20, (configuration, component) -> {
            String classNameInSettings = configuration.getMainClassName();
            mainClassPanel.setClassName(classNameInSettings);
        }, (configuration, component) -> {
            String classNameInEditor = mainClassPanel.getClassName();
            configuration.setMainClassName(classNameInEditor);
        }, Predicates.alwaysTrue()){};
        this.myMainClassFragment.setRemovable(false);
        this.myMainClassFragment.setEditorGetter(field -> field.getEditorComponent());
        this.myMainClassFragment.setValidation(configuration -> mainClassPanel.getValidation((ApplicationConfiguration)configuration));
        this.updateMainClassFragment(this.myInitialIsImplicitClass);
        SettingsEditorFragment<ApplicationConfiguration, MainClassPanel> settingsEditorFragment = this.myMainClassFragment;
        if (settingsEditorFragment == null) {
            JavaApplicationSettingsEditor.$$$reportNull$$$0(0);
        }
        return settingsEditorFragment;
    }

    private void updateMainClassFragment(boolean isImplicitClass) {
        if (this.myMainClassFragment == null) {
            return;
        }
        ((MainClassPanel)this.myMainClassFragment.component()).setImplicitClassConfiguration(isImplicitClass);
        if (isImplicitClass) {
            this.myMainClassFragment.setHint(ExecutionBundle.message((String)"application.configuration.main.class.unnamed.hint", (Object[])new Object[0]));
        } else {
            this.myMainClassFragment.setHint(ExecutionBundle.message((String)"application.configuration.main.class.hint", (Object[])new Object[0]));
        }
    }

    @NotNull
    static JavaCodeFragment.VisibilityChecker getVisibilityChecker(@NotNull ConfigurationModuleSelector selector) {
        if (selector == null) {
            JavaApplicationSettingsEditor.$$$reportNull$$$0(1);
        }
        JavaCodeFragment.VisibilityChecker visibilityChecker = (declaration, place) -> {
            PsiClass aClass;
            if (declaration instanceof PsiClass && (PsiMethodUtil.MAIN_CLASS.value((Object)(aClass = (PsiClass)declaration)) && PsiMethodUtil.findMainMethod((PsiClass)aClass) != null || place != null && place.getParent() != null && selector.findClass(aClass.getQualifiedName()) != null)) {
                return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
            }
            return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
        };
        if (visibilityChecker == null) {
            JavaApplicationSettingsEditor.$$$reportNull$$$0(2);
        }
        return visibilityChecker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/application/JavaApplicationSettingsEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/application/JavaApplicationSettingsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityChecker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityChecker";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private class MainClassPanel
    extends JPanel {
        private final ClassEditorField myClassEditorField;
        private final TextFieldWithAutoCompletion<String> myImplicitClassField;
        private boolean myIsImplicitClassConfiguration;

        private MainClassPanel(ModuleClasspathCombo classpathCombo) {
            super(new GridBagLayout());
            CommandLinePanel.setMinimumWidth((Component)this, (int)300);
            ConfigurationModuleSelector moduleSelector = new ConfigurationModuleSelector(JavaApplicationSettingsEditor.this.getProject(), classpathCombo);
            this.myClassEditorField = ClassEditorField.createClassField(JavaApplicationSettingsEditor.this.getProject(), (Computable<? extends Module>)((Computable)() -> classpathCombo.getSelectedModule()), JavaApplicationSettingsEditor.getVisibilityChecker(moduleSelector), null);
            this.myClassEditorField.setBackground(UIUtil.getTextFieldBackground());
            this.myClassEditorField.setShowPlaceholderWhenFocused(true);
            CommonParameterFragments.setMonospaced((Component)((Object)this.myClassEditorField));
            String placeholder = ExecutionBundle.message((String)"application.configuration.main.class.placeholder", (Object[])new Object[0]);
            this.myClassEditorField.setPlaceholder(placeholder);
            this.myClassEditorField.getAccessibleContext().setAccessibleName(placeholder);
            this.myClassEditorField.setVisible(!this.myIsImplicitClassConfiguration);
            CommandLinePanel.setMinimumWidth((Component)((Object)this.myClassEditorField), (int)300);
            GridBag constraints = new GridBag().setDefaultFill(2).setDefaultWeightX(1.0);
            this.add((Component)((Object)this.myClassEditorField), constraints.nextLine());
            this.myImplicitClassField = new TextFieldWithAutoCompletion(JavaApplicationSettingsEditor.this.getProject(), (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(null, AllIcons.FileTypes.Java){

                @NotNull
                public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                    Collection<String> collection = DumbService.isDumb((Project)JavaApplicationSettingsEditor.this.getProject()) ? List.of() : (Collection)ReadAction.compute(() -> StubIndex.getInstance().getAllKeys(JavaStubIndexKeys.IMPLICIT_CLASSES, JavaApplicationSettingsEditor.this.getProject()));
                    if (collection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return collection;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/application/JavaApplicationSettingsEditor$MainClassPanel$1", "getItems"));
                }
            }, true, null);
            CommonParameterFragments.setMonospaced(this.myImplicitClassField);
            String implicitClassPlaceholder = ExecutionBundle.message((String)"application.configuration.main.unnamed.class.placeholder", (Object[])new Object[0]);
            this.myImplicitClassField.setVisible(this.myIsImplicitClassConfiguration);
            this.myImplicitClassField.setPlaceholder((CharSequence)implicitClassPlaceholder);
            this.myImplicitClassField.getAccessibleContext().setAccessibleName(implicitClassPlaceholder);
            CommandLinePanel.setMinimumWidth(this.myImplicitClassField, (int)300);
            this.add((Component)this.myImplicitClassField, constraints.nextLine());
        }

        public EditorTextField getEditorTextField() {
            return this.myClassEditorField;
        }

        void setClassName(String name) {
            if (this.myIsImplicitClassConfiguration) {
                this.myImplicitClassField.setText(name);
            } else {
                this.myClassEditorField.setClassName(name);
            }
        }

        String getClassName() {
            return this.myIsImplicitClassConfiguration ? this.myImplicitClassField.getText() : this.myClassEditorField.getText();
        }

        void setImplicitClassConfiguration(boolean isImplicitClassConfiguration) {
            this.myIsImplicitClassConfiguration = isImplicitClassConfiguration;
            if (this.myClassEditorField != null) {
                this.myClassEditorField.setVisible(!isImplicitClassConfiguration);
                this.myImplicitClassField.setVisible(isImplicitClassConfiguration);
            }
        }

        List<ValidationInfo> getValidation(ApplicationConfiguration configuration) {
            return Collections.singletonList(RuntimeConfigurationException.validate(this.myIsImplicitClassConfiguration ? this.myImplicitClassField : this.myClassEditorField, () -> {
                if (!JavaApplicationSettingsEditor.this.isDefaultSettings()) {
                    configuration.checkClass();
                }
            }));
        }

        JComponent getEditorComponent() {
            if (this.myIsImplicitClassConfiguration) {
                return this.myImplicitClassField;
            }
            Editor editor = this.myClassEditorField.getEditor();
            return editor == null ? this.myClassEditorField : editor.getContentComponent();
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
            this.myImplicitClassField.addMouseListener(l);
            this.myClassEditorField.addMouseListener(l);
        }
    }
}

