/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.diagnostic.logging.LogsGroupFragment;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configuration.RunConfigurationExtensionsManager;
import com.intellij.execution.ui.BeforeRunComponent;
import com.intellij.execution.ui.BeforeRunFragment;
import com.intellij.execution.ui.ClasspathModifier;
import com.intellij.execution.ui.CommonJavaFragments;
import com.intellij.execution.ui.CommonParameterFragments;
import com.intellij.execution.ui.CommonTags;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.ui.ModuleClasspathCombo;
import com.intellij.execution.ui.RunConfigurationFragmentedEditor;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.execution.ui.ShortenCommandLineModeCombo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class JavaSettingsEditorBase<T extends JavaRunConfigurationBase>
extends RunConfigurationFragmentedEditor<T> {
    public JavaSettingsEditorBase(T runConfiguration) {
        super(runConfiguration, (RunConfigurationExtensionsManager)JavaRunConfigurationExtensionManager.getInstance());
    }

    protected List<SettingsEditorFragment<T, ?>> createRunFragments() {
        JrePathEditor editor;
        JComponent jComponent;
        ArrayList fragments = new ArrayList();
        BeforeRunComponent beforeRunComponent = new BeforeRunComponent((Disposable)this);
        fragments.add((SettingsEditorFragment<T, ?>)BeforeRunFragment.createBeforeRun((BeforeRunComponent)beforeRunComponent, CompileStepBeforeRun.ID));
        fragments.addAll(BeforeRunFragment.createGroup());
        SettingsEditorFragment moduleClasspath = CommonJavaFragments.moduleClasspath();
        ModuleClasspathCombo classpathCombo = (ModuleClasspathCombo)((Object)moduleClasspath.component());
        Computable hasModule = () -> classpathCombo.getSelectedModule() != null;
        fragments.add(CommonTags.parallelRun());
        CommonParameterFragments commonParameterFragments = new CommonParameterFragments(this.getProject(), () -> classpathCombo.getSelectedModule());
        fragments.addAll(commonParameterFragments.getFragments());
        fragments.add(CommonJavaFragments.createBuildBeforeRun(beforeRunComponent, this));
        fragments.add(moduleClasspath);
        fragments.add(new ClasspathModifier((JavaRunConfigurationBase)this.mySettings));
        this.customizeFragments(fragments, moduleClasspath, commonParameterFragments);
        SettingsEditorFragment jrePath = (SettingsEditorFragment)ContainerUtil.find(fragments, f -> "jrePath".equals(f.getId()));
        JrePathEditor jrePathEditor = jrePath != null && (jComponent = jrePath.getComponent()) instanceof JrePathEditor ? (editor = (JrePathEditor)((Object)jComponent)) : null;
        SettingsEditorFragment vmParameters = CommonJavaFragments.vmOptionsEx((JavaRunConfigurationBase)this.mySettings, (Computable<Boolean>)hasModule, jrePathEditor);
        fragments.add(vmParameters);
        fragments.add((SettingsEditorFragment<T, ?>)new LogsGroupFragment());
        return fragments;
    }

    @NotNull
    protected SettingsEditorFragment<T, LabeledComponent<ShortenCommandLineModeCombo>> createShortenClasspath(ModuleClasspathCombo classpathCombo, SettingsEditorFragment<T, JrePathEditor> jrePath, final boolean productionOnly) {
        ShortenCommandLineModeCombo combo = new ShortenCommandLineModeCombo(this.getProject(), (JrePathEditor)((Object)jrePath.component()), () -> classpathCombo.getSelectedModule(), listener -> classpathCombo.addActionListener((ActionListener)listener)){

            @Override
            protected boolean productionOnly() {
                return productionOnly;
            }
        };
        LabeledComponent component = LabeledComponent.create((JComponent)((Object)combo), (String)ExecutionBundle.message((String)"application.configuration.shorten.command.line.label", (Object[])new Object[0]), (String)"West");
        SettingsEditorFragment fragment = new SettingsEditorFragment("shorten.command.line", ExecutionBundle.message((String)"application.configuration.shorten.command.line", (Object[])new Object[0]), ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]), (JComponent)component, (t, c) -> ((ShortenCommandLineModeCombo)((Object)((Object)c.getComponent()))).setItem(t.getShortenCommandLine()), (t, c) -> t.setShortenCommandLine(c.isVisible() ? ((ShortenCommandLineModeCombo)((Object)((Object)c.getComponent()))).getSelectedItem() : null), configuration -> configuration.getShortenCommandLine() != null);
        fragment.setActionHint(ExecutionBundle.message((String)"select.a.method.to.shorten.the.command.if.it.exceeds.the.os.limit", (Object[])new Object[0]));
        SettingsEditorFragment settingsEditorFragment = fragment;
        if (settingsEditorFragment == null) {
            JavaSettingsEditorBase.$$$reportNull$$$0(0);
        }
        return settingsEditorFragment;
    }

    protected abstract void customizeFragments(List<SettingsEditorFragment<T, ?>> var1, SettingsEditorFragment<T, ModuleClasspathCombo> var2, CommonParameterFragments<T> var3);

    public void targetChanged(String targetName) {
        super.targetChanged(targetName);
        SettingsEditorFragment fragment = (SettingsEditorFragment)ContainerUtil.find((Iterable)this.getFragments(), f -> "jrePath".equals(f.getId()));
        if (fragment != null && ((JrePathEditor)((Object)fragment.component())).updateModel(this.getProject(), targetName)) {
            fragment.resetFrom((Object)((JavaRunConfigurationBase)this.mySettings));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/application/JavaSettingsEditorBase", "createShortenClasspath"));
    }
}

